/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.wim.adapter.urbridge.utils;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.security.EntryNotFoundException;
import com.ibm.websphere.security.NotImplementedException;
import com.ibm.websphere.security.wim.ras.WIMMessageHelper;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.wim.adapter.urbridge.URBridge;
import com.ibm.ws.security.wim.adapter.urbridge.utils.URBridgeEntity;
import com.ibm.ws.security.wim.adapter.urbridge.utils.URBridgeEntityFactory;
import com.ibm.wsspi.security.wim.exception.EntityNotFoundException;
import com.ibm.wsspi.security.wim.exception.WIMApplicationException;
import com.ibm.wsspi.security.wim.exception.WIMException;
import com.ibm.wsspi.security.wim.model.Entity;
import com.ibm.wsspi.security.wim.model.Group;
import com.ibm.wsspi.security.wim.model.IdentifierType;
import com.ibm.wsspi.security.wim.model.Root;
import java.util.List;
import java.util.Map;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class URBridgePerson
extends URBridgeEntity {
    private static final TraceComponent tc = Tr.register(URBridgePerson.class, (String)"wimUtil", (String)"com.ibm.ws.security.wim.util.resources.WimUtilMessages");
    static final long serialVersionUID = -2787908203962583441L;

    public URBridgePerson(Entity inEntity, URBridge urBridge, Map<String, String> inAttrMap, String inBaseEntry, Map<String, String> inEntityConfigMap) {
        super(inEntity, urBridge, inAttrMap, inBaseEntry, inEntityConfigMap);
        this.securityNameProp = inAttrMap.get("userSecurityNameProperty");
        this.uniqueIdProp = inAttrMap.get("uniqueUserIdProperty");
        this.displayNameProp = inAttrMap.get("userDisplayNameProperty");
        this.rdnProp = inEntityConfigMap.get(this.entity.getTypeName());
    }

    @Override
    public String getUniqueIdForEntity(String securityName) throws Exception {
        return this.urBridge.getUniqueUserId(securityName);
    }

    @Override
    public String getSecurityNameForEntity(String uniqueId) throws Exception {
        return this.urBridge.getUserSecurityName(uniqueId);
    }

    @Override
    public String getDisplayNameForEntity(String securityName) throws Exception {
        return this.urBridge.getUserDisplayName(securityName);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void getGroupsForUser(List<String> grpMbrshipAttrs, int countLimit) throws WIMException {
        String securityName = null;
        try {
            securityName = this.getSecurityName(false);
            List<String> returnNames = this.urBridge.getGroupsForUser(securityName);
            countLimit = countLimit == 0 ? returnNames.size() : countLimit;
            countLimit = countLimit < 0 ? 0 : countLimit;
            countLimit = returnNames.size() > countLimit ? countLimit : returnNames.size();
            for (int j = 0; j < countLimit; ++j) {
                Root fakeRoot = new Root();
                Group memberDO = new Group();
                fakeRoot.getEntities().add(memberDO);
                IdentifierType identifier = new IdentifierType();
                memberDO.setIdentifier(identifier);
                URBridgeEntityFactory osFactory = new URBridgeEntityFactory();
                URBridgeEntity osEntity = osFactory.createObject((Entity)memberDO, this.urBridge, this.attrMap, this.baseEntryName, this.entityConfigMap);
                osEntity.setSecurityNameProp(returnNames.get(j));
                osEntity.populateEntity(grpMbrshipAttrs);
                osEntity.setRDNPropValue(returnNames.get(j));
                this.entity.getGroups().add(memberDO);
            }
        }
        catch (EntryNotFoundException returnNames) {
            FFDCFilter.processException((Throwable)returnNames, (String)"com.ibm.ws.security.wim.adapter.urbridge.utils.URBridgePerson", (String)"132", (Object)this, (Object[])new Object[]{grpMbrshipAttrs, countLimit});
            throw new EntityNotFoundException("ENTITY_NOT_FOUND", Tr.formatMessage((TraceComponent)tc, (String)"ENTITY_NOT_FOUND", (Object[])WIMMessageHelper.generateMsgParms((Object)securityName)));
        }
        catch (NotImplementedException enfe) {
            FFDCFilter.processException((Throwable)enfe, (String)"com.ibm.ws.security.wim.adapter.urbridge.utils.URBridgePerson", (String)"135", (Object)this, (Object[])new Object[]{grpMbrshipAttrs, countLimit});
            throw new EntityNotFoundException("ENTITY_NOT_FOUND", Tr.formatMessage((TraceComponent)tc, (String)"ENTITY_NOT_FOUND", (Object[])WIMMessageHelper.generateMsgParms((Object)securityName)));
        }
        catch (Exception nie) {
            void e;
            FFDCFilter.processException((Throwable)nie, (String)"com.ibm.ws.security.wim.adapter.urbridge.utils.URBridgePerson", (String)"138", (Object)this, (Object[])new Object[]{grpMbrshipAttrs, countLimit});
            throw new WIMApplicationException("ENTITY_GET_FAILED", Tr.formatMessage((TraceComponent)tc, (String)"ENTITY_GET_FAILED", (Object[])WIMMessageHelper.generateMsgParms((Object)securityName, (Object)e.toString())));
        }
    }
}

