/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.executor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;
import org.jboss.weld.Container;
import org.jboss.weld.bootstrap.api.Environments;
import org.jboss.weld.executor.AbstractExecutorServices;

public class CommonForkJoinPoolExecutorServices
extends AbstractExecutorServices {
    @Override
    public ExecutorService getTaskExecutor() {
        return ForkJoinPool.commonPool();
    }

    @Override
    public void cleanup() {
    }

    @Override
    protected int getThreadPoolSize() {
        return ForkJoinPool.getCommonPoolParallelism();
    }

    @Override
    public <T> Collection<? extends Callable<T>> wrap(Collection<? extends Callable<T>> tasks) {
        if (Container.getEnvironment().equals(Environments.SE)) {
            ArrayList<Callable<Object>> wrapped = new ArrayList<Callable<Object>>(tasks.size());
            for (Callable task : tasks) {
                wrapped.add(() -> {
                    ClassLoader oldTccl = Thread.currentThread().getContextClassLoader();
                    Thread.currentThread().setContextClassLoader(null);
                    try {
                        Object v = task.call();
                        return v;
                    }
                    finally {
                        Thread.currentThread().setContextClassLoader(oldTccl);
                    }
                });
            }
            return wrapped;
        }
        return tasks;
    }
}

