/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.annocache.jandex.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.annocache.jandex.internal.PackedDataInputStream;
import com.ibm.ws.annocache.jandex.internal.SparseIndex;
import com.ibm.ws.annocache.jandex.internal.SparseIndexReaderVersion;
import com.ibm.ws.annocache.jandex.internal.SparseIndexReaderVersionImpl_V1;
import com.ibm.ws.annocache.jandex.internal.SparseIndexReaderVersionImpl_V2;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.IOException;
import java.io.InputStream;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public final class SparseIndexReader {
    public static final int MAGIC = -1161945323;
    private final int version;
    private final SparseIndex sparseIndex;
    static final long serialVersionUID = 5561321915849242492L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public static SparseIndexReaderVersion createReader(PackedDataInputStream input, int version) {
        if (SparseIndexReaderVersionImpl_V1.accept(version)) {
            return new SparseIndexReaderVersionImpl_V1(input, version);
        }
        if (SparseIndexReaderVersionImpl_V2.accept(version)) {
            return new SparseIndexReaderVersionImpl_V2(input, version);
        }
        return null;
    }

    public SparseIndexReader(InputStream input) throws IOException {
        PackedDataInputStream packedInput = new PackedDataInputStream(input);
        int actualBytes = packedInput.readInt();
        if (actualBytes != -1161945323) {
            throw new IllegalArgumentException("Read [ 0x" + Integer.toHexString(actualBytes) + " ] expecting Jandex magic bytes [ 0x" + Integer.toHexString(-1161945323) + " ]");
        }
        this.version = packedInput.readUnsignedByte();
        SparseIndexReaderVersion reader = SparseIndexReader.createReader(packedInput, this.version);
        if (reader == null) {
            throw new IllegalArgumentException("Unsupported index version [ " + Integer.toString(this.version) + " ]");
        }
        this.sparseIndex = reader.read();
    }

    public int getVersion() {
        return this.version;
    }

    public SparseIndex getIndex() {
        return this.sparseIndex;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.annocache.jandex.internal.SparseIndexReader", SparseIndexReader.class, (String)"com.ibm.ws.annocache", (String)"com.ibm.ws.anno.resources.internal.AnnoMessages");
    }
}

