/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.attachment;

import jakarta.activation.CommandInfo;
import jakarta.activation.CommandMap;
import jakarta.activation.DataContentHandler;
import jakarta.activation.DataHandler;
import jakarta.activation.DataSource;
import jakarta.activation.FileDataSource;
import jakarta.activation.MailcapCommandMap;
import jakarta.activation.URLDataSource;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.attachment.AttachmentDataSource;
import org.apache.cxf.attachment.AttachmentImpl;
import org.apache.cxf.attachment.Base64DecoderStream;
import org.apache.cxf.attachment.ByteDataSource;
import org.apache.cxf.attachment.ContentDisposition;
import org.apache.cxf.attachment.ImageDataContentHandler;
import org.apache.cxf.attachment.LazyAttachmentCollection;
import org.apache.cxf.attachment.LazyDataSource;
import org.apache.cxf.attachment.QuotedPrintableDecoderStream;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.PropertyUtils;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.common.util.SystemPropertyAction;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.helpers.HttpHeaderHelper;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.io.CachedOutputStream;
import org.apache.cxf.message.Attachment;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.service.model.EndpointInfo;

public final class AttachmentUtil {
    public static final String ATTACHMENT_XOP_FOLLOW_URLS_PROPERTY = "org.apache.cxf.attachment.xop.follow.urls";
    public static final String BODY_ATTACHMENT_ID = "root.message@cxf.apache.org";
    private static volatile int counter;
    private static final String ATT_UUID;
    private static final Random BOUND_RANDOM;
    private static final CommandMap DEFAULT_COMMAND_MAP;
    private static final MailcapCommandMap COMMAND_MAP;
    private static final Logger LOG;
    public static final String IBM_MTOM_ENABLED = "ibm-mtom-enabled";

    private AttachmentUtil() {
    }

    public static CommandMap getCommandMap() {
        return COMMAND_MAP;
    }

    public static boolean isMtomEnabled(Message message) {
        boolean mtomEnabled = false;
        mtomEnabled = MessageUtils.getContextualBoolean(message, "mtom-enabled", false);
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("MTOM enabled: " + mtomEnabled);
        }
        return mtomEnabled;
    }

    public static void setStreamedAttachmentProperties(Message message, CachedOutputStream bos) throws IOException {
        Object directory = message.getContextualProperty("attachment-directory");
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest("setStreamedAttachmentProperties: Attachment directory: " + directory);
        }
        if (directory != null) {
            if (directory instanceof File) {
                bos.setOutputDir((File)directory);
            } else {
                bos.setOutputDir(new File((String)directory));
            }
        }
        Object threshold = message.getContextualProperty("attachment-memory-threshold");
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("setStreamedAttachmentProperties: Attachment memory threshold: " + threshold);
        }
        if (threshold != null) {
            if (threshold instanceof Long) {
                bos.setThreshold((Long)threshold);
            } else {
                bos.setThreshold(Long.parseLong((String)threshold));
            }
        } else {
            bos.setThreshold(102400L);
        }
        Object maxSize = message.getContextualProperty("attachment-max-size");
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest("setStreamedAttachmentProperties: Attachment maxSize: " + maxSize);
        }
        if (maxSize != null) {
            if (maxSize instanceof Long) {
                bos.setMaxSize((Long)maxSize);
            } else {
                bos.setMaxSize(Long.parseLong((String)maxSize));
            }
        }
    }

    public static String createContentID(String ns) throws UnsupportedEncodingException {
        String cid = "cxf.apache.org";
        String name = ATT_UUID + "-" + String.valueOf(++counter);
        if (ns != null && ns.length() > 0) {
            try {
                URI uri = new URI(ns);
                String host = uri.getHost();
                cid = host != null ? host : ns;
            }
            catch (Exception e) {
                if (LOG.isLoggable(Level.FINEST)) {
                    LOG.finest("createContentID caught exception: " + e + " setting cid to ns: " + ns);
                }
                cid = ns;
            }
        }
        String ret_cid = URLEncoder.encode(name, StandardCharsets.UTF_8.name()) + "@" + URLEncoder.encode(cid, StandardCharsets.UTF_8.name());
        return ret_cid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getUniqueBoundaryValue() {
        long leastSigBits = 0L;
        long mostSigBits = 0L;
        Random random = BOUND_RANDOM;
        synchronized (random) {
            mostSigBits = BOUND_RANDOM.nextLong();
            leastSigBits = BOUND_RANDOM.nextLong();
        }
        mostSigBits &= 0xFFFFFFFFFFFF0FFFL;
        leastSigBits &= 0x3FFFFFFFFFFFFFFFL;
        UUID result = new UUID(mostSigBits |= 0x4000L, leastSigBits |= Long.MIN_VALUE);
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest("getUniqueBoundaryValue returning : uuid:" + result.toString());
        }
        return "uuid:" + result.toString();
    }

    public static String getAttachmentPartHeader(Attachment att) {
        String id;
        StringBuilder buffer = new StringBuilder(200);
        buffer.append(HttpHeaderHelper.getHeaderKey("Content-Type") + ": " + att.getDataHandler().getContentType() + ";\r\n");
        if (att.isXOP()) {
            buffer.append("Content-Transfer-Encoding: binary\r\n");
        }
        if ((id = att.getId()).charAt(0) == '<') {
            id = id.substring(1, id.length() - 1);
        }
        buffer.append("Content-ID: <" + id + ">\r\n\r\n");
        return buffer.toString();
    }

    public static Map<String, DataHandler> getDHMap(Collection<Attachment> attachments) {
        DHMap dataHandlers = null;
        if (attachments != null) {
            dataHandlers = attachments instanceof LazyAttachmentCollection ? ((LazyAttachmentCollection)attachments).createDataHandlerMap() : new DHMap(attachments);
        }
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest("getDHMap: dataHandlers" + dataHandlers);
        }
        return dataHandlers == null ? new LinkedHashMap() : dataHandlers;
    }

    public static String cleanContentId(String id) {
        block6: {
            if (id != null) {
                if (id.startsWith("<")) {
                    id = id.substring(1, id.length() - 1);
                }
                if (id.startsWith("cid:")) {
                    id = id.substring(4);
                }
                try {
                    id = URLDecoder.decode(id, StandardCharsets.UTF_8.name());
                }
                catch (UnsupportedEncodingException e) {
                    if (!LOG.isLoggable(Level.FINEST)) break block6;
                    LOG.finest("cleanContentId ignoring UnsupportedEncodingException: " + e);
                }
            }
        }
        if (id == null) {
            id = BODY_ATTACHMENT_ID;
        }
        return id;
    }

    static String getHeaderValue(List<String> v) {
        if (v != null && !v.isEmpty()) {
            return v.get(0);
        }
        return null;
    }

    static String getHeaderValue(List<String> v, String delim) {
        if (v != null && !v.isEmpty()) {
            StringBuilder b = new StringBuilder();
            for (String s : v) {
                if (b.length() > 0) {
                    b.append(delim);
                }
                b.append(s);
            }
            return b.toString();
        }
        return null;
    }

    static String getHeader(Map<String, List<String>> headers, String h) {
        return AttachmentUtil.getHeaderValue(headers.get(h));
    }

    static String getHeader(Map<String, List<String>> headers, String h, String delim) {
        return AttachmentUtil.getHeaderValue(headers.get(h), delim);
    }

    public static Attachment createAttachment(InputStream stream, Map<String, List<String>> headers) throws IOException {
        InputStream ins;
        String id = AttachmentUtil.cleanContentId(AttachmentUtil.getHeader(headers, "Content-ID"));
        AttachmentImpl att = new AttachmentImpl(id);
        String ct = AttachmentUtil.getHeader(headers, "Content-Type");
        String cd = AttachmentUtil.getHeader(headers, "Content-Disposition");
        String fileName = AttachmentUtil.getContentDispositionFileName(cd);
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest("createAttachment: Content-ID: " + id + ", Content-Type: " + ct + ", Content-Disposition: " + cd + ", filename: " + fileName);
        }
        String encoding = null;
        for (Map.Entry<String, List<String>> e : headers.entrySet()) {
            String name = e.getKey();
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest("createAttachment processing header: " + name);
            }
            if (name.equalsIgnoreCase("Content-Transfer-Encoding") && "binary".equalsIgnoreCase(encoding = AttachmentUtil.getHeader(headers, name))) {
                att.setXOP(true);
            }
            att.setHeader(name, AttachmentUtil.getHeaderValue(e.getValue()));
        }
        if (encoding == null) {
            encoding = "binary";
        }
        if ((ins = AttachmentUtil.decode(stream, encoding)) != stream) {
            headers.remove("Content-Transfer-Encoding");
        }
        AttachmentDataSource source = new AttachmentDataSource(ct, ins);
        if (!StringUtils.isEmpty(fileName)) {
            source.setName(fileName);
        }
        att.setDataHandler(new DataHandler((DataSource)source));
        return att;
    }

    static String getContentDispositionFileName(String cd) {
        if (StringUtils.isEmpty(cd)) {
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest("getContentDispositionFileName returning NULL");
            }
            return null;
        }
        ContentDisposition c = new ContentDisposition(cd);
        String s = c.getParameter("filename");
        if (s == null) {
            s = c.getParameter("name");
        }
        return s;
    }

    public static InputStream decode(InputStream in, String encoding) throws IOException {
        if (encoding == null) {
            return in;
        }
        if ("binary".equals(encoding = encoding.toLowerCase()) || "7bit".equals(encoding) || "8bit".equals(encoding)) {
            return in;
        }
        if ("base64".equals(encoding)) {
            return new Base64DecoderStream(in);
        }
        if ("quoted-printable".equals(encoding)) {
            return new QuotedPrintableDecoderStream(in);
        }
        throw new IOException("Unknown encoding " + encoding);
    }

    public static boolean isTypeSupported(String contentType, List<String> types) {
        if (contentType == null) {
            return false;
        }
        contentType = contentType.toLowerCase();
        for (String s : types) {
            if (contentType.indexOf(s) == -1) continue;
            return true;
        }
        return false;
    }

    public static Attachment createMtomAttachment(boolean isXop, String mimeType, String elementNS, byte[] data, int offset, int length, int threshold) {
        String id;
        if (!isXop || length <= threshold) {
            return null;
        }
        if (mimeType == null) {
            mimeType = "application/octet-stream";
        }
        ByteDataSource source = new ByteDataSource(data, offset, length);
        source.setContentType(mimeType);
        DataHandler handler = new DataHandler((DataSource)source);
        try {
            id = AttachmentUtil.createContentID(elementNS);
        }
        catch (UnsupportedEncodingException e) {
            throw new Fault(e);
        }
        AttachmentImpl att = new AttachmentImpl(id, handler);
        att.setXOP(isXop);
        return att;
    }

    public static Attachment createMtomAttachmentFromDH(boolean isXop, DataHandler handler, String elementNS, int threshold) {
        String id;
        Object file;
        block16: {
            if (!isXop) {
                return null;
            }
            try {
                DataSource ds = handler.getDataSource();
                if (ds instanceof FileDataSource) {
                    FileDataSource fds = (FileDataSource)ds;
                    file = fds.getFile();
                    if (((File)file).length() < (long)threshold) {
                        if (LOG.isLoggable(Level.FINEST)) {
                            LOG.finest("createMtomAttachmentFromDH: file.length is < threshold: " + ((File)file).length());
                        }
                        return null;
                    }
                } else if (ds.getClass().getName().endsWith("ObjectDataSource")) {
                    Object o = handler.getContent();
                    if (o instanceof String && ((String)o).length() < threshold) {
                        if (LOG.isLoggable(Level.FINEST)) {
                            LOG.finest("createMtomAttachmentFromDH: handler size is < threshold: " + ((String)o).length());
                        }
                        return null;
                    }
                    if (o instanceof byte[] && ((byte[])o).length < threshold) {
                        if (LOG.isLoggable(Level.FINEST)) {
                            LOG.finest("createMtomAttachmentFromDH: byte size is < threshold: " + ((byte[])o).length);
                        }
                        return null;
                    }
                }
            }
            catch (IOException e1) {
                if (!LOG.isLoggable(Level.FINEST)) break block16;
                LOG.finest("Ignoring IOException: " + e1);
            }
        }
        try {
            id = AttachmentUtil.createContentID(elementNS);
        }
        catch (UnsupportedEncodingException e) {
            throw new Fault(e);
        }
        AttachmentImpl att = new AttachmentImpl(id, handler);
        if (!StringUtils.isEmpty(handler.getName())) {
            file = handler.getName();
            File f = new File((String)file);
            if (f.exists() && f.isFile()) {
                file = f.getName();
            }
            att.setHeader("Content-Disposition", "attachment;name=\"" + (String)file + "\"");
        }
        att.setXOP(isXop);
        return att;
    }

    public static DataSource getAttachmentDataSource(String contentId, Collection<Attachment> atts) {
        if (contentId.startsWith("cid:")) {
            try {
                contentId = URLDecoder.decode(contentId.substring(4), StandardCharsets.UTF_8.name());
            }
            catch (UnsupportedEncodingException ue) {
                if (LOG.isLoggable(Level.FINEST)) {
                    LOG.finest("UnsupportedEncodingException occurred: " + ue);
                }
                contentId = contentId.substring(4);
            }
            if (contentId.indexOf("://") == -1) {
                return AttachmentUtil.loadDataSource(contentId, atts);
            }
            try {
                boolean followUrls = Boolean.valueOf(SystemPropertyAction.getProperty(ATTACHMENT_XOP_FOLLOW_URLS_PROPERTY, "false"));
                if (LOG.isLoggable(Level.FINEST)) {
                    LOG.finest("org.apache.cxf.attachment.xop.follow.urls property is set to: " + followUrls);
                }
                if (followUrls) {
                    return new URLDataSource(new URL(contentId));
                }
                return AttachmentUtil.loadDataSource(contentId, atts);
            }
            catch (MalformedURLException e) {
                throw new Fault(e);
            }
        }
        return AttachmentUtil.loadDataSource(contentId, atts);
    }

    private static DataSource loadDataSource(String contentId, Collection<Attachment> atts) {
        return new LazyDataSource(contentId, atts);
    }

    public static boolean mtomOverride(Message message, boolean defaultValue) {
        boolean mtomEnabled = defaultValue;
        Object mtomEnabledBySystemProperty = AttachmentUtil.getPropertyFromEndPointInfo(message, IBM_MTOM_ENABLED);
        if (!MessageUtils.isRequestor(message) && mtomEnabledBySystemProperty != null) {
            mtomEnabled = PropertyUtils.isTrue(mtomEnabledBySystemProperty);
        }
        return mtomEnabled;
    }

    public static Object getPropertyFromEndPointInfo(Message message, String propertyName) {
        EndpointInfo endpointInfo;
        Object propertyValue = null;
        Endpoint endpoint = message.getExchange().getEndpoint();
        if (endpoint != null && (endpointInfo = endpoint.getEndpointInfo()) != null) {
            propertyValue = endpointInfo.getProperty(propertyName);
        }
        return propertyValue;
    }

    static {
        ATT_UUID = UUID.randomUUID().toString();
        BOUND_RANDOM = new Random();
        DEFAULT_COMMAND_MAP = CommandMap.getDefaultCommandMap();
        COMMAND_MAP = new EnhancedMailcapCommandMap();
        LOG = LogUtils.getL7dLogger(AttachmentUtil.class);
        COMMAND_MAP.addMailcap("image/*;;x-java-content-handler=" + ImageDataContentHandler.class.getName());
    }

    static class DHMap
    extends AbstractMap<String, DataHandler> {
        final Collection<Attachment> list;

        DHMap(Collection<Attachment> l) {
            this.list = l;
        }

        @Override
        public Set<Map.Entry<String, DataHandler>> entrySet() {
            return new AbstractSet<Map.Entry<String, DataHandler>>(){

                @Override
                public Iterator<Map.Entry<String, DataHandler>> iterator() {
                    final Iterator<Attachment> it = list.iterator();
                    return new Iterator<Map.Entry<String, DataHandler>>(){

                        @Override
                        public boolean hasNext() {
                            return it.hasNext();
                        }

                        @Override
                        public Map.Entry<String, DataHandler> next() {
                            final Attachment a = (Attachment)it.next();
                            return new Map.Entry<String, DataHandler>(){

                                @Override
                                public String getKey() {
                                    return a.getId();
                                }

                                @Override
                                public DataHandler getValue() {
                                    return a.getDataHandler();
                                }

                                @Override
                                public DataHandler setValue(DataHandler value) {
                                    return null;
                                }
                            };
                        }

                        @Override
                        public void remove() {
                            it.remove();
                        }
                    };
                }

                @Override
                public int size() {
                    return list.size();
                }
            };
        }

        @Override
        public DataHandler put(String key, DataHandler value) {
            Iterator<Attachment> i = this.list.iterator();
            DataHandler ret = null;
            while (i.hasNext()) {
                Attachment a = i.next();
                if (!a.getId().equals(key)) continue;
                i.remove();
                ret = a.getDataHandler();
                break;
            }
            this.list.add(new AttachmentImpl(key, value));
            return ret;
        }
    }

    static final class EnhancedMailcapCommandMap
    extends MailcapCommandMap {
        EnhancedMailcapCommandMap() {
        }

        public synchronized DataContentHandler createDataContentHandler(String mimeType) {
            DataContentHandler dch = super.createDataContentHandler(mimeType);
            if (dch == null) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("createDataContentHandler using DEFAULT_COMMAND_MAP");
                }
                dch = DEFAULT_COMMAND_MAP.createDataContentHandler(mimeType);
            }
            return dch;
        }

        public DataContentHandler createDataContentHandler(String mimeType, DataSource ds) {
            DataContentHandler dch = super.createDataContentHandler(mimeType);
            if (dch == null) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("createDataContentHandler using DEFAULT_COMMAND_MAP for DataSource: " + (ds != null ? ds.getName() : "NULL"));
                }
                dch = DEFAULT_COMMAND_MAP.createDataContentHandler(mimeType, ds);
            }
            return dch;
        }

        public synchronized CommandInfo[] getAllCommands(String mimeType) {
            boolean isFinestEnabled = LOG.isLoggable(Level.FINEST);
            CommandInfo[] commands = super.getAllCommands(mimeType);
            CommandInfo[] defaultCommands = DEFAULT_COMMAND_MAP.getAllCommands(mimeType);
            ArrayList<CommandInfo> cmdList = new ArrayList<CommandInfo>(Arrays.asList(commands));
            for (CommandInfo defCmdInfo : defaultCommands) {
                String defCmdName = defCmdInfo.getCommandName();
                boolean cmdNameExist = false;
                for (CommandInfo cmdInfo : commands) {
                    if (isFinestEnabled) {
                        LOG.finest("getAllCommands: processing cmd: " + cmdInfo.getCommandName());
                    }
                    if (!cmdInfo.getCommandName().equals(defCmdName)) continue;
                    cmdNameExist = true;
                    if (!isFinestEnabled) break;
                    LOG.finest("getAllCommands: Found command " + defCmdName);
                    break;
                }
                if (cmdNameExist) continue;
                if (isFinestEnabled) {
                    LOG.finest("getAllCommands: Cmd does not exist, using default: " + defCmdName);
                }
                cmdList.add(defCmdInfo);
            }
            CommandInfo[] allCommandArray = new CommandInfo[]{};
            return cmdList.toArray(allCommandArray);
        }

        public synchronized CommandInfo getCommand(String mimeType, String cmdName) {
            CommandInfo cmdInfo = super.getCommand(mimeType, cmdName);
            if (cmdInfo == null) {
                if (LOG.isLoggable(Level.FINEST)) {
                    LOG.finest("super getCommand returned null, so using default");
                }
                cmdInfo = DEFAULT_COMMAND_MAP.getCommand(mimeType, cmdName);
            }
            return cmdInfo;
        }

        public synchronized String[] getMimeTypes() {
            String[] mimeTypes = super.getMimeTypes();
            String[] defMimeTypes = DEFAULT_COMMAND_MAP.getMimeTypes();
            HashSet<String> mimeTypeSet = new HashSet<String>();
            mimeTypeSet.addAll(Arrays.asList(mimeTypes));
            mimeTypeSet.addAll(Arrays.asList(defMimeTypes));
            String[] mimeArray = new String[]{};
            return mimeTypeSet.toArray(mimeArray);
        }
    }
}

