/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.util;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ws.webcontainer.core.Request;
import com.ibm.ws.webcontainer.core.RequestMapper;
import com.ibm.ws.webcontainer.util.VirtualHostMapper;
import com.ibm.ws.webcontainer.webapp.WebGroup;
import com.ibm.wsspi.webcontainer.RequestProcessor;
import com.ibm.wsspi.webcontainer.logging.LoggerFactory;
import com.ibm.wsspi.webcontainer.util.URIMapper;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class VirtualHostContextRootMapper
extends VirtualHostMapper
implements RequestMapper {
    private static Map cachedMappers = Collections.synchronizedMap(new HashMap());
    protected static TraceNLS nls = TraceNLS.getTraceNLS(VirtualHostContextRootMapper.class, (String)"com.ibm.ws.webcontainer.resources.Messages");
    protected static Logger logger = LoggerFactory.getInstance().getLogger("com.ibm.ws.webcontainer.util");
    private static final String CLASS_NAME = "com.ibm.ws.webcontainer.util.VirtualHostContextRootMapper";

    @Override
    public RequestProcessor map(String matchString) {
        int slashIndex = matchString.indexOf(47);
        if (slashIndex != -1) {
            RequestProcessor virtualHostProcessor;
            String vHost = matchString.substring(0, slashIndex);
            String relativePath = matchString.substring(slashIndex);
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "map", " vHost [" + vHost + "] relativePath [" + relativePath + "]");
            }
            if ((virtualHostProcessor = (RequestProcessor)cachedMappers.get(vHost)) == null) {
                virtualHostProcessor = (RequestProcessor)super.getMapping(vHost);
            }
            if (virtualHostProcessor == null) {
                Iterator targetMappings = super.targetMappings();
                while (targetMappings.hasNext()) {
                    RequestProcessor reqProc;
                    Object vhostProcessorCandidate = targetMappings.next();
                    if (!(vhostProcessorCandidate instanceof InternalURIMapper) || (reqProc = ((URIMapper)vhostProcessorCandidate).map(relativePath)) == null) continue;
                    WebGroup webGroup = (WebGroup)reqProc;
                    if (!webGroup.getName().equals("/*")) {
                        logger.logp(Level.WARNING, CLASS_NAME, "map", nls.getFormattedMessage("request.matches.context.root", new Object[]{webGroup.getName(), ((InternalURIMapper)vhostProcessorCandidate).getVhostKey()}, "Request matches the context root[" + webGroup.getName() + "] under the virtual host alias of[" + ((InternalURIMapper)vhostProcessorCandidate).getVhostKey() + "]."));
                        logger.logp(Level.WARNING, CLASS_NAME, "map", nls.getFormattedMessage("need.to.add.a.new.virtual.host.alias", new Object[]{((InternalURIMapper)vhostProcessorCandidate).getVhostKey()}, "You may need to add a new virtual host alias of *:<your port> to the same virtual host [" + ((InternalURIMapper)vhostProcessorCandidate).getVhostKey() + "] is under."));
                        break;
                    }
                    if (!TraceComponent.isAnyTracingEnabled() || !logger.isLoggable(Level.FINE)) continue;
                    logger.logp(Level.FINE, CLASS_NAME, "map", "Request matches the context root[" + webGroup.getName() + "] under the virtual host alias of[" + ((InternalURIMapper)vhostProcessorCandidate).getVhostKey() + "].");
                    logger.logp(Level.FINE, CLASS_NAME, "map", "You may need to add a new virtual host alias of *:<your port> to the same virtual host [" + ((InternalURIMapper)vhostProcessorCandidate).getVhostKey() + "] is under.");
                }
            } else if (virtualHostProcessor instanceof InternalURIMapper) {
                cachedMappers.put(vHost, virtualHostProcessor);
                return ((URIMapper)((Object)virtualHostProcessor)).map(relativePath);
            }
            return virtualHostProcessor;
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "map", " matchString [" + matchString + "]");
        }
        return (RequestProcessor)super.getMapping(matchString);
    }

    public RequestProcessor map(Request req) {
        return null;
    }

    public void addMapping(String vHostKey, String contextRoot, RequestProcessor webGroup) throws Exception {
        RequestProcessor virtualHostProcessor;
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "addMapping", " vHost [" + vHostKey + "] relativePath [" + contextRoot + "]");
        }
        if ((virtualHostProcessor = (RequestProcessor)this.findExactMatch(vHostKey)) == null) {
            virtualHostProcessor = new InternalURIMapper(vHostKey, true);
            ((InternalURIMapper)virtualHostProcessor).addMapping(contextRoot, webGroup);
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "addMapping", "new virtual host processor vHost [" + vHostKey + "]");
            }
        } else if (virtualHostProcessor instanceof InternalURIMapper) {
            ((InternalURIMapper)virtualHostProcessor).addMapping(contextRoot, webGroup);
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "addMapping", "already existing virtual host processor vHost [" + vHostKey + "]");
            }
        }
        super.addMapping(vHostKey, virtualHostProcessor);
    }

    @Override
    public void addMapping(String vHostKey, Object target) {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "addMapping", " vHost [" + vHostKey + "] target [" + target + "]");
        }
        super.addMapping(vHostKey, target);
    }

    public void removeMapping(String vHostKey, String contextRoot) {
        RequestProcessor virtualHostProcessor;
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "removeMapping", " vHost [" + vHostKey + "] relativePath [" + contextRoot + "]");
        }
        if ((virtualHostProcessor = (RequestProcessor)super.findExactMatch(vHostKey)) instanceof InternalURIMapper) {
            InternalURIMapper uriMapper = (InternalURIMapper)virtualHostProcessor;
            uriMapper.removeMapping(contextRoot);
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "removeMapping", "removing context [" + contextRoot + "]");
            }
        }
    }

    @Override
    public void removeMapping(String matchString) {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "removeMapping", " matchString [" + matchString + "]");
        }
        super.removeMapping(matchString);
    }

    public static void main(String[] args) {
        String matchString = "localhost:9080/hello/there";
        int slashIndex = matchString.indexOf(47);
        String vHost = matchString.substring(0, slashIndex);
        String relativePath = matchString.substring(slashIndex);
        System.out.println("vHost -->" + vHost + " relativePath -->" + relativePath);
        VirtualHostMapper myVirtualHostMapper = new VirtualHostMapper();
        try {
            myVirtualHostMapper.addMapping("*:9080", new Object());
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (myVirtualHostMapper.exactMatchExists("todd:9080")) {
            System.out.println("match was found");
        } else {
            System.out.println("no match was found");
        }
        if (myVirtualHostMapper.exactMatchExists("*:9080")) {
            System.out.println("match was found");
        } else {
            System.out.println("no match was found");
        }
    }

    private final class InternalURIMapper
    extends URIMapper
    implements RequestProcessor {
        private String vhostKey;

        public InternalURIMapper(String vhostKey, boolean scalable) {
            super(scalable);
            this.vhostKey = vhostKey;
        }

        public InternalURIMapper(String vhostKey) {
            this.vhostKey = vhostKey;
        }

        @Override
        public void handleRequest(ServletRequest req, ServletResponse res) throws Exception {
            throw new RuntimeException("InternalURIMapper is not capable of handling requests");
        }

        public String getVhostKey() {
            return this.vhostKey;
        }

        @Override
        public String getName() {
            return "InternalURIMapper";
        }

        @Override
        public boolean isInternal() {
            return true;
        }
    }
}

