/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.impl.store;

import com.ibm.ejs.util.am.Alarm;
import com.ibm.ejs.util.am.AlarmListener;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.processor.impl.interfaces.BatchListener;
import com.ibm.ws.sib.processor.impl.store.SIMPTransactionManager;
import com.ibm.ws.sib.processor.utils.LockManager;
import com.ibm.ws.sib.processor.utils.am.MPAlarmManager;
import com.ibm.ws.sib.transactions.LocalTransaction;
import com.ibm.ws.sib.transactions.TransactionCommon;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.util.HashSet;
import java.util.Iterator;

public class BatchHandler
implements AlarmListener {
    private static final TraceComponent tc = SibTr.register(BatchHandler.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private LocalTransaction _currentTran = null;
    private int _currentBatchSize = 0;
    private int _batchSize;
    private long _batchTimeout;
    private HashSet _listeners;
    private LockManager _readWriteLock;
    private SIMPTransactionManager _txManager;
    private MPAlarmManager _am;
    private volatile Alarm _alarm;

    public BatchHandler(int batchSize, long batchTimeout, SIMPTransactionManager txManager, MPAlarmManager am) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"<init>", (Object)("batchSize=" + batchSize + ",batchTimeout=" + batchTimeout + ",txManager=" + txManager + ",am=" + am));
        }
        this._batchSize = batchSize;
        this._batchTimeout = batchTimeout;
        this._txManager = txManager;
        this._am = am;
        this._readWriteLock = new LockManager();
        this._listeners = new HashSet();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"<init>");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TransactionCommon registerInBatch() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"registerInBatch");
        }
        this._readWriteLock.lock();
        BatchHandler batchHandler = this;
        synchronized (batchHandler) {
            if (this._currentTran == null) {
                this._currentTran = this._txManager.createLocalTransaction(false);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"registerInBatch", (Object)this._currentTran);
        }
        return this._currentTran;
    }

    public void messagesAdded(int msgCount) throws SIResourceException {
        this.messagesAdded(msgCount, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void messagesAdded(int msgCount, BatchListener listener) throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"messagesAdded", (Object)("msgCount=" + msgCount + ",listener=" + listener));
        }
        boolean completeBatch = false;
        try {
            BatchHandler batchHandler = this;
            synchronized (batchHandler) {
                this._currentBatchSize += msgCount;
                if (listener != null && !this._listeners.contains(listener)) {
                    this._listeners.add(listener);
                }
                if (this._currentBatchSize >= this._batchSize) {
                    completeBatch = true;
                } else if (this._currentBatchSize - msgCount == 0) {
                    this.startTimer();
                }
            }
        }
        finally {
            this._readWriteLock.unlock();
        }
        if (completeBatch) {
            this.completeBatch(false);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"messagesAdded");
        }
    }

    public void completeBatch(boolean force) throws SIResourceException {
        this.completeBatch(force, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void completeBatch(boolean force, BatchListener finalListener) throws SIResourceException {
        block19: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)"completeBatch", (Object)("force=" + force + ",finalListener=" + finalListener));
            }
            this._readWriteLock.lockExclusive();
            try {
                if (force && this._currentBatchSize > 0 || this._currentBatchSize >= this._batchSize) {
                    for (BatchListener listener : this._listeners) {
                        listener.batchPrecommit((TransactionCommon)this._currentTran);
                    }
                    if (finalListener != null) {
                        finalListener.batchPrecommit((TransactionCommon)this._currentTran);
                    }
                    boolean committed = false;
                    Exception exceptionOnCommit = null;
                    try {
                        this._currentTran.commit();
                        committed = true;
                    }
                    catch (Exception e) {
                        FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.store.BatchHandler.completeBatch", (String)"1:254:1.30", (Object)this);
                        committed = false;
                        SibTr.exception((TraceComponent)tc, (Exception)e);
                        exceptionOnCommit = e;
                    }
                    this._currentBatchSize = 0;
                    this._currentTran = null;
                    Iterator itr = this._listeners.iterator();
                    while (itr.hasNext()) {
                        BatchListener listener = (BatchListener)itr.next();
                        if (committed) {
                            listener.batchCommitted();
                        } else {
                            listener.batchRolledBack();
                        }
                        itr.remove();
                    }
                    if (finalListener != null) {
                        if (committed) {
                            finalListener.batchCommitted();
                        } else {
                            finalListener.batchRolledBack();
                        }
                    }
                    if (exceptionOnCommit != null) {
                        this._readWriteLock.unlockExclusive();
                        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                            SibTr.exit((TraceComponent)tc, (String)"completeBatch", (Object)exceptionOnCommit);
                        }
                        throw new SIResourceException((Throwable)exceptionOnCommit);
                    }
                    this.cancelTimer();
                    break block19;
                }
                if (finalListener != null) {
                    finalListener.batchCommitted();
                }
            }
            finally {
                this._readWriteLock.unlockExclusive();
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"completeBatch");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startTimer() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"startTimer");
        }
        BatchHandler batchHandler = this;
        synchronized (batchHandler) {
            if (this._alarm == null) {
                this._alarm = this._am.create(this._batchTimeout, this);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"startTimer");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelTimer() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"cancelTimer");
        }
        BatchHandler batchHandler = this;
        synchronized (batchHandler) {
            if (this._alarm != null) {
                this._alarm.cancel();
                this._alarm = null;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"cancelTimer");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void alarm(Object alarmContext) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"alarm", (Object)alarmContext);
        }
        BatchHandler batchHandler = this;
        synchronized (batchHandler) {
            this._alarm = null;
        }
        try {
            this.completeBatch(true);
        }
        catch (SIException e) {
            SibTr.exception((Object)this, (TraceComponent)tc, (Exception)((Object)e));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"alarm");
        }
    }
}

