/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jsp.translator.compiler;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.jsp.JspCoreException;
import com.ibm.ws.jsp.JspOptions;
import com.ibm.ws.jsp.translator.compiler.JspCompilerResultImpl;
import com.ibm.wsspi.jsp.compiler.JspCompiler;
import com.ibm.wsspi.jsp.compiler.JspCompilerResult;
import com.ibm.wsspi.jsp.compiler.JspLineId;
import com.ibm.wsspi.jsp.context.JspClassloaderContext;
import com.ibm.wsspi.jsp.resource.translation.JspResources;
import java.io.BufferedReader;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

@TraceObjectField(fieldName="logger", fieldDesc="Ljava/util/logging/Logger;")
public class JikesJspCompiler
implements JspCompiler {
    protected static Logger logger;
    private static final String CLASS_NAME = "com.ibm.ws.jsp.translator.compiler.JikesJspCompiler";
    private static String separatorString;
    private static final long NANOS_IN_A_MILLISECOND = 1000000L;
    protected JspClassloaderContext classloaderContext;
    protected JspOptions options;
    protected CharArrayWriter out;
    protected String fullClasspath;
    protected String optimizedClasspath;
    protected String sourcepath;
    protected boolean isClassDebugInfo;
    protected boolean isDebugEnabled;
    protected boolean isVerbose;
    protected boolean isDeprecation;
    protected int jdkSourceLevel;
    protected Integer javaSourceLevel;
    protected boolean useOptimizedClasspath;
    protected String absouluteContextRoot;
    static final long serialVersionUID = -4879278774371338088L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public JikesJspCompiler(String absouluteContextRoot, JspClassloaderContext classloaderContext, JspOptions options, String optimizedClasspath, boolean useOptimizedClasspath) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "<init>", new Object[]{absouluteContextRoot, classloaderContext, options, optimizedClasspath, useOptimizedClasspath});
        }
        this.classloaderContext = null;
        this.options = null;
        this.out = null;
        this.fullClasspath = null;
        this.optimizedClasspath = null;
        this.sourcepath = null;
        this.isClassDebugInfo = false;
        this.isDebugEnabled = false;
        this.isVerbose = false;
        this.isDeprecation = false;
        this.useOptimizedClasspath = false;
        this.absouluteContextRoot = null;
        this.absouluteContextRoot = absouluteContextRoot;
        this.classloaderContext = classloaderContext;
        this.optimizedClasspath = optimizedClasspath;
        this.options = options;
        this.useOptimizedClasspath = useOptimizedClasspath;
        this.sourcepath = options.getOutputDir().getPath();
        this.isClassDebugInfo = options.isClassDebugInfo();
        this.isDebugEnabled = options.isDebugEnabled();
        this.isVerbose = options.isVerbose();
        this.isDeprecation = options.isDeprecation();
        this.jdkSourceLevel = options.getJdkSourceLevel();
        this.javaSourceLevel = options.getJavaSourceLevel();
        this.out = new CharArrayWriter();
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "<init>", this);
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public JspCompilerResult compile(JspResources[] jspResources, JspResources[] dependencyResources, Collection jspLineIds, List compilerOptions) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "compile", new Object[]{jspResources, dependencyResources, jspLineIds, compilerOptions});
        }
        JspCompilerResult jspCompilerResult = this.compile(jspResources[0].getGeneratedSourceFile().getPath(), jspLineIds, compilerOptions);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            jspCompilerResult = jspCompilerResult;
            logger.exiting(CLASS_NAME, "compile", jspCompilerResult);
        }
        return jspCompilerResult;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public JspCompilerResult compile(String source, Collection jspLineIds, List compilerOptions) {
        JspCompilerResultImpl result;
        boolean directoryCompile;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "compile", new Object[]{source, jspLineIds, compilerOptions});
        }
        this.out.reset();
        int rc = 0;
        String javaHomePath = null;
        try {
            javaHomePath = new File(System.getProperty("java.home")).getCanonicalPath();
        }
        catch (IOException e) {
            JspCompilerResultImpl result2;
            this.out.write(e.toString(), 0, e.toString().length());
            JspCompilerResultImpl jspCompilerResultImpl = result2 = new JspCompilerResultImpl(1, this.out.toString());
            if (logger != null && logger.isLoggable(Level.FINER)) {
                jspCompilerResultImpl = jspCompilerResultImpl;
                logger.exiting(CLASS_NAME, "compile", jspCompilerResultImpl);
            }
            return jspCompilerResultImpl;
        }
        this.fullClasspath = this.classloaderContext.getClassPath() + File.pathSeparatorChar + this.options.getOutputDir().getPath();
        this.fullClasspath = this.createJikesClasspath(this.fullClasspath, javaHomePath);
        this.optimizedClasspath = this.createJikesClasspath(this.optimizedClasspath, javaHomePath);
        String cp = null;
        boolean bl = directoryCompile = source.charAt(0) == '@';
        if (!directoryCompile) {
            source = "\"" + source + "\"";
        }
        cp = directoryCompile && !this.useOptimizedClasspath ? this.fullClasspath : this.optimizedClasspath;
        rc = this.runCompile(source, compilerOptions, cp);
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "compile", "rc = " + rc + " directoryCompile = " + directoryCompile + " useOptimizedClasspath = " + this.useOptimizedClasspath);
        }
        if (rc != 0 && !directoryCompile && !this.useOptimizedClasspath) {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "compile", "Warning: failed to compile " + source + " with optimized classpath [" + cp + "]");
            }
            this.out.reset();
            rc = this.runCompile(source, compilerOptions, this.fullClasspath);
        }
        String output = null;
        if (rc != 0 || rc == 0 && (this.isVerbose || this.isDeprecation)) {
            output = this.out.toString();
            if (rc != 0) {
                output = this.getJspLineErrors(output, jspLineIds);
            }
        }
        JspCompilerResultImpl jspCompilerResultImpl = result = new JspCompilerResultImpl(rc, output);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            jspCompilerResultImpl = jspCompilerResultImpl;
            logger.exiting(CLASS_NAME, "compile", jspCompilerResultImpl);
        }
        return jspCompilerResultImpl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private int runCompile(String source, List compilerOptions, String cp) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "runCompile", new Object[]{source, compilerOptions, cp});
        }
        int rc = 0;
        List argList = this.buildArgList(source, compilerOptions, cp);
        String[] argsArray = new String[argList.size()];
        argsArray = argList.toArray(argsArray);
        StringBuffer argsbuffer = new StringBuffer();
        for (int i = 0; i < argsArray.length; ++i) {
            argsbuffer.append(argsArray[i]);
            argsbuffer.append(" ");
        }
        String args = "jikes " + argsbuffer.toString();
        long start = System.nanoTime();
        try {
            Process process = Runtime.getRuntime().exec(args, null, new File(this.absouluteContextRoot));
            BufferedReader br = new BufferedReader(new InputStreamReader(process.getInputStream()));
            String line = br.readLine();
            while (line != null) {
                this.out.write(line + separatorString);
                line = br.readLine();
            }
            process.waitFor();
            rc = process.exitValue();
        }
        catch (InterruptedException e) {
            this.out.write(e.toString(), 0, e.toString().length());
            rc = 1;
        }
        catch (IOException e) {
            this.out.write(e.toString(), 0, e.toString().length());
            rc = 1;
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "runCompile", "compiling " + source);
            logger.logp(Level.FINE, CLASS_NAME, "runCompile", "classpath [" + cp + "]");
        }
        long end = System.nanoTime();
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "runCompile", "compile complete for " + source + " time = " + (end - start) / 1000000L + " Milliseconds rc = " + rc);
        }
        int n = rc;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            n = n;
            logger.exiting(CLASS_NAME, "runCompile", n);
        }
        return n;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private List buildArgList(String source, List compilerOptions, String classpath) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "buildArgList", new Object[]{source, compilerOptions, classpath});
        }
        ArrayList<String> argList = new ArrayList<String>();
        if (this.isClassDebugInfo || this.isDebugEnabled) {
            argList.add("-g");
        }
        if (this.isVerbose) {
            argList.add("-verbose");
        }
        if (this.isDeprecation) {
            argList.add("-deprecation");
        }
        argList.add("-source");
        if (this.javaSourceLevel != -1) {
            argList.add(this.javaSourceLevel.toString());
        } else if (this.jdkSourceLevel == 14) {
            argList.add("1.4");
        } else if (this.jdkSourceLevel == 15) {
            argList.add("1.5");
        } else if (this.jdkSourceLevel == 16) {
            argList.add("1.6");
        } else if (this.jdkSourceLevel == 17) {
            argList.add("1.7");
        } else if (this.jdkSourceLevel == 18) {
            argList.add("1.8");
        } else {
            argList.add("1.3");
        }
        argList.add("-sourcepath");
        argList.add(this.sourcepath);
        argList.add("-classpath");
        argList.add(classpath);
        argList.add("-Xstdout");
        if (compilerOptions != null) {
            for (int i = 0; i < compilerOptions.size(); ++i) {
                String compilerOption = (String)compilerOptions.get(i);
                if (compilerOption.equals("-verbose")) {
                    this.isVerbose = true;
                }
                if (compilerOption.equals("-deprecation")) {
                    this.isDeprecation = true;
                }
                argList.add(compilerOption);
            }
        }
        argList.add(source);
        ArrayList<String> arrayList = argList;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            arrayList = arrayList;
            logger.exiting(CLASS_NAME, "buildArgList", arrayList);
        }
        return arrayList;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private String createJikesClasspath(String string, String javaHomePath) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "createJikesClasspath", new Object[]{string, javaHomePath});
        }
        StringBuffer classpath = new StringBuffer();
        classpath.append(javaHomePath + File.separator + "lib" + File.separator + "core.jar" + File.pathSeparatorChar);
        classpath.append(javaHomePath + File.separator + "lib" + File.separator + "graphics.jar" + File.pathSeparatorChar);
        classpath.append(javaHomePath + File.separator + "lib" + File.separator + "security.jar" + File.pathSeparatorChar);
        classpath.append(javaHomePath + File.separator + "lib" + File.separator + "server.jar" + File.pathSeparatorChar);
        classpath.append(javaHomePath + File.separator + "lib" + File.separator + "xml.jar" + File.pathSeparatorChar);
        classpath.append(string);
        String string2 = classpath.toString();
        if (logger != null && logger.isLoggable(Level.FINER)) {
            string2 = string2;
            logger.exiting(CLASS_NAME, "createJikesClasspath", string2);
        }
        return string2;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public String getJspLineErrors(String compilerOutput, Collection jspLineIds) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "getJspLineErrors", new Object[]{compilerOutput, jspLineIds});
        }
        StringBuffer errorMsg = new StringBuffer();
        BufferedReader br = new BufferedReader(new StringReader(compilerOutput));
        try {
            String line = br.readLine();
            int warningIndex = -1;
            String javaName = null;
            while (line != null) {
                int firstQuote;
                int javaNameEnd = line.indexOf(".java\":");
                if (javaNameEnd > 0 && (firstQuote = line.indexOf("\"")) > 0) {
                    javaName = line.substring(firstQuote + 1, javaNameEnd + 5);
                    javaName = javaName.replace('\\', '/');
                    javaName = javaName.replace('/', File.separatorChar);
                }
                warningIndex = line.indexOf("*** Semantic Warning:");
                if (javaName != null && !line.startsWith("[read ") && !line.startsWith("] ") && warningIndex < 0) {
                    try {
                        int firstDot = line.indexOf(46);
                        if (firstDot > 0) {
                            String nr = line.substring(0, firstDot);
                            String lineNumber = "";
                            for (int i = 0; i < nr.length(); ++i) {
                                if (nr.charAt(i) < '0' || nr.charAt(i) > '9') continue;
                                lineNumber = lineNumber + nr.charAt(i);
                            }
                            int lineNr = Integer.parseInt(lineNumber);
                            String mapping = this.findMapping(jspLineIds, lineNr, javaName);
                            if (mapping == null) {
                                errorMsg.append(separatorString);
                            } else {
                                errorMsg.append(mapping);
                            }
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                errorMsg.append(line);
                errorMsg.append(separatorString);
                line = br.readLine();
            }
            br.close();
        }
        catch (IOException e) {
            logger.logp(Level.WARNING, CLASS_NAME, "getJspLineErrors", "Failed to find line number mappings for compiler errors", e);
        }
        String string = errorMsg.toString();
        if (logger != null && logger.isLoggable(Level.FINER)) {
            string = string;
            logger.exiting(CLASS_NAME, "getJspLineErrors", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private String findMapping(Collection jspLineIds, int lineNr, String javaName) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "findMapping", new Object[]{jspLineIds, lineNr, javaName});
        }
        String errorMsg = null;
        for (JspLineId lineId : jspLineIds) {
            if (!lineId.getGeneratedFilePath().equals(javaName)) continue;
            if (lineId.getStartGeneratedLineCount() <= 1 && lineId.getStartGeneratedLineNum() == lineNr) {
                errorMsg = this.createErrorMsg(lineId, lineNr);
                break;
            }
            if (lineId.getStartGeneratedLineNum() > lineNr || lineId.getStartGeneratedLineNum() + lineId.getStartGeneratedLineCount() - 1 < lineNr) continue;
            errorMsg = this.createErrorMsg(lineId, lineNr);
            break;
        }
        String string = errorMsg;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            string = string;
            logger.exiting(CLASS_NAME, "findMapping", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private String createErrorMsg(JspLineId jspLineId, int errorLineNr) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "createErrorMsg", new Object[]{jspLineId, errorLineNr});
        }
        StringBuffer compilerOutput = new StringBuffer();
        if (jspLineId.getSourceLineCount() <= 1) {
            Object[] objArray = new Object[]{new Integer(jspLineId.getStartSourceLineNum()), jspLineId.getFilePath()};
            if (jspLineId.getFilePath().equals(jspLineId.getParentFile())) {
                compilerOutput.append(separatorString + JspCoreException.getMsg("jsp.error.single.line.number", objArray));
            } else {
                compilerOutput.append(separatorString + JspCoreException.getMsg("jsp.error.single.line.number.included.file", objArray));
            }
        } else {
            int actualLineNum = jspLineId.getStartSourceLineNum() + (errorLineNr - jspLineId.getStartGeneratedLineNum());
            if (actualLineNum >= jspLineId.getStartSourceLineNum() && actualLineNum <= jspLineId.getStartSourceLineNum() + jspLineId.getSourceLineCount() - 1) {
                Object[] objArray = new Object[]{new Integer(actualLineNum), jspLineId.getFilePath()};
                if (jspLineId.getFilePath().equals(jspLineId.getParentFile())) {
                    compilerOutput.append(separatorString + JspCoreException.getMsg("jsp.error.single.line.number", objArray));
                } else {
                    compilerOutput.append(separatorString + JspCoreException.getMsg("jsp.error.single.line.number.included.file", objArray));
                }
            } else {
                Object[] objArray = new Object[]{new Integer(jspLineId.getStartSourceLineNum()), new Integer(jspLineId.getStartSourceLineNum() + jspLineId.getSourceLineCount() - 1), jspLineId.getFilePath()};
                if (jspLineId.getFilePath().equals(jspLineId.getParentFile())) {
                    compilerOutput.append(separatorString + JspCoreException.getMsg("jsp.error.multiple.line.number", objArray));
                } else {
                    compilerOutput.append(separatorString + JspCoreException.getMsg("jsp.error.multiple.line.number.included.file", objArray));
                }
            }
        }
        compilerOutput.append(separatorString + JspCoreException.getMsg("jsp.error.corresponding.servlet", new Object[]{jspLineId.getParentFile()}));
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, "createErrorMsg", "The value of the JSP attribute jdkSourceLevel is [" + this.jdkSourceLevel + "]");
        }
        String string = compilerOutput.toString();
        if (logger != null && logger.isLoggable(Level.FINER)) {
            string = string;
            logger.exiting(CLASS_NAME, "createErrorMsg", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    static {
        separatorString = System.getProperty("line.separator");
        logger = Logger.getLogger("com.ibm.ws.jsp");
    }
}

