/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.messaging.security;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.messaging.security.RuntimeSecurityService;
import com.ibm.ws.messaging.security.authorization.MessagingAuthorizationException;
import com.ibm.ws.messaging.security.authorization.MessagingAuthorizationService;
import com.ibm.ws.sib.utils.ras.SibTr;
import javax.security.auth.Subject;

public class Authorization {
    private static TraceComponent tc = SibTr.register(Authorization.class, (String)"MessagingSecurity", (String)"com.ibm.ws.messaging.security.CWWKMMessages");
    private static final String CLASS_NAME = "com.ibm.ws.messaging.security.Authorization.";
    private MessagingAuthorizationService messagingAuthorizationService = null;
    private final RuntimeSecurityService runtimeSecurityService;

    Authorization(RuntimeSecurityService runtimeSecurityService) {
        String methodName = "Authentication";
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"Authentication", (Object)new Object[]{this, runtimeSecurityService});
        }
        this.runtimeSecurityService = runtimeSecurityService;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"Authentication");
        }
    }

    public boolean checkQueueAccess(Subject authenticatedSubject, String queue, String operationType) throws MessagingAuthorizationException {
        SibTr.entry((TraceComponent)tc, (String)"com.ibm.ws.messaging.security.Authorization.checkDestinationAccess", (Object)new Object[]{authenticatedSubject, queue, operationType});
        boolean result = false;
        if (!this.runtimeSecurityService.isMessagingSecure()) {
            result = true;
        } else if (this.messagingAuthorizationService != null) {
            result = this.messagingAuthorizationService.checkQueueAccess(authenticatedSubject, queue, operationType, true);
        }
        SibTr.exit((TraceComponent)tc, (String)"com.ibm.ws.messaging.security.Authorization.checkDestinationAccess", (Object)result);
        return result;
    }

    public boolean checkAliasAccess(Subject authenticatedSubject, String destination, String aliasDestination, int destinationType, String operationType) throws MessagingAuthorizationException {
        SibTr.entry((TraceComponent)tc, (String)"com.ibm.ws.messaging.security.Authorization.checkAliasAccess", (Object)new Object[]{authenticatedSubject, destination, operationType, aliasDestination});
        boolean result = false;
        if (!this.runtimeSecurityService.isMessagingSecure()) {
            result = true;
        } else if (this.messagingAuthorizationService != null) {
            result = this.messagingAuthorizationService.checkAliasAccess(authenticatedSubject, destination, aliasDestination, destinationType, operationType, true);
        }
        SibTr.exit((TraceComponent)tc, (String)"com.ibm.ws.messaging.security.Authorization.checkAliasAccess", (Object)result);
        return result;
    }

    public boolean checkTemporaryDestinationAccess(Subject authenticatedSubject, String prefix, String operationType) throws MessagingAuthorizationException {
        SibTr.entry((TraceComponent)tc, (String)"com.ibm.ws.messaging.security.Authorization.checkTemporaryDestinationAccess", (Object)new Object[]{authenticatedSubject, prefix, operationType});
        boolean result = false;
        if (!this.runtimeSecurityService.isMessagingSecure()) {
            result = true;
        } else if (this.messagingAuthorizationService != null) {
            result = this.messagingAuthorizationService.checkTemporaryDestinationAccess(authenticatedSubject, prefix, operationType);
        }
        SibTr.exit((TraceComponent)tc, (String)"com.ibm.ws.messaging.security.Authorization.checkTemporaryDestinationAccess", (Object)result);
        return result;
    }

    public boolean checkTopicAccess(Subject authenticatedSubject, String topicSpace, String topicName, String operationType) throws MessagingAuthorizationException {
        SibTr.entry((TraceComponent)tc, (String)"com.ibm.ws.messaging.security.Authorization.checkTopicAccess", (Object)new Object[]{authenticatedSubject, topicSpace, topicName, operationType});
        boolean result = false;
        if (!this.runtimeSecurityService.isMessagingSecure()) {
            result = true;
        } else if (this.messagingAuthorizationService != null) {
            result = this.messagingAuthorizationService.checkTopicAccess(authenticatedSubject, topicSpace, topicName, operationType);
        }
        SibTr.exit((TraceComponent)tc, (String)"com.ibm.ws.messaging.security.Authorization.checkDestinationAccess", (Object)result);
        return result;
    }

    public void setMessagingAuthorizationService(MessagingAuthorizationService messagingAuthorizationService) {
        SibTr.entry((TraceComponent)tc, (String)"com.ibm.ws.messaging.security.Authorization.setMessagingAuthorizationService", (Object)messagingAuthorizationService);
        this.messagingAuthorizationService = messagingAuthorizationService;
        SibTr.exit((TraceComponent)tc, (String)"com.ibm.ws.messaging.security.Authorization.setMessagingAuthorizationService");
    }
}

