/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.objectManager;

import com.ibm.ws.objectManager.DummyManagedObject;
import com.ibm.ws.objectManager.InternalTransaction;
import com.ibm.ws.objectManager.LogRecord;
import com.ibm.ws.objectManager.LogicalUnitOfWork;
import com.ibm.ws.objectManager.ManagedObject;
import com.ibm.ws.objectManager.ObjectManager;
import com.ibm.ws.objectManager.ObjectManagerByteArrayOutputStream;
import com.ibm.ws.objectManager.ObjectManagerException;
import com.ibm.ws.objectManager.ObjectManagerState;
import com.ibm.ws.objectManager.PermanentIOException;
import com.ibm.ws.objectManager.Token;
import com.ibm.ws.objectManager.Transaction;
import com.ibm.ws.objectManager.utils.Trace;
import com.ibm.ws.objectManager.utils.Tracing;
import java.io.DataInputStream;
import java.io.IOException;

class TransactionReplaceLogRecord
extends LogRecord {
    private static final Class cclass = TransactionReplaceLogRecord.class;
    private static Trace trace = ObjectManager.traceFactory.getTrace(cclass, "ObjectManagerTransactions");
    private static final long serialVersionUID = 5720229220972571013L;
    protected LogicalUnitOfWork logicalUnitOfWork;
    protected int transactionState;
    protected Token token;
    protected byte[] managedObjectBytes;
    ObjectManagerByteArrayOutputStream serializedBytes;

    protected TransactionReplaceLogRecord(InternalTransaction internalTransaction, Token token, ObjectManagerByteArrayOutputStream serializedBytes) throws ObjectManagerException {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "<init>", new Object[]{internalTransaction, token, serializedBytes});
        }
        this.logicalUnitOfWork = internalTransaction.getLogicalUnitOfWork();
        this.transactionState = internalTransaction.getState();
        this.token = token;
        this.serializedBytes = serializedBytes;
        this.buffers = this.getBuffers(internalTransaction.logRecordByteArrayOutputStream);
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit(this, cclass, "<init>");
        }
    }

    protected TransactionReplaceLogRecord(DataInputStream dataInputStream, ObjectManagerState objectManagerState) throws ObjectManagerException {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "<init>", "DataInputStream=" + dataInputStream + ", ObjectManagerState=" + objectManagerState);
        }
        try {
            this.logicalUnitOfWork = new LogicalUnitOfWork(dataInputStream);
            this.transactionState = dataInputStream.readInt();
            this.token = Token.restore(dataInputStream, objectManagerState);
            long managedObjectLength = dataInputStream.readLong();
            this.managedObjectBytes = new byte[(int)managedObjectLength];
            dataInputStream.read(this.managedObjectBytes);
        }
        catch (IOException exception) {
            ObjectManager.ffdc.processException(this, cclass, "<init>", exception, "1:114:1.8");
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.exit((Object)this, cclass, "<init>", exception);
            }
            throw new PermanentIOException((Object)this, exception);
        }
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit(this, cclass, "<init>");
        }
    }

    public ObjectManagerByteArrayOutputStream[] getBuffers(ObjectManagerByteArrayOutputStream byteArrayOutputStream) throws ObjectManagerException {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry(this, cclass, "getBuffers");
        }
        ObjectManagerByteArrayOutputStream[] buffers = new ObjectManagerByteArrayOutputStream[2];
        byteArrayOutputStream.reset();
        buffers[0] = byteArrayOutputStream;
        buffers[0].writeInt(2);
        this.logicalUnitOfWork.writeSerializedBytes(buffers[0]);
        buffers[0].writeInt(this.transactionState);
        this.token.writeSerializedBytes(buffers[0]);
        buffers[0].writeLong(this.serializedBytes.getCount());
        buffers[1] = this.serializedBytes;
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit((Object)this, cclass, "getBuffers", new Object[]{buffers});
        }
        return buffers;
    }

    @Override
    public void performRecovery(ObjectManagerState objectManagerState) throws ObjectManagerException {
        String methodName = "performRecovery";
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "performRecovery", new Object[]{objectManagerState, this.logicalUnitOfWork, new Integer(this.transactionState), this.token, new Integer(this.managedObjectBytes.length)});
        }
        ManagedObject replacementManagedObject = ManagedObject.restoreFromSerializedBytes(this.managedObjectBytes, objectManagerState);
        Transaction transactionForRecovery = objectManagerState.getTransaction(this.logicalUnitOfWork);
        ManagedObject existingManagedObject = this.token.getManagedObject();
        if (existingManagedObject == null) {
            DummyManagedObject dummyManagedObject = new DummyManagedObject("Created by TransactionReplaceLogRecord.performRecovery()");
            dummyManagedObject.state = 8;
            dummyManagedObject.owningToken = this.token;
            existingManagedObject = this.token.setManagedObject(dummyManagedObject);
            existingManagedObject.state = 8;
        }
        transactionForRecovery.lock(existingManagedObject);
        this.token.setManagedObject(replacementManagedObject);
        transactionForRecovery.replace(existingManagedObject);
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit(this, cclass, "performRecovery");
        }
    }

    protected static long maximumSerializedSize() {
        return 4L + LogicalUnitOfWork.maximumSerializedSize() + 4L + Token.maximumSerializedSize() + 8L;
    }
}

