/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.jfapchannel.richclient.framework.impl;

import com.ibm.websphere.channelfw.CFEndPoint;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.messaging.lifecycle.SingletonsReady;
import com.ibm.ws.sib.jfapchannel.framework.FrameworkException;
import com.ibm.ws.sib.jfapchannel.framework.NetworkConnectionFactory;
import com.ibm.ws.sib.jfapchannel.framework.NetworkTransportFactory;
import com.ibm.ws.sib.jfapchannel.impl.CommsClientServiceFacade;
import com.ibm.ws.sib.jfapchannel.impl.CommsOutboundChain;
import com.ibm.ws.sib.jfapchannel.netty.NettyNetworkConnectionFactory;
import com.ibm.ws.sib.jfapchannel.richclient.framework.impl.CFWNetworkConnectionFactory;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.channelfw.VirtualConnectionFactory;
import com.ibm.wsspi.channelfw.exception.ChainException;
import com.ibm.wsspi.channelfw.exception.ChannelException;
import com.ibm.wsspi.channelfw.exception.InvalidChainNameException;

public class RichClientTransportFactory
implements NetworkTransportFactory {
    private static final TraceComponent tc = SibTr.register(RichClientTransportFactory.class, (String)"SIBJFapChannel", (String)"com.ibm.ws.sib.jfapchannel.CWSIJMessages");
    private static final String CLASS_NAME = RichClientTransportFactory.class.getName();

    public RichClientTransportFactory() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"<init>");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"<init>");
        }
    }

    @Override
    public NetworkConnectionFactory getOutboundNetworkConnectionFactoryByName(String chainName) throws FrameworkException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getOutboundNetworkConnectionFactoryByName", (Object)chainName);
        }
        NetworkConnectionFactory connFactory = null;
        try {
            CommsOutboundChain chain = CommsOutboundChain.getChainDetails(chainName);
            if (chain != null) {
                if (chain.useNetty()) {
                    boolean usingSSL = chain.isSecureChain();
                    if (usingSSL && chain.getSslOptions() == null) {
                        throw new InvalidChainNameException("Chain configuration not found in framework, " + chainName);
                    }
                    connFactory = new NettyNetworkConnectionFactory(chainName, chain.getTcpOptions(), usingSSL ? chain.getSslOptions() : null, usingSSL ? chain.getNettyTlsProvider() : null);
                } else {
                    VirtualConnectionFactory vcFactory = ((CommsClientServiceFacade)SingletonsReady.requireService(CommsClientServiceFacade.class)).getChannelFramework().getOutboundVCFactory(chainName);
                    connFactory = new CFWNetworkConnectionFactory(vcFactory);
                }
            }
        }
        catch (ChannelException e) {
            FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".getOutboundNetworkConnectionFactoryByName"), (String)"00280001", (Object[])new Object[]{this, chainName});
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)("Failure to obtain OVC for Outbound chain" + chainName), (Object)((Object)e));
            }
            throw new FrameworkException(e);
        }
        catch (ChainException e) {
            FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".getOutboundNetworkConnectionFactoryByName"), (String)"00280001", (Object[])new Object[]{this, chainName});
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)("Failure to obtain OVC for Outbound chain" + chainName), (Object)((Object)e));
            }
            throw new FrameworkException(e);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getOutboundNetworkConnectionFactoryByName", connFactory);
        }
        return connFactory;
    }

    @Override
    public NetworkConnectionFactory getOutboundNetworkConnectionFactoryFromEndPoint(Object endPoint) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getOutboundNetworkConnectionFactoryFromEndPoint", (Object)endPoint);
        }
        CFWNetworkConnectionFactory connFactory = null;
        if (endPoint instanceof CFEndPoint) {
            String endPointName = ((CFEndPoint)endPoint).getName();
            CommsOutboundChain chain = CommsOutboundChain.getChainDetails(endPointName);
            if (chain != null && !chain.useNetty()) {
                VirtualConnectionFactory vcFactory = ((CFEndPoint)endPoint).getOutboundVCFactory();
                connFactory = new CFWNetworkConnectionFactory(vcFactory);
            } else {
                if (tc.isDebugEnabled()) {
                    SibTr.error((TraceComponent)tc, (String)"getOutboundNetworkConnectionFactoryFromEndPoint", (Object)endPoint);
                }
                return null;
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getOutboundNetworkConnectionFactoryFromEndPoint", connFactory);
        }
        return connFactory;
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"@(#) SIB/ws/code/sib.jfapchannel.client.rich.impl/src/com/ibm/ws/sib/jfapchannel/framework/impl/RichClientTransportFactory.java, SIB.comms, WASX.SIB, uu1215.01 1.1");
        }
    }
}

