/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yoko.rmi.impl;

import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import org.apache.yoko.rmi.impl.ObjectWriter;
import org.apache.yoko.rmi.impl.TypeRepository;
import org.apache.yoko.rmi.impl.ValueDescriptor;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.portable.IndirectionException;
import org.omg.CORBA_2_3.portable.InputStream;

class EnumSubclassDescriptor
extends ValueDescriptor {
    private final Class enumType;

    EnumSubclassDescriptor(Class<?> type, TypeRepository repository) {
        super(type, repository);
        this.enumType = type;
    }

    static Class<?> getEnumType(Class<?> type) {
        if (!Enum.class.isAssignableFrom(type)) {
            throw new IllegalArgumentException(type.getName() + " is not an Enum");
        }
        while (!type.isEnum()) {
            type = type.getSuperclass();
        }
        return type;
    }

    @Override
    protected final long getSerialVersionUID() {
        return 0L;
    }

    @Override
    protected final boolean isEnum() {
        return true;
    }

    @Override
    public final Serializable readValue(org.omg.CORBA.portable.InputStream in, Map<Integer, Serializable> offsetMap, Integer offset) {
        try {
            String name = null;
            try {
                name = (String)((Object)((InputStream)in).read_value(String.class));
            }
            catch (MARSHAL mARSHAL) {
                // empty catch block
            }
            if (name == null) {
                name = (String)((Object)((InputStream)in).read_value(String.class));
            }
            Object value = Enum.valueOf(this.enumType, name);
            offsetMap.put(offset, (Serializable)value);
            return value;
        }
        catch (IndirectionException ex) {
            return offsetMap.get(ex.offset);
        }
    }

    @Override
    protected final void writeValue(ObjectWriter writer, Serializable val) throws IOException {
        this._super_descriptor.writeValue(writer, val);
    }

    @Override
    public final boolean isChunked() {
        return true;
    }

    @Override
    public final Serializable writeReplace(Serializable val) {
        return val;
    }
}

