/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http.netty;

import com.ibm.websphere.channelfw.EndPointInfo;
import com.ibm.websphere.channelfw.osgi.CHFWBundle;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.http.internal.HttpChain;
import com.ibm.ws.http.internal.HttpEndpointImpl;
import com.ibm.ws.http.internal.VirtualHostMap;
import com.ibm.ws.http.netty.NettyVirtualConnectionFactoryImpl;
import com.ibm.ws.http.netty.pipeline.HttpPipelineInitializer;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.channelfw.VirtualConnection;
import com.ibm.wsspi.kernel.service.utils.FrameworkState;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import io.openliberty.http.netty.quiesce.QuiesceStrategy;
import io.openliberty.netty.internal.NettyFramework;
import io.openliberty.netty.internal.ServerBootstrapExtended;
import io.openliberty.netty.internal.exception.NettyException;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.util.HashMap;
import java.util.Objects;
import java.util.concurrent.FutureTask;
import java.util.concurrent.atomic.AtomicReference;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class NettyChain
extends HttpChain {
    private static final TraceComponent tc = Tr.register(NettyChain.class, (String)"HTTPChannel", (String)"com.ibm.ws.http.channel.internal.resources.httpchannelmessages");
    private NettyFramework nettyFramework;
    private ServerBootstrapExtended bootstrap;
    private volatile Channel serverChannel;
    private FutureTask<ChannelFuture> channelFuture;
    private final AtomicReference<HttpChain.ChainState> state = new AtomicReference<HttpChain.ChainState>(HttpChain.ChainState.UNINITIALIZED);
    private volatile boolean enabled = false;
    static final long serialVersionUID = -2213708052382339562L;

    public NettyChain(HttpEndpointImpl owner, boolean isHttps) {
        super(owner, isHttps);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("NettyChain constructor, state: " + (this.state != null ? (Serializable)((Object)this.state.get()) : "null")), (Object[])new Object[0]);
        }
    }

    public synchronized void initNettyChain(String endpointId, NettyFramework netty) {
        String root;
        Objects.requireNonNull(netty, "NettyFramework cannot be null");
        this.nettyFramework = netty;
        this.endpointMgr = this.nettyFramework.getEndpointManager();
        this.endpointName = root = endpointId + (this.isHttps ? "-ssl" : "");
        this.tcpName = "TCP-" + root;
        this.sslName = this.isHttps ? "SSL-" + root : null;
        this.httpName = "HTTP-" + root;
        this.dispatcherName = "HTTPD-" + root;
        this.chainName = "CHAIN-" + root;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Netty Chain initialized: Endpoint ID = " + endpointId + ", Endpoint Name = " + root), (Object[])new Object[0]);
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @ManualTrace
    public synchronized void stop() {
        if (TraceComponent.isAnyTracingEnabled() && NettyChain.tc.isDebugEnabled()) {
            Tr.entry((Object)this, (TraceComponent)NettyChain.tc, (String)("Stopping Netty Chain: " + this.endpointName + ", Current state: " + (Object)this.state.get()), (Object[])new Object[0]);
        }
        if (this.state.get() == HttpChain.ChainState.STARTED || this.state.get() == HttpChain.ChainState.STARTING) {
            this.endpointMgr.removeEndPoint(this.endpointName);
            this.state.set(HttpChain.ChainState.STOPPING);
            try {
                if (!Objects.nonNull(this.serverChannel) || !this.serverChannel.isOpen()) ** GOTO lbl26
                if (TraceComponent.isAnyTracingEnabled() && NettyChain.tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)NettyChain.tc, (String)"Server Channel is open, attempting to close", (Object[])new Object[0]);
                }
                this.nettyFramework.stop(this.serverChannel, -1L);
                stopFuture = this.serverChannel.closeFuture().syncUninterruptibly();
                stopFuture.addListener((GenericFutureListener)LambdaMetafactory.metafactory(null, null, null, (Lio/netty/util/concurrent/Future;)V, lambda$stop$0(io.netty.util.concurrent.Future ), (Lio/netty/util/concurrent/Future;)V)((NettyChain)this));
                this.serverChannel = null;
            }
            finally {
                VirtualHostMap.notifyStopped(this.owner, this.currentConfig.getResolvedHost(), this.currentConfig.getConfigPort(), this.isHttps);
                this.currentConfig.clearActivePort();
                topic = this.owner.getEventTopic() + "/STOPPED";
                this.postEvent(topic, this.currentConfig, null);
                this.state.set(HttpChain.ChainState.STOPPED);
                this.notifyAll();
            }
        } else if (TraceComponent.isAnyTracingEnabled() && NettyChain.tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)NettyChain.tc, (String)("Netty Chain is not in a stoppable state. Current state: " + (Object)this.state.get()), (Object[])new Object[0]);
        }
lbl26:
        // 5 sources

        if (TraceComponent.isAnyTracingEnabled() && NettyChain.tc.isDebugEnabled()) {
            Tr.exit((Object)this, (TraceComponent)NettyChain.tc, (String)("stop chain " + this));
        }
    }

    private void stopAndWait() {
        if (this.state.get() != HttpChain.ChainState.STOPPED && this.state.get() != HttpChain.ChainState.UNINITIALIZED) {
            this.stop();
        }
    }

    @Override
    @ManualTrace
    public synchronized void update(String resolvedHostName) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)("Updating Netty Chain  " + this.endpointName + " Current state: " + (Object)((Object)this.state.get())), (Object[])new Object[0]);
        }
        if (!this.enabled || FrameworkState.isStopping()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"Chain is disabled or framework is stopping, skipping update ");
            }
            return;
        }
        HttpChain.ActiveConfiguration oldConfig = this.currentConfig;
        HttpChain.ActiveConfiguration newConfig = new HttpChain.ActiveConfiguration(this.isHttps(), this.getOwner().getTcpOptions(), this.isHttps() ? this.getOwner().getSslOptions() : null, this.getOwner().getHttpOptions(), this.getOwner().getRemoteIpConfig(), this.getOwner().getCompressionConfig(), this.getOwner().getSamesiteConfig(), this.getOwner().getHeadersConfig(), this.getOwner().getEndpointOptions(), resolvedHostName);
        if (newConfig.configPort < 0 || !newConfig.complete()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)("Stopping chain due to configuration " + newConfig), (Object[])new Object[0]);
            }
            this.currentConfig = newConfig;
            this.stopAndWait();
            this.state.set(HttpChain.ChainState.UNINITIALIZED);
        } else {
            if (!newConfig.unchanged(oldConfig)) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)"This configuration differs and should cause an update ", (Object[])new Object[0]);
                }
                this.currentConfig = newConfig;
                if (this.state.get() != HttpChain.ChainState.UNINITIALIZED) {
                    this.stopAndWait();
                }
            }
            this.startNettyChannel();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"Channel restarted with new configuration", (Object[])new Object[0]);
        }
    }

    /*
     * WARNING - void declaration
     */
    @ManualTrace
    public synchronized void startNettyChannel() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)("Starting Netty Channel: " + this.endpointName + ", Current state: " + (Object)((Object)this.state.get()) + ", Enabled: " + this.enabled), (Object[])new Object[0]);
        }
        if (this.state.compareAndSet(HttpChain.ChainState.STOPPED, HttpChain.ChainState.STARTING) || this.state.compareAndSet(HttpChain.ChainState.UNINITIALIZED, HttpChain.ChainState.STARTING)) {
            try {
                HashMap<String, Object> httpOptions = new HashMap<String, Object>(this.owner.getHttpOptions());
                httpOptions.put("accessLogID", this.owner.getName());
                if (this.owner.getProtocolVersion() != null) {
                    httpOptions.put("protocolVersionInternal", this.owner.getProtocolVersion());
                }
                EndPointInfo info = this.endpointMgr.defineEndPoint(this.endpointName, this.currentConfig.configHost, this.currentConfig.configPort);
                HashMap<String, Object> tcpOptions = new HashMap<String, Object>(this.getOwner().getTcpOptions());
                tcpOptions.put("ExternalName", this.endpointName);
                this.bootstrap = this.nettyFramework.createTCPBootstrap(tcpOptions);
                HttpPipelineInitializer.HttpPipelineBuilder pipelineBuilder = new HttpPipelineInitializer.HttpPipelineBuilder(this).with(HttpPipelineInitializer.ConfigElement.COMPRESSION, this.owner.getCompressionConfig()).with(HttpPipelineInitializer.ConfigElement.HTTP_OPTIONS, httpOptions).with(HttpPipelineInitializer.ConfigElement.HEADERS, this.owner.getHeadersConfig()).with(HttpPipelineInitializer.ConfigElement.REMOTE_IP, this.owner.getRemoteIpConfig()).with(HttpPipelineInitializer.ConfigElement.SAMESITE, this.owner.getSamesiteConfig()).with(HttpPipelineInitializer.ConfigElement.TCP_OPTIONS, tcpOptions);
                if (this.isHttps()) {
                    HashMap<String, Object> sslOptions = new HashMap<String, Object>(this.getOwner().getSslOptions());
                    pipelineBuilder.with(HttpPipelineInitializer.ConfigElement.SSL_OPTIONS, sslOptions);
                }
                HttpPipelineInitializer httpPipeline = pipelineBuilder.build();
                this.bootstrap.childOption(ChannelOption.ALLOW_HALF_CLOSURE, (Object)true);
                this.bootstrap.childHandler((ChannelHandler)httpPipeline);
                this.serverChannel = this.nettyFramework.start(this.bootstrap, info.getHost(), info.getPort(), this::channelFutureHandler);
                VirtualHostMap.notifyStarted(this.owner, () -> this.currentConfig.getResolvedHost(), this.currentConfig.getConfigPort(), this.isHttps);
                String topic = this.owner.getEventTopic() + "/STARTED";
                this.postEvent(topic, this.currentConfig, null);
            }
            catch (Exception httpOptions) {
                FFDCFilter.processException((Throwable)httpOptions, (String)"com.ibm.ws.http.netty.NettyChain", (String)"249", (Object)this, (Object[])new Object[0]);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    void e;
                    Tr.exit((Object)this, (TraceComponent)tc, (String)("Failed to start Netty Channel: " + e.getMessage()));
                }
                this.state.set(HttpChain.ChainState.STOPPED);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)("Finished starting Netty Channel: " + this.endpointName + ", Final state: " + (Object)((Object)this.state.get())));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void channelFutureHandler(ChannelFuture future) {
        if (this.state.get() == HttpChain.ChainState.STOPPING) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)("Chain: " + this.endpointName + ", Current state: " + (Object)((Object)this.state.get()) + ", is stopping so will not notify any virtual hosts and will just return"), (Object[])new Object[0]);
            }
            return;
        }
        NettyChain nettyChain = this;
        synchronized (nettyChain) {
            if (future.isSuccess()) {
                this.state.set(HttpChain.ChainState.STARTED);
                EndPointInfo info = this.endpointMgr.getEndPoint(this.endpointName);
                info = this.endpointMgr.defineEndPoint(this.endpointName, this.currentConfig.configHost, this.currentConfig.configPort);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)("Channel is now active and listening on port " + this.getActivePort()), (Object[])new Object[0]);
                }
            } else {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)("Channel failed to bind to port:  " + future.cause()), (Object[])new Object[0]);
                }
                this.handleStartupError((Exception)new NettyException(future.cause()), this.currentConfig);
                if (this.currentConfig != null) {
                    VirtualHostMap.notifyStopped(this.owner, this.currentConfig.getResolvedHost(), this.currentConfig.getConfigPort(), this.isHttps);
                    this.currentConfig.clearActivePort();
                }
                this.state.set(HttpChain.ChainState.STOPPED);
            }
            this.nettyFramework.registerEndpointQuiesce(future.channel(), QuiesceStrategy.NO_OP.getTask());
            this.notifyAll();
        }
    }

    @Override
    public void enable() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("Enabling Netty chain: " + this), (Object[])new Object[0]);
        }
        this.enabled = true;
    }

    @Override
    public void disable() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("disable chain " + this), (Object[])new Object[0]);
        }
        this.enabled = false;
    }

    @Override
    public int getActivePort() {
        return this.currentConfig != null ? this.currentConfig.configPort : -1;
    }

    public String getActiveHost() {
        return this.currentConfig != null ? this.currentConfig.configHost : null;
    }

    public ServerBootstrapExtended getBootstrap() {
        return this.bootstrap;
    }

    public EndPointInfo getEndpointInfo() {
        EndPointInfo info = this.endpointMgr.getEndPoint(this.endpointName);
        if (Objects.isNull(info) && this.state.get() == HttpChain.ChainState.STARTED) {
            info = this.endpointMgr.defineEndPoint(this.endpointName, this.currentConfig.configHost, this.currentConfig.configPort);
        }
        return info;
    }

    public String getEndpointPID() {
        return this.currentConfig != null ? this.currentConfig.getEndpointPID() : null;
    }

    public boolean isHttp2Enabled() {
        String protocolVersion = this.getOwner().getProtocolVersion();
        this.getOwner().getChfwBundle();
        Boolean defaultSetting = CHFWBundle.getHttp2DefaultSetting();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("Protocol version found to be:  " + protocolVersion), (Object[])new Object[0]);
        }
        if (defaultSetting == null) {
            return false;
        }
        return defaultSetting == Boolean.TRUE ? !"http/1.1".equalsIgnoreCase(protocolVersion) : "http/2".equalsIgnoreCase(protocolVersion);
    }

    /*
     * WARNING - void declaration
     */
    public VirtualConnection processNewConnection() {
        NettyVirtualConnectionFactoryImpl factory = new NettyVirtualConnectionFactoryImpl();
        try {
            return factory.createConnection();
        }
        catch (Exception exception) {
            void e;
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.http.netty.NettyChain", (String)"376", (Object)this, (Object[])new Object[0]);
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public int getChainState() {
        return this.state.get().val;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "[@=" + System.identityHashCode(this) + ",enabled=" + this.enabled + ",state=" + (this.state != null ? (Serializable)((Object)this.state.get()) : "null") + ",chainName=" + this.chainName + ",config=" + this.currentConfig + "]";
    }

    private /* synthetic */ void lambda$stop$0(Future future) throws Exception {
        if (future.isSuccess()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"Server Channel was successfully closed", (Object[])new Object[0]);
            }
        } else {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"Server Channel failed to close! Trying again...", (Object[])new Object[0]);
            }
            this.serverChannel.closeFuture().syncUninterruptibly();
        }
    }
}

