/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.mfp.jmf.tools;

import com.ibm.ws.sib.mfp.jmf.JMFException;
import com.ibm.ws.sib.mfp.jmf.JMFFieldDef;
import com.ibm.ws.sib.mfp.jmf.JMFList;
import com.ibm.ws.sib.mfp.jmf.JMFMessage;
import com.ibm.ws.sib.mfp.jmf.JMFNativePart;
import com.ibm.ws.sib.mfp.jmf.JMFSchema;
import com.ibm.ws.sib.mfp.jmf.JmfTr;
import com.ibm.ws.sib.mfp.jmf.impl.JSDynamic;
import com.ibm.ws.sib.mfp.jmf.impl.JSEnum;
import com.ibm.ws.sib.mfp.jmf.impl.JSField;
import com.ibm.ws.sib.mfp.jmf.impl.JSListCoder;
import com.ibm.ws.sib.mfp.jmf.impl.JSPrimitive;
import com.ibm.ws.sib.mfp.jmf.impl.JSType;
import com.ibm.ws.sib.mfp.jmf.impl.JSVariant;
import com.ibm.ws.sib.mfp.jmf.impl.JSchema;
import com.ibm.ws.sib.mfp.jmf.impl.MessageMap;
import com.ibm.ws.sib.mfp.util.ArrayUtil;
import com.ibm.ws.sib.mfp.util.HexUtil;
import java.io.PrintWriter;
import java.math.BigInteger;
import java.util.Date;

public final class JSFormatter {
    private static int MAX_FORMAT_SIZE = 10240;

    private JSFormatter() {
    }

    public static String formatMap(MessageMap map, JMFSchema schema) {
        int i;
        JmfTr.setTracing(false);
        StringBuffer ans = new StringBuffer();
        JSVariant[] vars = ((JSchema)schema).getVariants();
        JSField[] fields = ((JSchema)schema).getFields();
        ans.append("MultiChoice Code=").append(map.multiChoice);
        ans.append(", Offset Table Size=").append(map.offsetsNeeded);
        ans.append("\nVariant settings:\n");
        for (i = 0; i < map.choiceCodes.length; ++i) {
            int code = map.choiceCodes[i];
            if (code == -1) continue;
            JSVariant var = vars[i];
            String caseName = var.getCase(code).getFeatureName();
            if (caseName == null || caseName.length() == 0) {
                caseName = "[" + code + "]";
            }
            ans.append(" ").append(JSFormatter.getUsefulName((JSchema)schema, var)).append("=").append(caseName).append("\n");
        }
        ans.append("Field offsets:\n");
        for (i = 0; i < map.fields.length; ++i) {
            MessageMap.Remap remap = map.fields[i];
            if (remap == null) continue;
            JSField field = fields[i];
            ans.append(" ");
            ans.append(JSFormatter.getUsefulName((JSchema)schema, field));
            ans.append("(").append(JSFormatter.getUsefulType(field)).append(")");
            ans.append(": ").append(JSFormatter.formatRemap(remap));
            ans.append("\n");
        }
        JmfTr.setTracing(true);
        return ans.toString();
    }

    private static String getUsefulName(JSchema schema, JSField field) {
        String ans = schema.getPathName(field);
        if (ans.length() == 0) {
            ans = "<root>";
        }
        return ans;
    }

    private static String getUsefulType(JSField field) {
        StringBuilder list = new StringBuilder();
        for (int j = 0; j < field.getIndirection() + 1; ++j) {
            list.append("List of ");
        }
        if (field instanceof JSEnum) {
            return new String(list.append("Enum"));
        }
        if (field instanceof JSDynamic) {
            return new String(list.append("Dynamic"));
        }
        if (field instanceof JSVariant) {
            return new String(list.append("Variant Box"));
        }
        return new String(list.append(((JSPrimitive)field).getXSDTypeName()));
    }

    private static String formatRemap(MessageMap.Remap remap) {
        String ans = "";
        if (remap.offsetIndex > -1) {
            ans = ans + "[" + remap.offsetIndex + "]";
        }
        ans = ans + "+" + remap.fixedIncr;
        return ans;
    }

    public static String formatSchema(JMFSchema schema, BigInteger multiChoice) {
        JmfTr.setTracing(false);
        String ans = JSFormatter.formatMap(new MessageMap((JSchema)schema, multiChoice), schema);
        JmfTr.setTracing(true);
        return ans;
    }

    public static String formatSchema(JMFSchema schema, String box, BigInteger multiChoice) {
        int accessor = schema.getAccessor(box);
        if (accessor == -1) {
            return null;
        }
        JMFFieldDef field = schema.getFieldDef(accessor);
        if (!(field instanceof JSVariant)) {
            return null;
        }
        JSVariant boxedBy = ((JSVariant)field).getBoxedBy();
        if (boxedBy == null) {
            return null;
        }
        JSchema realSchema = (JSchema)boxedBy.getBoxed();
        if (realSchema == null) {
            return null;
        }
        JmfTr.setTracing(false);
        String ans = JSFormatter.formatSchema(realSchema, multiChoice);
        JmfTr.setTracing(true);
        return ans;
    }

    public static void schemaBook(JMFSchema schema, PrintWriter wtr) {
        JmfTr.setTracing(false);
        wtr.println("Schema Book for " + JSFormatter.formatSchema(schema));
        wtr.println();
        JSFormatter.printBook((JSchema)schema, wtr);
        JSField[] fields = ((JSchema)schema).getFields();
        for (int i = 0; i < fields.length; ++i) {
            if (!(fields[i] instanceof JSVariant)) continue;
            JSVariant var = (JSVariant)fields[i];
            wtr.println("Maps for boxed variant " + schema.getPathName(var));
            wtr.println();
            JSFormatter.printBook((JSchema)var.getBoxed(), wtr);
        }
        JmfTr.setTracing(true);
    }

    private static void printBook(JSchema schema, PrintWriter wtr) {
        BigInteger i = BigInteger.ZERO;
        while (i.compareTo(((JSType)schema.getJMFType()).getMultiChoiceCount()) < 0) {
            wtr.println(JSFormatter.formatMap(new MessageMap(schema, i), schema));
            wtr.println();
            i = i.add(BigInteger.ONE);
        }
    }

    public static String format(JMFMessage msg) {
        return JSFormatter.format(msg, true, true);
    }

    public static String formatWithoutHashcodes(JMFMessage msg) {
        return JSFormatter.format(msg, false, true);
    }

    public static String formatWithoutPayloadData(JMFMessage msg) {
        return JSFormatter.format(msg, true, false);
    }

    public static String format(JMFMessage msg, boolean includeHashcode, boolean includePayloadData) {
        StringBuffer ans = new StringBuffer();
        JmfTr.setTracing(false);
        try {
            ans.append("JMFMessage: ");
            if (includeHashcode) {
                ans.append(msg.toString()).append(", ");
            }
            ans.append("JMF version=").append(msg.getJMFEncodingVersion());
            JMFSchema[] schemata = msg.getSchemata();
            ans.append(", Schema=").append(JSFormatter.formatSchema(schemata[0])).append("\n");
            if (schemata.length > 1) {
                ans.append("Also uses:");
                for (int i = 1; i < schemata.length; ++i) {
                    ans.append(" ").append(JSFormatter.formatSchema(schemata[i]));
                }
                ans.append("\n");
            }
            ans.append("Length=");
            try {
                ans.append(msg.getEncodedLength()).append("\n");
            }
            catch (Exception e) {
                ans.append("getEncodedLength failed, Exception: ");
                ans.append(e.toString()).append("\n");
            }
            JSFormatter.formatPartToBuffer(ans, msg, "  ", includeHashcode, includePayloadData, true);
        }
        catch (Exception ex) {
            ans.append("\nMessage probably corrupted. Exception: ");
            ans.append(ex.toString());
        }
        JmfTr.setTracing(true);
        return ans.toString();
    }

    public static String formatPart(JMFNativePart part) {
        StringBuffer ans = new StringBuffer();
        JmfTr.setTracing(false);
        try {
            ans.append("JMFNativePart: ").append(part.toString()).append(", Schema=").append(JSFormatter.formatSchema(part.getEncodingSchema())).append("\n");
            JSFormatter.formatPartToBuffer(ans, part, "  ", true, true, true);
        }
        catch (Exception ex) {
            ans.append("\nMessage probably corrupted. Exception: ");
            ans.append(ex.toString());
        }
        JmfTr.setTracing(true);
        return ans.toString();
    }

    private static String formatSchema(JMFSchema schema) {
        if (schema == null) {
            return "null schema";
        }
        byte[] buf = new byte[8];
        ArrayUtil.writeLong(buf, 0, schema.getID());
        return schema.getName() + "(" + HexUtil.toString(buf) + ")";
    }

    private static void formatPartToBuffer(StringBuffer ans, JMFNativePart part, String indent, boolean includeHashcode, boolean includePayloadData, boolean includeValueData) throws JMFException {
        JSchema schema = (JSchema)part.getJMFSchema();
        JSField[] fields = schema.getFields();
        JSFormatter.formatVariants(ans, part, fields.length, schema.getVariants(), indent);
        JSFormatter.formatFields(ans, part, fields, indent, includeHashcode, includePayloadData, includeValueData);
    }

    private static void formatVariants(StringBuffer ans, JMFNativePart part, int bias, JSVariant[] vars, String indent) throws JMFException {
        JSchema schema = (JSchema)part.getJMFSchema();
        ans.append(indent).append("Variants:\n");
        for (int i = 0; i < vars.length; ++i) {
            if (!part.isPresent(bias + i)) continue;
            JSVariant var = vars[i];
            String name = schema.getPathName(var);
            if (name == null || name.length() == 0) {
                name = "<unnamed>";
            }
            ans.append(indent).append(name).append("=");
            String caseName = var.getCase(part.getInt(bias + i)).getFeatureName();
            if (caseName != null && caseName.length() > 0) {
                ans.append(caseName);
            } else {
                ans.append(part.getValue(bias + i));
            }
            ans.append("\n");
        }
    }

    private static void formatFields(StringBuffer ans, JMFNativePart part, JSField[] fields, String indent, boolean includeHashcode, boolean includePayloadData, boolean includeValueData) throws JMFException {
        JSchema schema = (JSchema)part.getJMFSchema();
        ans.append(indent).append("Fields:\n");
        for (int i = 0; i < fields.length; ++i) {
            if (!part.isPresent(i)) continue;
            String name = schema.getPathName(fields[i]);
            if (name == null || name.length() == 0) {
                name = "<unnamed>";
            }
            ans.append(indent).append(name).append("=");
            String fieldName = schema.getFieldDef(i).getFeatureName();
            if (!includeValueData || !includePayloadData && name.equals("payload/data")) {
                JSFormatter.formatValue(ans, part.getValue(i), indent, includeHashcode, false);
                continue;
            }
            if (fieldName != null && fieldName.toLowerCase().equals("password")) {
                JSFormatter.formatValue(ans, "********", indent, includeHashcode, true);
                continue;
            }
            if (fields[i].getCoder() instanceof JSDynamic || fields[i].getCoder() instanceof JSListCoder || part.estimateUnassembledValueSize(i) < MAX_FORMAT_SIZE) {
                JSFormatter.formatValue(ans, part.getValue(i), indent, includeHashcode, true);
                continue;
            }
            ans.append("*** Value too large to format, estimated unassembled size: " + part.estimateUnassembledValueSize(i));
            ans.append("\n");
        }
    }

    private static void formatValue(StringBuffer ans, Object val, String indent, boolean includeHashcode, boolean includeValueData) throws JMFException {
        if (val instanceof JMFNativePart) {
            JMFNativePart subPart = (JMFNativePart)val;
            ans.append("JMFNativePart");
            if (includeHashcode) {
                ans.append(" ").append(subPart.toString());
            }
            ans.append(", Schema=").append(JSFormatter.formatSchema(subPart.getEncodingSchema())).append(":\n");
            JSFormatter.formatPartToBuffer(ans, subPart, indent + "  ", includeHashcode, includeValueData, includeValueData);
        } else if (val instanceof JMFList) {
            JMFList list = (JMFList)val;
            ans.append("JSList");
            if (includeHashcode) {
                ans.append(" ").append(list.toString());
            }
            ans.append(", size=").append(list.size()).append(":\n");
            JSFormatter.formatList(ans, list, indent + "  ", includeHashcode, includeValueData);
        } else {
            if (includeValueData) {
                if (val instanceof Date) {
                    ans.append(((Date)val).toGMTString());
                } else if (val instanceof byte[]) {
                    ans.append(HexUtil.toString((byte[])val));
                } else {
                    ans.append(val);
                }
            } else {
                ans.append("<<*** user data ***>>");
            }
            ans.append("\n");
        }
    }

    private static void formatList(StringBuffer ans, JMFList list, String indent, boolean includeHashcode, boolean includeValueData) throws JMFException {
        for (int i = 0; i < list.size(); ++i) {
            ans.append(indent).append("[").append(i).append("] ");
            if (list.isPresent(i)) {
                JSFormatter.formatValue(ans, list.get(i), indent, includeHashcode, includeValueData);
                continue;
            }
            ans.append("<missing>\n");
        }
    }
}

