/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.jfapchannel.impl;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.sib.jfapchannel.ClientConnectionManager;
import com.ibm.ws.sib.jfapchannel.Conversation;
import com.ibm.ws.sib.jfapchannel.ConversationReceiveListener;
import com.ibm.ws.sib.jfapchannel.ConversationUsageType;
import com.ibm.ws.sib.jfapchannel.framework.Framework;
import com.ibm.ws.sib.jfapchannel.impl.octracker.OutboundConnectionTracker;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.net.InetSocketAddress;
import java.util.List;

public class ClientConnectionManagerImpl
extends ClientConnectionManager {
    private static final TraceComponent tc = SibTr.register(ClientConnectionManagerImpl.class, (String)"SIBJFapChannel", (String)"com.ibm.ws.sib.jfapchannel.CWSIJMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.jfapchannel.CWSIJMessages");
    private static OutboundConnectionTracker tracker;
    private static boolean initialisationFailed;

    public ClientConnectionManagerImpl() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"<init>");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"<init>");
        }
    }

    @Override
    public Conversation connect(InetSocketAddress remoteHost, ConversationReceiveListener arl, String chainName) throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"connect", (Object)new Object[]{remoteHost, arl, chainName});
        }
        if (initialisationFailed) {
            String nlsMsg = nls.getFormattedMessage("EXCP_CONN_FAIL_NO_CF_SICJ0007", null, null);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"connection failed because comms failed to initialise");
            }
            throw new SIResourceException(nlsMsg);
        }
        Conversation conversation = tracker.connect(remoteHost, arl, chainName, Conversation.CLIENT);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"connect", (Object)conversation);
        }
        return conversation;
    }

    @Override
    public Conversation connect(Object endpoint, ConversationReceiveListener conversationReceiveListener) throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"connect", (Object)new Object[]{endpoint, conversationReceiveListener});
        }
        if (initialisationFailed) {
            String nlsMsg = nls.getFormattedMessage("EXCP_CONN_FAIL_NO_CF_SICJ0007", null, null);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"connection failed because comms failed to initialise");
            }
            throw new SIResourceException(nlsMsg);
        }
        Conversation conversation = tracker.connect(endpoint, conversationReceiveListener, Conversation.CLIENT);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"connect", (Object)conversation);
        }
        return conversation;
    }

    @Override
    public Conversation connect(ConversationReceiveListener receiveListener, ConversationUsageType type) throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"connect", (Object)new Object[]{receiveListener, type});
        }
        if (initialisationFailed) {
            String nlsMsg = nls.getFormattedMessage("EXCP_CONN_FAIL_NO_CF_SICJ0007", null, null);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"connection failed because comms failed to initialise");
            }
            throw new SIResourceException(nlsMsg);
        }
        Conversation conversation = tracker.connect(receiveListener, Conversation.CLIENT, type);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"connect", (Object)conversation);
        }
        return conversation;
    }

    public static void initialise() throws SIErrorException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"initialise");
        }
        initialisationFailed = true;
        Framework framework = Framework.getInstance();
        if (framework != null) {
            tracker = new OutboundConnectionTracker(framework);
            initialisationFailed = false;
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"initialisation failed");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"initialise");
        }
    }

    @Override
    public List getActiveOutboundConversations() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getActiveOutboundConversations");
        }
        List convs = null;
        if (tracker != null) {
            convs = tracker.getAllOutboundConversations();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getActiveOutboundConversations", (Object)convs);
        }
        return convs;
    }

    @Override
    public List getActiveOutboundConversationsForFfdc() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getActiveOutboundConversationsForFfdc");
        }
        List convs = null;
        if (tracker != null) {
            convs = tracker.getAllOutboundConversationsForFfdc();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getActiveOutboundConversationsForFfdc", (Object)convs);
        }
        return convs;
    }

    protected static void setOutboundConnectionTracker(OutboundConnectionTracker tracker) {
        ClientConnectionManagerImpl.tracker = tracker;
    }

    @Override
    public OutboundConnectionTracker getOutboundConnectionTracker() {
        return tracker;
    }

    static {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"@(#) SIB/ws/code/sib.jfapchannel.client.common.impl/src/com/ibm/ws/sib/jfapchannel/impl/ClientConnectionManagerImpl.java, SIB.comms, WASX.SIB, uu1215.01 1.47");
        }
        tracker = null;
        initialisationFailed = false;
    }
}

