/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.common.gzip;

import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;
import org.apache.cxf.common.i18n.BundleUtils;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.helpers.HttpHeaderHelper;
import org.apache.cxf.interceptor.AttachmentInInterceptor;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.transport.common.gzip.GZIPOutInterceptor;

@TraceObjectField(fieldName="LOG", fieldDesc="Ljava/util/logging/Logger;")
public class GZIPInInterceptor
extends AbstractPhaseInterceptor<Message> {
    private static final ResourceBundle BUNDLE = BundleUtils.getBundle(GZIPInInterceptor.class);
    private static final Logger LOG = LogUtils.getL7dLogger(GZIPInInterceptor.class);
    static final long serialVersionUID = -78675332158731909L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public GZIPInInterceptor() {
        super("receive");
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.transport.common.gzip.GZIPInInterceptor", "<init>", new Object[0]);
        }
        this.addBefore(AttachmentInInterceptor.class.getName());
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.transport.common.gzip.GZIPInInterceptor", "<init>", this);
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void handleMessage(Message message) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.transport.common.gzip.GZIPInInterceptor", "handleMessage", new Object[]{message});
        }
        boolean isLoggableFine = LOG.isLoggable(Level.FINE);
        if (isLoggableFine) {
            LOG.fine("Inside handleMessage of GZIPInInterceptor");
        }
        if (this.isGET(message)) {
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                LOG.exiting("org.apache.cxf.transport.common.gzip.GZIPInInterceptor", "handleMessage");
            }
            return;
        }
        Map<String, List<String>> protocolHeaders = CastUtils.cast((Map)message.get(Message.PROTOCOL_HEADERS));
        if (protocolHeaders != null) {
            List<String> contentEncoding = HttpHeaderHelper.getHeader(protocolHeaders, "Content-Encoding");
            if (contentEncoding == null) {
                contentEncoding = protocolHeaders.get("SOAPJMS_contentEncoding");
            }
            if (contentEncoding != null && (contentEncoding.contains("gzip") || contentEncoding.contains("x-gzip"))) {
                InputStream is;
                block17: {
                    if (isLoggableFine) {
                        LOG.fine("Uncompressing response");
                    }
                    if ((is = message.getContent(InputStream.class)) != null) break block17;
                    if (isLoggableFine) {
                        LOG.fine("GZIPInInterceptor: InputStream is null, returning");
                    }
                    if (LOG != null && LOG.isLoggable(Level.FINER)) {
                        LOG.exiting("org.apache.cxf.transport.common.gzip.GZIPInInterceptor", "handleMessage");
                    }
                    return;
                }
                try {
                    GZIPInputStream zipInput = new GZIPInputStream(is);
                    message.setContent(InputStream.class, zipInput);
                    for (String key : protocolHeaders.keySet()) {
                        if (!"Content-Encoding".equalsIgnoreCase(key)) continue;
                        protocolHeaders.remove(key);
                        break;
                    }
                    if (this.isRequestor(message)) {
                        Endpoint ep = message.getExchange().getEndpoint();
                        ep.put(GZIPOutInterceptor.USE_GZIP_KEY, GZIPOutInterceptor.UseGzip.YES);
                        if (isLoggableFine) {
                            LOG.fine("Setting GZIPOutInterceptor.UseGzip for Endpoint: " + (ep.getService() != null ? ep.getService().getName() : "null"));
                        }
                    }
                }
                catch (IOException ex) {
                    throw new Fault(new org.apache.cxf.common.i18n.Message("COULD_NOT_UNZIP", BUNDLE, new Object[0]), (Throwable)ex);
                }
            }
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.transport.common.gzip.GZIPInInterceptor", "handleMessage");
        }
    }
}

