/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.utility.tasks;

import com.ibm.ws.crypto.util.AESKeyManager;
import com.ibm.ws.security.utility.IFileUtility;
import com.ibm.ws.security.utility.SecurityUtilityReturnCodes;
import com.ibm.ws.security.utility.tasks.BaseCommandTask;
import com.ibm.ws.security.utility.utils.ConsoleWrapper;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;

public class GenerateAesKeyTask
extends BaseCommandTask {
    private static final String ARG_FILE = "--createConfigFile";
    private static final List<String> VALID_ARGUMENTS = Collections.unmodifiableList(Arrays.asList("--key", "--createConfigFile"));
    protected static final String TASK_NAME = "generateAESKey";
    private final IFileUtility fileUtil;

    public GenerateAesKeyTask(IFileUtility fileUtil, String scriptName) {
        super(scriptName);
        this.fileUtil = fileUtil;
    }

    @Override
    void checkRequiredArguments(String[] args) throws IllegalArgumentException {
    }

    @Override
    public String getTaskDescription() {
        return this.getOption("generateaeskey.desc", true, new Object[0]);
    }

    @Override
    public String getTaskHelp() {
        return this.getTaskHelp("generateaeskey.desc", "generateaeskey.usage.options", "generateaeskey.required-key.", "generateaeskey.required-desc.", "generateaeskey.option-key.", "generateaeskey.option-desc.", null, null, this.scriptName);
    }

    @Override
    public String getTaskName() {
        return TASK_NAME;
    }

    @Override
    public SecurityUtilityReturnCodes handleTask(ConsoleWrapper stdin, PrintStream stdout, PrintStream stderr, String[] args) throws Exception {
        CommandArguments parsedArgs = this.parseArgs(args, this.fileUtil);
        PasswordEncryptionConfigBuilder builder = new PasswordEncryptionConfigBuilder(parsedArgs.keyPhrase, parsedArgs.filePath, this.fileUtil, stderr);
        if (builder.getFilePath() == null) {
            stdout.println(builder.getKey());
        } else {
            builder.generateXML();
            stdout.println(GenerateAesKeyTask.getMessage("generate.success", new File(builder.getFilePath()).getAbsolutePath()));
        }
        return SecurityUtilityReturnCodes.OK;
    }

    @Override
    boolean isKnownArgument(String arg) {
        return arg != null && VALID_ARGUMENTS.contains(arg);
    }

    private CommandArguments parseArgs(String[] args, IFileUtility fileUtil) {
        String keyPhrase = null;
        String filePath = null;
        for (int i = 1; i < args.length; ++i) {
            String arg = args[i];
            if (!arg.startsWith("--")) {
                throw new IllegalArgumentException(GenerateAesKeyTask.getMessage("invalidArg", arg));
            }
            int index = arg.indexOf(61);
            if (index == -1) {
                throw new IllegalArgumentException(GenerateAesKeyTask.getMessage("invalidArg", arg));
            }
            String value = index + 1 < arg.length() ? arg.substring(index + 1) : null;
            String option = arg.substring(0, index);
            if (!this.isKnownArgument(option)) {
                throw new IllegalArgumentException(GenerateAesKeyTask.getMessage("invalidArg", option));
            }
            if ("--key".equals(option)) {
                if (value == null) {
                    throw new IllegalArgumentException(GenerateAesKeyTask.getMessage("missingValue", option));
                }
                keyPhrase = value;
                continue;
            }
            if (!ARG_FILE.equals(option)) continue;
            if (value == null) {
                throw new IllegalArgumentException(GenerateAesKeyTask.getMessage("missingValue", option));
            }
            File file = new File(value);
            if (fileUtil.isDirectory(file)) {
                throw new IllegalArgumentException(GenerateAesKeyTask.getMessage("generateaeskey.failFileIsDirectory", value));
            }
            if (fileUtil.exists(file)) {
                throw new IllegalArgumentException(GenerateAesKeyTask.getMessage("generateaeskey.failFileExists", value));
            }
            filePath = value;
        }
        return new CommandArguments(keyPhrase, filePath);
    }

    private static class CommandArguments {
        final String keyPhrase;
        final String filePath;

        CommandArguments(String keyPhrase, String filePath) {
            this.keyPhrase = keyPhrase;
            this.filePath = filePath;
        }
    }

    public static class PasswordEncryptionConfigBuilder {
        private final String filePath;
        private final String passphrase;
        private final IFileUtility fileUtil;
        private final PrintStream stderr;

        public PasswordEncryptionConfigBuilder(String keyPhrase, String filePath, IFileUtility fileUtil, PrintStream stderr) {
            this.passphrase = keyPhrase;
            this.filePath = filePath;
            this.fileUtil = fileUtil;
            this.stderr = stderr;
        }

        public String getFilePath() {
            return this.filePath;
        }

        private String formatXml(String name, String value) {
            StringBuilder xml = new StringBuilder();
            xml.append("<server>\n");
            xml.append("    <variable name=\"").append(name).append("\" value=\"").append(value).append("\" />\n");
            xml.append("</server>");
            return xml.toString();
        }

        protected static String generateRandomAes256Key() {
            byte[] keyBytes;
            SecureRandom secureRandom = new SecureRandom();
            try {
                KeyGenerator keyGenerator = KeyGenerator.getInstance("AES");
                keyGenerator.init(256, secureRandom);
                SecretKey secretKey = keyGenerator.generateKey();
                keyBytes = secretKey.getEncoded();
            }
            catch (NoSuchAlgorithmException e) {
                keyBytes = new byte[32];
                secureRandom.nextBytes(keyBytes);
            }
            return Base64.getEncoder().encodeToString(keyBytes);
        }

        protected static String generateAes256KeyWithPBKDF2(String phrase) throws NoSuchAlgorithmException, InvalidKeySpecException {
            byte[] data = AESKeyManager.KeyVersion.AES_V1.buildAesKeyWithPbkdf2(phrase.toCharArray());
            return Base64.getEncoder().encodeToString(data);
        }

        public void generateXML() throws IOException, NoSuchAlgorithmException, InvalidKeySpecException {
            this.generateXML(this.getKey(), this.filePath);
        }

        private void generateXML(String key, String filePath) throws IOException, NoSuchAlgorithmException, InvalidKeySpecException {
            String xmlContent = this.formatXml("wlp.aes.encryption.key", key);
            this.fileUtil.writeToFile(this.stderr, xmlContent, new File(filePath));
        }

        private String getKey() throws NoSuchAlgorithmException, InvalidKeySpecException {
            String keyValue = this.passphrase == null ? PasswordEncryptionConfigBuilder.generateRandomAes256Key() : PasswordEncryptionConfigBuilder.generateAes256KeyWithPBKDF2(this.passphrase);
            return keyValue;
        }
    }
}

