/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.logging.internal.impl;

import com.ibm.ws.logging.internal.impl.IncidentLogger;
import com.ibm.ws.logging.internal.impl.IncidentStreamImpl;
import com.ibm.ws.logging.internal.impl.LoggingFileUtils;
import com.ibm.wsspi.logging.Incident;
import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Date;

public class ForwardIncident
implements Incident {
    private final Incident originalIncident;
    private final Throwable th;
    private final Object callerThis;
    private final Object[] objectArray;

    ForwardIncident(Incident originalIncident, Throwable th, Object callerThis, Object[] objectArray) {
        this.originalIncident = originalIncident;
        this.th = th;
        this.callerThis = callerThis;
        this.objectArray = objectArray;
    }

    @Override
    public String getSourceId() {
        return this.originalIncident.getSourceId();
    }

    @Override
    public String getProbeId() {
        return this.originalIncident.getProbeId();
    }

    @Override
    public String getExceptionName() {
        return this.originalIncident.getExceptionName();
    }

    @Override
    public int getCount() {
        return this.originalIncident.getCount();
    }

    @Override
    public long getTimeStamp() {
        return this.originalIncident.getTimeStamp();
    }

    @Override
    public Date getDateOfFirstOccurrence() {
        return this.originalIncident.getDateOfFirstOccurrence();
    }

    @Override
    public String getLabel() {
        return this.originalIncident.getLabel();
    }

    @Override
    public long getThreadId() {
        return this.originalIncident.getThreadId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getIntrospectedCallerDump() {
        String dump = null;
        ByteArrayOutputStream oStream = new ByteArrayOutputStream();
        IncidentStreamImpl iStream = null;
        try {
            iStream = new IncidentStreamImpl(oStream);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (iStream != null) {
            try {
                new IncidentLogger().logIncident(iStream, this, this.th, this.callerThis, this.objectArray, true);
            }
            catch (Throwable e) {
                iStream.printStackTrace(e);
            }
            finally {
                LoggingFileUtils.tryToClose(iStream);
                try {
                    dump = oStream.toString("UTF-8");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {}
            }
        }
        return dump;
    }
}

