/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.operator;

import java.security.SecureRandom;
import org.bouncycastle.bcpg.AEADUtils;
import org.bouncycastle.bcpg.ContainedPacket;
import org.bouncycastle.bcpg.S2K;
import org.bouncycastle.bcpg.SymmetricKeyEncSessionPacket;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.operator.PGPDigestCalculator;
import org.bouncycastle.openpgp.operator.PGPKeyEncryptionMethodGenerator;
import org.bouncycastle.openpgp.operator.PGPUtil;
import org.bouncycastle.util.Arrays;

public abstract class PBEKeyEncryptionMethodGenerator
extends PGPKeyEncryptionMethodGenerator {
    private char[] passPhrase;
    private PGPDigestCalculator s2kDigestCalculator;
    private S2K s2k;
    private SecureRandom random;
    private int s2kCount;
    private int wrapAlg = -1;

    protected PBEKeyEncryptionMethodGenerator(char[] cArray, PGPDigestCalculator pGPDigestCalculator) {
        this(cArray, pGPDigestCalculator, 96);
    }

    protected PBEKeyEncryptionMethodGenerator(char[] cArray, S2K.Argon2Params argon2Params) {
        this.passPhrase = cArray;
        this.s2k = new S2K(argon2Params);
    }

    protected PBEKeyEncryptionMethodGenerator(char[] cArray, PGPDigestCalculator pGPDigestCalculator, int n) {
        this.passPhrase = cArray;
        this.s2kDigestCalculator = pGPDigestCalculator;
        if (n < 0 || n > 255) {
            throw new IllegalArgumentException("s2kCount value outside of range 0 to 255.");
        }
        this.s2kCount = n;
    }

    public PBEKeyEncryptionMethodGenerator setSecureRandom(SecureRandom secureRandom) {
        this.random = secureRandom;
        return this;
    }

    public PBEKeyEncryptionMethodGenerator setSessionKeyWrapperAlgorithm(int n) {
        this.wrapAlg = n;
        return this;
    }

    public int getSessionKeyWrapperAlgorithm(int n) {
        if (this.wrapAlg < 0) {
            return n;
        }
        return this.wrapAlg;
    }

    public byte[] getKey(int n) throws PGPException {
        if (this.s2k == null) {
            byte[] byArray = new byte[8];
            if (this.random == null) {
                this.random = new SecureRandom();
            }
            this.random.nextBytes(byArray);
            this.s2k = new S2K(this.s2kDigestCalculator.getAlgorithm(), byArray, this.s2kCount);
        }
        return PGPUtil.makeKeyFromPassPhrase(this.s2kDigestCalculator, n, this.s2k, this.passPhrase);
    }

    @Override
    public ContainedPacket generateV5(int n, int n2, byte[] byArray) throws PGPException {
        return this.generate(n, byArray);
    }

    @Override
    public ContainedPacket generateV6(int n, int n2, byte[] byArray) throws PGPException {
        return this.generateV6ESK(n, n2, byArray);
    }

    private ContainedPacket generateV5ESK(int n, int n2, byte[] byArray) throws PGPException {
        byte[] byArray2 = this.getKey(n);
        byte[] byArray3 = new byte[]{-61, 5, (byte)n, (byte)n2};
        byte[] byArray4 = new byte[AEADUtils.getIVLength(n2)];
        this.random.nextBytes(byArray4);
        int n3 = AEADUtils.getAuthTagLength(n2);
        byte[] byArray5 = this.getEskAndTag(n, n2, byArray, byArray2, byArray4, byArray3);
        byte[] byArray6 = Arrays.copyOfRange(byArray5, 0, byArray5.length - n3);
        byte[] byArray7 = Arrays.copyOfRange(byArray5, byArray6.length, byArray5.length);
        return SymmetricKeyEncSessionPacket.createV5Packet(n, n2, byArray4, this.s2k, byArray6, byArray7);
    }

    private ContainedPacket generateV6ESK(int n, int n2, byte[] byArray) throws PGPException {
        byte[] byArray2 = this.getKey(n);
        byte[] byArray3 = new byte[]{-61, 6, (byte)n, (byte)n2};
        byte[] byArray4 = this.generateV6KEK(n, byArray2, byArray3);
        byte[] byArray5 = new byte[AEADUtils.getIVLength(n2)];
        this.random.nextBytes(byArray5);
        int n3 = AEADUtils.getAuthTagLength(n2);
        byte[] byArray6 = this.getEskAndTag(n, n2, byArray, byArray4, byArray5, byArray3);
        byte[] byArray7 = Arrays.copyOfRange(byArray6, 0, byArray6.length - n3);
        byte[] byArray8 = Arrays.copyOfRange(byArray6, byArray7.length, byArray6.length);
        return SymmetricKeyEncSessionPacket.createV6Packet(n, n2, byArray5, this.s2k, byArray7, byArray8);
    }

    @Override
    public ContainedPacket generate(int n, byte[] byArray) throws PGPException {
        if (byArray == null) {
            return SymmetricKeyEncSessionPacket.createV4Packet(n, this.s2k, null);
        }
        byte[] byArray2 = this.getKey(n);
        byte[] byArray3 = new byte[byArray.length - 2];
        System.arraycopy(byArray, 0, byArray3, 0, byArray3.length);
        return SymmetricKeyEncSessionPacket.createV4Packet(n, this.s2k, this.encryptSessionInfo(n, byArray2, byArray3));
    }

    protected abstract byte[] encryptSessionInfo(int var1, byte[] var2, byte[] var3) throws PGPException;

    protected abstract byte[] getEskAndTag(int var1, int var2, byte[] var3, byte[] var4, byte[] var5, byte[] var6) throws PGPException;

    protected abstract byte[] generateV6KEK(int var1, byte[] var2, byte[] var3) throws PGPException;
}

