/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http.channel.h2internal.hpack;

import com.ibm.ws.http.channel.h2internal.hpack.DynamicTable;
import com.ibm.ws.http.channel.h2internal.hpack.H2HeaderField;
import com.ibm.ws.http.channel.h2internal.hpack.StaticTable;
import java.util.Iterator;

public class H2HeaderTable {
    private final DynamicTable dynamicTable;

    public H2HeaderTable() {
        this.dynamicTable = new DynamicTable();
    }

    public H2HeaderTable(int tableSize) {
        this.dynamicTable = new DynamicTable(tableSize);
    }

    public H2HeaderField getHeaderEntry(int index) {
        if (index <= StaticTable.STATIC_TABLE.size()) {
            return H2HeaderTable.getFromStaticTable(index);
        }
        return this.dynamicTable.get(index - StaticTable.STATIC_TABLE.size() - 1);
    }

    public H2HeaderField getHeaderEntry(String name, String value) {
        int hashName = name.hashCode();
        int hashValue = value.hashCode();
        H2HeaderField staticResult = null;
        H2HeaderField dynamicResult = null;
        staticResult = H2HeaderTable.findInStaticTable(hashName, hashValue);
        if (staticResult != null && staticResult.getValueHash() == hashValue) {
            return staticResult;
        }
        dynamicResult = this.dynamicTable.findInList(hashName, hashValue);
        if (dynamicResult != null && dynamicResult.getValueHash() == hashValue) {
            return dynamicResult;
        }
        return staticResult != null ? staticResult : dynamicResult;
    }

    private static H2HeaderField getFromStaticTable(int index) {
        return StaticTable.STATIC_TABLE.get(index - 1);
    }

    private static H2HeaderField findInStaticTable(int name, int value) {
        Iterator<H2HeaderField> it = StaticTable.STATIC_TABLE.iterator();
        H2HeaderField result = null;
        H2HeaderField current = null;
        while (it.hasNext()) {
            current = it.next();
            if (current.getNameHash() != name) continue;
            if (result == null) {
                result = current;
            }
            if (current.getValueHash() != value) continue;
            return current;
        }
        return result;
    }

    public void addHeaderEntry(H2HeaderField entry) {
        this.dynamicTable.addDynamicEntry(entry);
    }

    public void updateTableSize(int size) {
        this.dynamicTable.updateDynamicTableSize(size);
    }

    public int getDynamicTableUsedAddressSpace() {
        return this.dynamicTable.usedAddressSpace();
    }

    public String printDynamicTable() {
        return this.dynamicTable.toString();
    }

    public void setDynamicTableValidity(boolean isValid) {
        this.dynamicTable.setValidity(isValid);
    }

    public boolean isDynamicTableValid() {
        return this.dynamicTable.isValid();
    }

    public int getDynamicEntryCount() {
        return this.dynamicTable.amountOfEntries();
    }
}

