/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.http.options;

import io.openliberty.transport.config.options.EndpointOption;

public enum HttpOption implements EndpointOption
{
    KEEP_ALIVE_ENABLED("keepAliveEnabled", false, Boolean.class, EndpointOption.ConfigType.HTTP),
    MAX_KEEP_ALIVE_REQUESTS("maxKeepAliveRequests", -1, Integer.class, EndpointOption.ConfigType.HTTP),
    PERSIST_TIMEOUT("persistTimeout", "30s", String.class, EndpointOption.ConfigType.HTTP),
    READ_TIMEOUT("readTimeout", 60, Long.class, EndpointOption.ConfigType.HTTP),
    WRITE_TIMEOUT("writeTimeout", 60, Long.class, EndpointOption.ConfigType.HTTP),
    REMOVE_SERVER_HEADER("removeServerHeader", false, Boolean.class, EndpointOption.ConfigType.HTTP),
    NO_CACHE_COOKIES_CONTROL("NoCacheCookiesControl", true, Boolean.class, EndpointOption.ConfigType.HTTP),
    AUTO_DECOMPRESSION("AutoDecompression", true, Boolean.class, EndpointOption.ConfigType.HTTP),
    LIMIT_NUM_HEADERS("limitNumHeaders", 500, Integer.class, EndpointOption.ConfigType.HTTP),
    LIMIT_FIELD_SIZE("limitFieldSize", 32768, Integer.class, EndpointOption.ConfigType.HTTP),
    DO_NOT_ALLOW_DUPLICATE_SET_COOKIES("DoNotAllowDuplicateSetCookies", "false", String.class, EndpointOption.ConfigType.HTTP),
    MESSAGE_SIZE_LIMIT("MessageSizeLimit", -1L, Long.class, EndpointOption.ConfigType.HTTP),
    INCOMING_BODY_BUFFER_SIZE("incomingBodyBufferSize", 32768, Integer.class, EndpointOption.ConfigType.HTTP),
    THROW_IOE_FOR_INBOUND_CONNECTIONS("ThrowIOEForInboundConnections", null, Boolean.class, EndpointOption.ConfigType.HTTP),
    DECOMPRESSION_RATIO_LIMIT("decompressionRatioLimit", 200, Integer.class, EndpointOption.ConfigType.HTTP),
    DECOMPRESSION_TOLERANCE("decompressionTolerance", 3, Integer.class, EndpointOption.ConfigType.HTTP),
    HTTP2_CONNECTION_IDLE_TIMEOUT("http2ConnectionIdleTimeout", 0, Integer.class, EndpointOption.ConfigType.HTTP2),
    MAX_CONCURRENT_STREAMS("maxConcurrentStreams", 100, Integer.class, EndpointOption.ConfigType.HTTP2),
    MAX_FRAME_SIZE("maxFrameSize", 57344, Integer.class, EndpointOption.ConfigType.HTTP2),
    SETTINGS_INITIAL_WINDOW_SIZE("settingsInitialWindowSize", 65535, Integer.class, EndpointOption.ConfigType.HTTP2),
    CONNECTION_WINDOW_SIZE("connectionWindowSize", 65535, Integer.class, EndpointOption.ConfigType.HTTP2),
    LIMIT_WINDOW_UPDATE_FRAMES("limitWindowUpdateFrames", false, Boolean.class, EndpointOption.ConfigType.HTTP2),
    MAX_RESET_FRAMES("maxResetFrames", 100, Integer.class, EndpointOption.ConfigType.HTTP2),
    RESET_FRAMES_WINDOW("resetFramesWindow", "30s", String.class, EndpointOption.ConfigType.HTTP2),
    MAX_STREAMS_REFUSED("maxStreamsRefused", 100, Integer.class, EndpointOption.ConfigType.HTTP2);

    private final String key;
    private final Object defaultValue;
    private final Class<?> valueType;
    private final EndpointOption.ConfigType configType;

    private HttpOption(String key, Object defaultValue, Class<?> valueType, EndpointOption.ConfigType configType) {
        this.key = key;
        this.defaultValue = defaultValue;
        this.valueType = valueType;
        this.configType = configType;
    }

    public String getKey() {
        return this.key;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public Class<?> getValueType() {
        return this.valueType;
    }

    public EndpointOption.ConfigType getConfigType() {
        return this.configType;
    }
}

