/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.msgstore.list;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.sib.msgstore.AbstractItem;
import com.ibm.ws.sib.msgstore.Filter;
import com.ibm.ws.sib.msgstore.LockingCursor;
import com.ibm.ws.sib.msgstore.MessageStoreException;
import com.ibm.ws.sib.msgstore.NonLockingCursor;
import com.ibm.ws.sib.msgstore.SevereMessageStoreException;
import com.ibm.ws.sib.msgstore.cache.links.AbstractItemLink;
import com.ibm.ws.sib.msgstore.list.LinkedList;
import com.ibm.ws.sib.msgstore.list.PrioritizedList;
import com.ibm.ws.sib.msgstore.list.Subcursor;
import com.ibm.ws.sib.utils.ras.FormattedWriter;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.io.IOException;

public class PrioritizedCursor
implements LockingCursor,
NonLockingCursor {
    private static TraceComponent tc = SibTr.register(PrioritizedCursor.class, (String)"SIBMessageStore", (String)"com.ibm.ws.sib.msgstore.CWSISMessages");
    private boolean _allowUnavailableItems = false;
    private final Filter _itemFilter;
    private boolean _jumpbackEnabled;
    private final long _lockID;
    private PrioritizedCursor _previousCursor = null;
    private PrioritizedCursor _nextCursor = null;
    private final PrioritizedList _owningList;
    private final Subcursor[] _subCursors;

    PrioritizedCursor(PrioritizedList parentStream, Filter itemFilter, long lockID, boolean jumpbackEnabled) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"<init>", (Object)parentStream);
        }
        this._owningList = parentStream;
        this._itemFilter = itemFilter;
        this._lockID = lockID;
        this._jumpbackEnabled = jumpbackEnabled;
        this._subCursors = new Subcursor[10];
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"<init>");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private final Subcursor _getSubCursor(int priority) {
        LinkedList subList;
        Subcursor subCursor = this._subCursors[priority];
        if (subCursor == null && (subList = this._owningList.getPrioritySublist(priority)) != null) {
            Subcursor[] subcursorArray = this._subCursors;
            // MONITORENTER : this._subCursors
            subCursor = this._subCursors[priority];
            if (subCursor == null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)("Lazy initialize sub cursor for priority: " + priority));
                }
                this._subCursors[priority] = subCursor = new Subcursor(subList, this._itemFilter, this._jumpbackEnabled);
            }
            // MONITOREXIT : subcursorArray
        }
        if (!TraceComponent.isAnyTracingEnabled()) return subCursor;
        if (!tc.isDebugEnabled()) return subCursor;
        SibTr.debug((Object)this, (TraceComponent)tc, (String)("Using sub cursor: " + subCursor + " for priority: " + priority));
        return subCursor;
    }

    public final void allowUnavailableItems() {
        this._allowUnavailableItems = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void finished() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"finished");
        }
        Subcursor[] subcursorArray = this._subCursors;
        synchronized (this._subCursors) {
            for (int priority = 0; priority <= 9; ++priority) {
                if (null == this._subCursors[priority]) continue;
                this._subCursors[priority].finished();
                this._subCursors[priority] = null;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            this._owningList._removeCursor(this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"finished");
            }
            return;
        }
    }

    public final Filter getFilter() {
        return this._itemFilter;
    }

    public final long getLockID() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getLockID");
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getLockID", (Object)this._lockID);
        }
        return this._lockID;
    }

    final PrioritizedCursor getNextCursor() {
        return this._nextCursor;
    }

    final PrioritizedCursor getPreviousCursor() {
        return this._previousCursor;
    }

    final void linkAvailable(AbstractItemLink link) throws SevereMessageStoreException {
        int priority;
        Subcursor subCursor;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"linkAvailable", (Object)link);
        }
        if (null != (subCursor = this._getSubCursor(priority = link.getPriority()))) {
            subCursor.available(link);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"linkAvailable");
        }
    }

    public final AbstractItem next() throws MessageStoreException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"next");
        }
        AbstractItem found = null;
        for (int priority = 9; null == found && priority >= 0; --priority) {
            Subcursor subCursor = this._getSubCursor(priority);
            if (null == subCursor) continue;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("Search on subcursor for priority: " + priority));
            }
            found = -2L == this._lockID ? subCursor.next(this._allowUnavailableItems) : subCursor.next(this._lockID);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"next", found);
        }
        return found;
    }

    final void setNextCursor(PrioritizedCursor nextCursor) {
        this._nextCursor = nextCursor;
    }

    final void setPreviousCursor(PrioritizedCursor prevCursor) {
        this._previousCursor = prevCursor;
    }

    public final void xmlWriteOn(FormattedWriter writer) throws IOException {
        writer.write("<cursor");
        writer.write(" sihc=\"");
        int sihc = System.identityHashCode(this);
        writer.write(Integer.toHexString(sihc));
        writer.write(34);
        if (-2L != this._lockID) {
            writer.write(" lockId=\"");
            writer.write(Long.toString(this._lockID));
            writer.write(34);
        }
        if (this._allowUnavailableItems) {
            writer.write(" allowUnavailable=\"true\"");
        }
        if (this._jumpbackEnabled) {
            writer.write(" jumpbackEnabled=\"true\"");
        }
        boolean closedTag = false;
        for (int priority = 9; priority >= 0; --priority) {
            Object link;
            Subcursor cursor = this._subCursors[priority];
            if (null == cursor || null == (link = cursor.peepLastLink())) continue;
            if (!closedTag) {
                writer.write(">");
                writer.indent();
                closedTag = true;
            }
            writer.newLine();
            writer.write("<priority_");
            writer.write(Integer.toString(priority));
            writer.write(" lastLink=\"");
            int linkId = System.identityHashCode(link);
            writer.write(Integer.toHexString(linkId));
            writer.write(34);
            writer.write(" />");
        }
        if (closedTag) {
            writer.outdent();
            writer.newLine();
            writer.write("</cursor>");
        } else {
            writer.write("/>");
        }
    }

    public final AbstractItem next(int fromIndex) throws MessageStoreException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)("next( fromIndex)" + fromIndex));
        }
        AbstractItem found = null;
        for (int priority = 9; null == found && priority >= 0; --priority) {
            Subcursor subCursor = this._getSubCursor(priority);
            if (null == subCursor) continue;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("Search on subcursor for priority: " + priority));
            }
            found = -2L == this._lockID ? subCursor.next(this._allowUnavailableItems, fromIndex) : subCursor.next(this._lockID, fromIndex);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)("next( fromIndex)" + fromIndex), found);
        }
        return found;
    }
}

