/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http.channel.internal.values;

import com.ibm.ws.http.channel.internal.values.AccessLogData;
import com.ibm.ws.http.dispatcher.internal.HttpDispatcher;
import com.ibm.ws.http.internal.HttpDateFormatImpl;
import com.ibm.wsspi.http.channel.HttpRequestMessage;
import com.ibm.wsspi.http.channel.HttpResponseMessage;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

public class AccessLogStartTime
extends AccessLogData {
    private static ThreadLocal<Long> accessLogStartTime = new ThreadLocal();

    public AccessLogStartTime() {
        super("%t");
    }

    @Override
    public boolean set(StringBuilder accessLogEntry, HttpResponseMessage response, HttpRequestMessage request, Object data) {
        long startTime = AccessLogStartTime.getStartTime(response, request, data);
        if (startTime != 0L) {
            String formattedDate = "[" + ((HttpDateFormatImpl)HttpDispatcher.getDateFormatter()).getNCSATime(startTime, false) + "]";
            accessLogEntry.append(formattedDate);
            accessLogStartTime.set(startTime);
        } else {
            accessLogEntry.append("-");
        }
        return true;
    }

    public static long getStartTime(HttpResponseMessage response, HttpRequestMessage request, Object data) {
        long startTime = 0L;
        if (Objects.nonNull(request)) {
            long elapsedTime = System.nanoTime() - request.getStartTime();
            startTime = System.currentTimeMillis() - TimeUnit.NANOSECONDS.toMillis(elapsedTime);
        }
        return startTime;
    }

    public static long getStartTimeAsLongForJSON(HttpResponseMessage response, HttpRequestMessage request, Object data) {
        return accessLogStartTime.get();
    }
}

