/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.comms.common;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.Reliability;
import com.ibm.websphere.sib.exception.SIIncorrectCallException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.jfapchannel.Conversation;
import com.ibm.ws.sib.jfapchannel.HandshakeProperties;
import com.ibm.ws.sib.utils.RuntimeInfo;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.SIBusMessage;

public class CommsUtils {
    private static String CLASS_NAME = CommsUtils.class.getName();
    private static final TraceComponent tc = SibTr.register(CommsUtils.class, (String)"SIBCommunications", (String)"com.ibm.ws.sib.comms.CWSICMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.comms.CWSICMessages");

    public static String getRuntimeProperty(String property, String defaultValue) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getRuntimeProperty", (Object)new Object[]{property, defaultValue});
        }
        String runtimeProp = RuntimeInfo.getPropertyWithMsg((String)property, (String)defaultValue);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getRuntimeProperty", (Object)runtimeProp);
        }
        return runtimeProp;
    }

    public static boolean getRuntimeBooleanProperty(String property, String defaultValue) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getRuntimeBooleanProperty", (Object)new Object[]{property, defaultValue});
        }
        boolean runtimeProp = Boolean.valueOf(RuntimeInfo.getPropertyWithMsg((String)property, (String)defaultValue));
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getRuntimeBooleanProperty", (Object)("" + runtimeProp));
        }
        return runtimeProp;
    }

    public static int getRuntimeIntProperty(String property, String defaultValue) {
        int runtimeProp;
        block4: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"getRuntimeIntProperty", (Object)new Object[]{property, defaultValue});
            }
            runtimeProp = Integer.parseInt(defaultValue);
            try {
                runtimeProp = Integer.parseInt(RuntimeInfo.getPropertyWithMsg((String)property, (String)defaultValue));
            }
            catch (NumberFormatException e) {
                FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".getRuntimeIntProperty"), (String)"5-003-0001");
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block4;
                SibTr.debug((TraceComponent)tc, (String)"NumberFormatException: ", (Object)e);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getRuntimeIntProperty", (Object)("" + runtimeProp));
        }
        return runtimeProp;
    }

    public static double getRuntimeDoubleProperty(String property, String defaultValue) {
        double runtimeProp;
        block4: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"getRuntimeDoubleProperty", (Object)new Object[]{property, defaultValue});
            }
            runtimeProp = Double.parseDouble(defaultValue);
            try {
                runtimeProp = Double.parseDouble(RuntimeInfo.getPropertyWithMsg((String)property, (String)defaultValue));
            }
            catch (NumberFormatException e) {
                FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".getRuntimeDoubleProperty"), (String)"5-003-0002");
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block4;
                SibTr.debug((TraceComponent)tc, (String)"NumberFormatException: ", (Object)e);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getRuntimeDoubleProperty", (Object)("" + runtimeProp));
        }
        return runtimeProp;
    }

    public static void checkFapLevel(HandshakeProperties handShakeProps, short fapLevel) throws SIIncorrectCallException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"checkFapLevel", (Object)("" + fapLevel));
        }
        short actualFapVersion = handShakeProps.getFapLevel();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Actual FAP Level: ", (Object)("" + actualFapVersion));
        }
        if (fapLevel > actualFapVersion) {
            throw new SIIncorrectCallException(nls.getFormattedMessage("CALL_NOT_SUPPORTED_AT_FAP_LEVEL_SICO0101", new Object[]{"" + actualFapVersion}, "CALL_NOT_SUPPORTED_AT_FAP_LEVEL_SICO0101"));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"checkFapLevel");
        }
    }

    public static boolean requiresOptimizedTransaction(Conversation conversation) {
        HandshakeProperties handshakeProperties;
        boolean result;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"requiresOptimizedTransaction", (Object)conversation);
        }
        boolean bl = result = (handshakeProperties = conversation.getHandshakeProperties()).getFapLevel() >= 5 && (handshakeProperties.getCapabilites() & 0x40) != 0;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"requiresOptimizedTransaction", (Object)("" + result));
        }
        return result;
    }

    public static boolean isRecoverable(SIBusMessage mess, Reliability maxUnrecoverableReliability) {
        boolean recoverable;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isRecoverable", (Object)new Object[]{mess, maxUnrecoverableReliability});
        }
        Reliability messageReliability = mess.getReliability();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Message Reliability: ", (Object)messageReliability);
        }
        boolean bl = recoverable = messageReliability.compareTo((Object)maxUnrecoverableReliability) > 0;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"isRecoverable", (Object)recoverable);
        }
        return recoverable;
    }
}

