/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.api.jmsra.impl;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.websphere.sib.exception.SIIncorrectCallException;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.api.jmsra.JmsJcaSession;
import com.ibm.ws.sib.api.jmsra.impl.JmsJcaConnectionImpl;
import com.ibm.ws.sib.api.jmsra.impl.JmsJcaConnectionRequestInfo;
import com.ibm.ws.sib.api.jmsra.impl.JmsJcaManagedConnection;
import com.ibm.ws.sib.api.jmsra.impl.JmsJcaManagedConnectionFactoryImpl;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.SICoreConnection;
import com.ibm.wsspi.sib.core.SITransaction;
import com.ibm.wsspi.sib.core.SIUncoordinatedTransaction;
import com.ibm.wsspi.sib.core.exception.SIConnectionLostException;
import com.ibm.wsspi.sib.core.exception.SIRollbackException;
import jakarta.resource.ResourceException;
import jakarta.resource.spi.ConnectionManager;
import jakarta.resource.spi.ConnectionRequestInfo;
import jakarta.resource.spi.LazyAssociatableConnectionManager;
import jakarta.resource.spi.LocalTransactionException;
import jakarta.resource.spi.ManagedConnectionFactory;

final class JmsJcaSessionImpl
implements JmsJcaSession {
    private JmsJcaManagedConnection _managedConnection;
    private JmsJcaConnectionImpl _connection;
    private boolean _transacted;
    private SIUncoordinatedTransaction _applicationLocalTransaction;
    private final JmsJcaConnectionRequestInfo _requestInfo;
    private boolean _sessionClosed = false;
    private boolean _sessionInvalidated = false;
    private static TraceComponent TRACE = SibTr.register(JmsJcaSessionImpl.class, (String)"SIBJmsRa", (String)"com.ibm.ws.sib.api.jmsra.CWSJRMessages");
    private static TraceNLS NLS = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.api.jmsra.CWSJRMessages");
    private static final String CLASS_NAME = JmsJcaSessionImpl.class.getName();

    JmsJcaSessionImpl(JmsJcaManagedConnection managedConnection, JmsJcaConnectionRequestInfo requestInfo) {
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"JmsJcaSessionImpl", (Object)new Object[]{managedConnection, requestInfo});
        }
        this._managedConnection = managedConnection;
        this._requestInfo = requestInfo;
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"JmsJcaSessionImpl");
        }
    }

    JmsJcaSessionImpl() {
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"JmsJcaSessionImpl");
        }
        this._requestInfo = null;
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"JmsJcaSessionImpl");
        }
    }

    @Override
    public SICoreConnection getSICoreConnection() throws IllegalStateException {
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"getSICoreConnection");
        }
        if (this._sessionClosed) {
            throw new IllegalStateException(NLS.getFormattedMessage("ILLEGAL_STATE_CWSJR1123", new Object[]{"getSICoreConnection"}, null));
        }
        if (this._sessionInvalidated) {
            throw new IllegalStateException(NLS.getFormattedMessage("ILLEGAL_STATE_CWSJR1124", new Object[]{"getSICoreConnection"}, null));
        }
        SICoreConnection coreConnection = null;
        if (this._connection != null) {
            coreConnection = this._connection.getSICoreConnection();
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"getSICoreConnection", (Object)coreConnection);
        }
        return coreConnection;
    }

    @Override
    public SITransaction getCurrentTransaction() throws IllegalStateException, ResourceException, SIException, SIErrorException {
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"getCurrentTransaction");
        }
        if (this._sessionClosed) {
            throw new IllegalStateException(NLS.getFormattedMessage("ILLEGAL_STATE_CWSJR1130", new Object[]{"getCurrentTransaction"}, null));
        }
        if (this._sessionInvalidated) {
            throw new IllegalStateException(NLS.getFormattedMessage("ILLEGAL_STATE_CWSJR1134", new Object[]{"getCurrentTransaction"}, null));
        }
        SIUncoordinatedTransaction transaction = null;
        if (this._applicationLocalTransaction != null) {
            transaction = this._applicationLocalTransaction;
        } else if (!this._connection.getConnectionFactory().isManaged()) {
            if (this.getTransacted()) {
                transaction = this._applicationLocalTransaction = this._connection.getSICoreConnection().createUncoordinatedTransaction();
            }
        } else {
            transaction = this.getManagedConnection().getCurrentTransaction(this._connection.getConnectionManager());
            if (transaction == null && this.getTransacted()) {
                try {
                    this._applicationLocalTransaction = this._connection.getSICoreConnection().createUncoordinatedTransaction();
                }
                catch (SIException exception) {
                    FFDCFilter.processException((Throwable)exception, (String)(CLASS_NAME + ".getCurrentTransaction"), (String)"1:306:1.47", (Object)this);
                    if (TraceComponent.isAnyTracingEnabled() && TRACE.isEventEnabled()) {
                        SibTr.exception((Object)this, (TraceComponent)TRACE, (Exception)((Object)exception));
                    }
                    throw exception;
                }
                catch (SIErrorException exception) {
                    FFDCFilter.processException((Throwable)exception, (String)(CLASS_NAME + ".getCurrentTransaction"), (String)"1:315:1.47", (Object)this);
                    if (TraceComponent.isAnyTracingEnabled() && TRACE.isEventEnabled()) {
                        SibTr.exception((Object)this, (TraceComponent)TRACE, (Exception)((Object)exception));
                    }
                    throw exception;
                }
                this._managedConnection.localTransactionStarted();
                transaction = this._applicationLocalTransaction;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.exit((TraceComponent)TRACE, (String)"getCurrentTransaction", (Object)transaction);
        }
        return transaction;
    }

    @Override
    public boolean getTransacted() throws IllegalStateException {
        if (this._sessionClosed) {
            throw new IllegalStateException(NLS.getFormattedMessage("ILLEGAL_STATE_CWSJR1131", new Object[]{"getTransacted"}, null));
        }
        if (this._sessionInvalidated) {
            throw new IllegalStateException(NLS.getFormattedMessage("ILLEGAL_STATE_CWSJR1135", new Object[]{"getTransacted"}, null));
        }
        return this._transacted;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void commitLocalTransaction() throws IllegalStateException, LocalTransactionException, ResourceException, SIException, SIErrorException {
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"commitLocalTransaction");
        }
        if (this._sessionClosed) {
            throw new IllegalStateException(NLS.getFormattedMessage("ILLEGAL_STATE_CWSJR1132", new Object[]{"commitLocalTransaction"}, null));
        }
        if (this._sessionInvalidated) {
            throw new IllegalStateException(NLS.getFormattedMessage("ILLEGAL_STATE_CWSJR1136", new Object[]{"commitLocalTransaction"}, null));
        }
        if (!this.getTransacted()) {
            throw new LocalTransactionException(NLS.getFormattedMessage("ILLEGAL_STATE_CWSJR1125", new Object[]{"commitLocalTransaction"}, null));
        }
        if (this._applicationLocalTransaction == null) {
            SITransaction transaction;
            if (this._connection.getConnectionFactory().isManaged() && (transaction = this.getManagedConnection().getCurrentTransaction(this._connection.getConnectionManager())) != null) {
                if (!(transaction instanceof SIUncoordinatedTransaction)) throw new LocalTransactionException(NLS.getFormattedMessage("ILLEGAL_STATE_CWSJR1138", new Object[]{"commitLocalTransaction"}, null));
                if (TraceComponent.isAnyTracingEnabled() && TRACE.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)TRACE, (String)"_applicationLocalTransaction was null but current tran is local.  Committing local tran.");
                }
                ((SIUncoordinatedTransaction)transaction).commit();
            }
        } else {
            try {
                this._applicationLocalTransaction.commit();
            }
            catch (SIRollbackException rolledbackException) {
                if (this._connection.getConnectionFactory().isManaged()) {
                    this._managedConnection.localTransactionRolledBack();
                }
                this._applicationLocalTransaction = null;
                if (!TraceComponent.isAnyTracingEnabled() || !TRACE.isEventEnabled()) throw rolledbackException;
                SibTr.exception((Object)this, (TraceComponent)TRACE, (Exception)((Object)rolledbackException));
                throw rolledbackException;
            }
            catch (SIException exception) {
                FFDCFilter.processException((Throwable)exception, (String)(CLASS_NAME + ".commitLocalTranaction"), (String)"1:473:1.47", (Object)this);
                if (!TraceComponent.isAnyTracingEnabled() || !TRACE.isEventEnabled()) throw exception;
                SibTr.exception((Object)this, (TraceComponent)TRACE, (Exception)((Object)exception));
                throw exception;
            }
            catch (SIErrorException exception) {
                FFDCFilter.processException((Throwable)exception, (String)(CLASS_NAME + ".commitLocalTranaction"), (String)"1:482:1.47", (Object)this);
                if (!TraceComponent.isAnyTracingEnabled() || !TRACE.isEventEnabled()) throw exception;
                SibTr.exception((Object)this, (TraceComponent)TRACE, (Exception)((Object)exception));
                throw exception;
            }
            if (this._connection.getConnectionFactory().isManaged()) {
                this._managedConnection.localTransactionCommitted();
            }
            this._applicationLocalTransaction = null;
        }
        if (!TraceComponent.isAnyTracingEnabled() || !TRACE.isEntryEnabled()) return;
        SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"commitLocalTransaction");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void rollbackLocalTransaction() throws IllegalStateException, LocalTransactionException, ResourceException, SIException, SIErrorException {
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"rollbackLocalTransaction");
        }
        if (this._sessionClosed) {
            throw new IllegalStateException(NLS.getFormattedMessage("ILLEGAL_STATE_CWSJR1133", new Object[]{"rollbackLocalTransaction"}, null));
        }
        if (this._sessionInvalidated) {
            throw new IllegalStateException(NLS.getFormattedMessage("ILLEGAL_STATE_CWSJR1137", new Object[]{"rollbackLocalTransaction"}, null));
        }
        if (!this.getTransacted()) {
            throw new LocalTransactionException(NLS.getFormattedMessage("ILLEGAL_STATE_CWSJR1139", new Object[]{"rollbackLocalTransaction"}, null));
        }
        if (this._applicationLocalTransaction == null) {
            SITransaction transaction;
            if (this._connection.getConnectionFactory().isManaged() && (transaction = this.getManagedConnection().getCurrentTransaction(this._connection.getConnectionManager())) != null) {
                if (!(transaction instanceof SIUncoordinatedTransaction)) throw new LocalTransactionException(NLS.getFormattedMessage("ILLEGAL_STATE_CWSJR1140", new Object[]{"rollbackLocalTransaction"}, null));
                if (TraceComponent.isAnyTracingEnabled() && TRACE.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)TRACE, (String)"_applicationLocalTransaction was null but current tran is local.  Rolling back local tran.");
                }
                ((SIUncoordinatedTransaction)transaction).rollback();
            }
        } else {
            try {
                this._applicationLocalTransaction.rollback();
            }
            catch (SIException exception) {
                FFDCFilter.processException((Throwable)exception, (String)(CLASS_NAME + ".rollbackLocalTransaction"), (String)"1:589:1.47", (Object)this);
                if (!TraceComponent.isAnyTracingEnabled() || !TRACE.isEventEnabled()) throw exception;
                SibTr.exception((Object)this, (TraceComponent)TRACE, (Exception)((Object)exception));
                throw exception;
            }
            catch (SIErrorException exception) {
                FFDCFilter.processException((Throwable)exception, (String)(CLASS_NAME + ".rollbackLocalTransaction"), (String)"1:598:1.47", (Object)this);
                if (!TraceComponent.isAnyTracingEnabled() || !TRACE.isEventEnabled()) throw exception;
                SibTr.exception((Object)this, (TraceComponent)TRACE, (Exception)((Object)exception));
                throw exception;
            }
            if (this._connection.getConnectionFactory().isManaged()) {
                this._managedConnection.localTransactionRolledBack();
            }
            this._applicationLocalTransaction = null;
        }
        if (!TraceComponent.isAnyTracingEnabled() || !TRACE.isEntryEnabled()) return;
        SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"rollbackLocalTransaction");
    }

    @Override
    public void close() throws SIConnectionLostException, SIIncorrectCallException, SIResourceException, SIErrorException {
        this.close(true);
    }

    JmsJcaManagedConnection getManagedConnection() throws IllegalStateException {
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"getManagedConnection");
        }
        if (this._managedConnection == null) {
            ConnectionManager connectionManager = this._connection.getConnectionManager();
            if (connectionManager == null) {
                throw new IllegalStateException(NLS.getFormattedMessage("EXCEPTION_RECEIVED_CWSJR1126", new Object[]{"getManagedConnection"}, null));
            }
            if (connectionManager instanceof LazyAssociatableConnectionManager) {
                try {
                    JmsJcaManagedConnectionFactoryImpl managedConnectionFactory = this._connection.getConnectionFactory().getManagedConnectionFactory();
                    ((LazyAssociatableConnectionManager)connectionManager).associateConnection((Object)this, (ManagedConnectionFactory)managedConnectionFactory, (ConnectionRequestInfo)this._requestInfo);
                }
                catch (ResourceException exception) {
                    FFDCFilter.processException((Throwable)exception, (String)(CLASS_NAME + "getManagedConnection"), (String)"1:673:1.47", (Object)this);
                    SibTr.exception((Object)this, (TraceComponent)TRACE, (Exception)((Object)exception));
                    throw new IllegalStateException(NLS.getFormattedMessage("EXCEPTION_RECEIVED_CWSJR1121", new Object[]{"getManagedConnection", exception}, null), exception);
                }
            } else {
                throw new IllegalStateException(NLS.getFormattedMessage("EXCEPTION_RECEIVED_CWSJR1122", new Object[]{"getManagedConnection", connectionManager.getClass().getName(), LazyAssociatableConnectionManager.class.getName()}, null));
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"getManagedConnection", (Object)this._managedConnection);
        }
        return this._managedConnection;
    }

    void close(boolean removeFromConnection) throws SIConnectionLostException, SIIncorrectCallException, SIResourceException, SIErrorException {
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"close", (Object)removeFromConnection);
        }
        if (this._applicationLocalTransaction != null) {
            try {
                this._applicationLocalTransaction.rollback();
            }
            catch (SIIncorrectCallException e) {
                SibTr.debug((TraceComponent)TRACE, (String)("Caught a SIIncorrectCallException which means the operation has already been completed: " + (Object)((Object)e)));
            }
            if (this._connection.getConnectionFactory().isManaged()) {
                this._managedConnection.localTransactionRolledBack();
            }
            this._applicationLocalTransaction = null;
        }
        if (this._managedConnection != null) {
            this._managedConnection.sessionClosed(this);
        }
        if (removeFromConnection) {
            this._connection.removeSession(this);
        }
        this._sessionClosed = true;
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"close");
        }
    }

    void commitUnresolvedLocalTransaction() throws LocalTransactionException, SIRollbackException, SIConnectionLostException, SIIncorrectCallException, SIResourceException, SIErrorException {
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"commitUnresolvedLocalTransaction");
        }
        if (this._applicationLocalTransaction == null) {
            throw new LocalTransactionException(NLS.getFormattedMessage("ILLEGAL_STATE_CWSJR1141", new Object[]{"commitUnresolvedLocalTransaction"}, null));
        }
        this._applicationLocalTransaction.commit();
        this._applicationLocalTransaction = null;
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"commitUnresolvedLocalTransaction");
        }
    }

    void rollbackUnresolvedLocalTransaction() throws LocalTransactionException, SIConnectionLostException, SIIncorrectCallException, SIResourceException, SIErrorException {
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"rollbackUnresolvedLocalTransaction");
        }
        if (this._applicationLocalTransaction == null) {
            throw new LocalTransactionException(NLS.getFormattedMessage("ILLEGAL_STATE_CWSJR1142", new Object[]{"rollbackUnresolvedLocalTransaction"}, null));
        }
        this._applicationLocalTransaction.rollback();
        this._applicationLocalTransaction = null;
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"rollbackUnresolvedLocalTransaction");
        }
    }

    void dissociate() {
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"dissociate");
        }
        this._managedConnection = null;
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"dissociate");
        }
    }

    void associate(JmsJcaManagedConnection managedConnection) {
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"associate", (Object)managedConnection);
        }
        if (this._managedConnection != null) {
            this._managedConnection.disassociateSession(this);
        }
        this._managedConnection = managedConnection;
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"associate");
        }
    }

    JmsJcaConnectionImpl getConnection() {
        return this._connection;
    }

    void setTransacted(boolean transacted) {
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"setTransacted", (Object)transacted);
        }
        this._transacted = transacted;
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"setTransacted");
        }
    }

    void invalidate() {
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"invalidate");
        }
        this._sessionInvalidated = true;
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"invalidate");
        }
    }

    void setParentConnection(JmsJcaConnectionImpl connection) {
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"setParentConnection", (Object)connection);
        }
        this._connection = connection;
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"setParentConnection");
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("[");
        sb.append(this.getClass().getName());
        sb.append("@");
        sb.append(Integer.toHexString(System.identityHashCode(this)));
        sb.append(" <managedConnection=");
        sb.append(System.identityHashCode(this._managedConnection));
        sb.append("> <connection=");
        sb.append(System.identityHashCode(this._connection));
        sb.append("> <transacted=");
        sb.append(this._transacted);
        sb.append("> <applicationLocalTransaction=");
        sb.append(this._applicationLocalTransaction);
        sb.append("> <reqInfo=");
        sb.append(this._requestInfo);
        sb.append("> <sessionClosed=");
        sb.append(this._sessionClosed);
        sb.append("> <sessionInvalidated=");
        sb.append(this._sessionInvalidated);
        sb.append(">]");
        return sb.toString();
    }
}

