/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.msgstore.persistence;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.msgstore.Configuration;
import com.ibm.ws.sib.msgstore.SevereMessageStoreException;
import com.ibm.ws.sib.msgstore.impl.MessageStoreImpl;
import com.ibm.ws.sib.msgstore.persistence.PersistentMessageStore;
import com.ibm.ws.sib.msgstore.transactions.impl.XidManager;

public class PersistenceFactory {
    private PersistenceFactory() {
    }

    public static PersistentMessageStore getPersistentMessageStore(MessageStoreImpl msi, XidManager xidManager, Configuration configuration) throws SevereMessageStoreException {
        String pmsImplClassName = msi.getProperty("persistentMessageStoreClass", configuration.getPersistentMessageStoreClassname());
        if (pmsImplClassName == null) {
            pmsImplClassName = "com.ibm.ws.sib.msgstore.persistence.objectManager.PersistentMessageStoreImpl";
        }
        PersistentMessageStore persistentMessageStore = null;
        try {
            Class<?> clazz = Class.forName(pmsImplClassName);
            persistentMessageStore = (PersistentMessageStore)clazz.newInstance();
            persistentMessageStore.initialize(msi, xidManager, configuration);
        }
        catch (ClassNotFoundException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.msgstore.persistence.impl.PersistenceFactory.getPersistentMessageStore", (String)"1:72:1.15.1.1");
            throw new SevereMessageStoreException((Throwable)e);
        }
        catch (InstantiationException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.msgstore.persistence.impl.PersistenceFactory.getPersistentMessageStore", (String)"1:77:1.15.1.1");
            throw new SevereMessageStoreException((Throwable)e);
        }
        catch (IllegalAccessException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.msgstore.persistence.impl.PersistenceFactory.getPersistentMessageStore", (String)"1:82:1.15.1.1");
            throw new SevereMessageStoreException((Throwable)e);
        }
        return persistentMessageStore;
    }
}

