/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.mp.jwt.tai;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.security.jwt.JwtConsumer;
import com.ibm.websphere.security.jwt.JwtToken;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.common.structures.BoundedHashMap;
import com.ibm.ws.security.jwt.utils.JwtUtils;
import com.ibm.ws.security.mp.jwt.error.MpJwtProcessingException;
import com.ibm.ws.security.mp.jwt.impl.DefaultJsonWebTokenImpl;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import org.eclipse.microprofile.jwt.JsonWebToken;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class TAIJwtUtils {
    private static TraceComponent tc = Tr.register(TAIJwtUtils.class, (String)"MPJWT", (String)"com.ibm.ws.security.mp.jwt.resources.MicroProfileJwtMessages");
    public static final String TYPE_JWT_TOKEN = "Json Web Token";
    private static Map<String, Object> loggedOutJwts = Collections.synchronizedMap(new BoundedHashMap(5000));
    static final long serialVersionUID = 7931444202823318825L;

    @ManualTrace
    @FFDCIgnore(value={Exception.class})
    public JwtToken createJwt(@Sensitive String idToken, String jwtConfigId) throws MpJwtProcessingException {
        String methodName = "createJwt";
        if (tc.isDebugEnabled()) {
            Tr.entry((TraceComponent)tc, (String)methodName, (Object[])new Object[]{idToken, jwtConfigId});
        }
        try {
            JwtToken token = JwtConsumer.create((String)jwtConfigId).createJwt(idToken);
            if (tc.isDebugEnabled()) {
                Tr.exit((TraceComponent)tc, (String)methodName, (Object)token);
            }
            return token;
        }
        catch (Exception e) {
            String msg = Tr.formatMessage((TraceComponent)tc, (String)"ERROR_CREATING_JWT", (Object[])new Object[]{jwtConfigId, e.getLocalizedMessage()});
            if (JwtUtils.isJwtSsoValidationExpiredTokenCodePath()) {
                Tr.debug((TraceComponent)tc, (String)msg, (Object[])new Object[0]);
            } else {
                Tr.error((TraceComponent)tc, (String)msg, (Object[])new Object[0]);
            }
            throw new MpJwtProcessingException(msg, e);
        }
    }

    public static boolean isJwtPreviouslyLoggedOut(String rawToken) {
        if (loggedOutJwts.isEmpty()) {
            return false;
        }
        boolean result = loggedOutJwts.get(TAIJwtUtils.getSha256Digest(rawToken)) != null;
        return result;
    }

    public static void addLoggedOutJwtToList(String rawToken) {
        String digestedJwt = TAIJwtUtils.getSha256Digest(rawToken);
        if (digestedJwt != null) {
            loggedOutJwts.put(digestedJwt, Boolean.TRUE);
        }
    }

    private static String getSha256Digest(String in) {
        MessageDigest md = null;
        try {
            md = MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            FFDCFilter.processException((Throwable)noSuchAlgorithmException, (String)"com.ibm.ws.security.mp.jwt.tai.TAIJwtUtils", (String)"91", null, (Object[])new Object[]{in});
            return null;
        }
        byte[] digest = md.digest(in.getBytes(StandardCharsets.UTF_8));
        return new String(digest);
    }

    @Sensitive
    @ManualTrace
    public JsonWebToken createJwtPrincipal(String username, ArrayList<String> groups, @Sensitive JwtToken jwtToken) {
        String methodName = "createJwtPrincipal";
        if (tc.isDebugEnabled()) {
            Tr.entry((TraceComponent)tc, (String)methodName, (Object[])new Object[]{username, groups, jwtToken});
        }
        String compact = null;
        String type = TYPE_JWT_TOKEN;
        if (jwtToken != null) {
            compact = jwtToken.compact();
            type = (String)jwtToken.getClaims().get((Object)"token_type");
        }
        DefaultJsonWebTokenImpl token = new DefaultJsonWebTokenImpl(compact, type, username, jwtToken);
        if (tc.isDebugEnabled()) {
            Tr.exit((TraceComponent)tc, (String)methodName, (Object)token);
        }
        return token;
    }
}

