/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.concurrent.internal.cdi.interceptor;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import jakarta.enterprise.concurrent.CronTrigger;
import jakarta.enterprise.concurrent.Schedule;
import java.time.DayOfWeek;
import java.time.Month;
import java.time.ZoneId;
import java.time.ZonedDateTime;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
class ScheduleCronTrigger
extends CronTrigger {
    private static final TraceComponent tc = Tr.register(ScheduleCronTrigger.class, (String)"concurrent", (String)"io.openliberty.concurrent.internal.cdi.resources.CWWKCMessages");
    private static final Month[] ALL_MONTHS = Month.values();
    private static final int[] ALL_DAYS_OF_MONTH = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31};
    private static final DayOfWeek[] ALL_DAYS_OF_WEEK = new DayOfWeek[]{DayOfWeek.SUNDAY, DayOfWeek.MONDAY, DayOfWeek.TUESDAY, DayOfWeek.WEDNESDAY, DayOfWeek.THURSDAY, DayOfWeek.FRIDAY, DayOfWeek.SATURDAY};
    private static final int[] ALL_HOURS = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23};
    private static final int[] ALL_MINUTES = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59};
    static final long serialVersionUID = 5026894688487540468L;

    @Trivial
    private ScheduleCronTrigger(String cron, ZoneId zoneId) {
        super(cron, zoneId);
    }

    @Trivial
    private ScheduleCronTrigger(ZoneId zoneId) {
        super(zoneId);
    }

    @Trivial
    static ScheduleCronTrigger create(Schedule schedule) {
        ScheduleCronTrigger trigger;
        String zone = schedule.zone();
        ZoneId zoneId = zone.length() == 0 ? ZoneId.systemDefault() : ZoneId.of(zone);
        String cron = schedule.cron();
        if (cron.length() > 0) {
            trigger = new ScheduleCronTrigger(cron, zoneId);
        } else {
            int[] seconds;
            int[] minutes;
            int[] hours;
            DayOfWeek[] daysOfWeek;
            int[] daysOfMonth;
            trigger = new ScheduleCronTrigger(zoneId);
            Month[] months = schedule.months();
            if (months.length == 0) {
                months = ALL_MONTHS;
            }
            if ((daysOfMonth = schedule.daysOfMonth()).length == 0) {
                daysOfMonth = ALL_DAYS_OF_MONTH;
            }
            if ((daysOfWeek = schedule.daysOfWeek()).length == 0) {
                daysOfWeek = ALL_DAYS_OF_WEEK;
            }
            if ((hours = schedule.hours()).length == 0) {
                hours = ALL_HOURS;
            }
            if ((minutes = schedule.minutes()).length == 0) {
                minutes = ALL_MINUTES;
            }
            if ((seconds = schedule.seconds()).length == 0) {
                throw new IllegalArgumentException(Tr.formatMessage((TraceComponent)tc, (String)"CWWKC1410.schedule.lacks.seconds", (Object[])new Object[]{schedule}));
            }
            trigger.months(months).daysOfMonth(daysOfMonth).daysOfWeek(daysOfWeek).hours(hours).minutes(minutes).seconds(seconds);
        }
        return trigger;
    }

    protected ZonedDateTime next(ZonedDateTime now) {
        return super.next(now);
    }

    @Trivial
    public String toString() {
        return "Schedule" + super.toString();
    }
}

