/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.security.oidcclientcore.authentication;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import org.apache.http.NameValuePair;
import org.apache.http.message.BasicNameValuePair;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class AuthorizationRequestParameters {
    private static final TraceComponent tc = Tr.register(AuthorizationRequestParameters.class, (String)"OpenIdConnect", (String)"io.openliberty.security.oidcclientcore.internal.resources.OidcClientCoreMessages");
    public static final String SCOPE = "scope";
    public static final String RESPONSE_TYPE = "response_type";
    public static final String CLIEND_ID = "client_id";
    public static final String REDIRECT_URI = "redirect_uri";
    public static final String STATE = "state";
    public static final String RESPONSE_MODE = "response_mode";
    public static final String NONCE = "nonce";
    public static final String PROMPT = "prompt";
    public static final String ACR_VALUES = "acr_values";
    public static final String DISPLAY = "display";
    private final String authorizationEndpointUrl;
    private final String scope;
    private final String responseType;
    private final String clientId;
    private final String redirectUri;
    private final String state;
    private final List<NameValuePair> conditionalParameters = new ArrayList<NameValuePair>();
    static final long serialVersionUID = -5128374506923528278L;

    public AuthorizationRequestParameters(String authorizationEndpointUrl, String scope, String responseType, String clientId, String redirectUri, String state) {
        this.authorizationEndpointUrl = authorizationEndpointUrl;
        this.scope = scope;
        this.responseType = responseType;
        this.clientId = clientId;
        this.redirectUri = redirectUri;
        this.state = state;
    }

    public void addParameter(String name, String value) {
        if (name == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Cannot add parameter because name is null", (Object[])new Object[0]);
            }
            return;
        }
        this.conditionalParameters.add((NameValuePair)new BasicNameValuePair(name, value));
    }

    public String buildRequestUrl() {
        String queryString = this.buildRequestQueryString();
        String queryMark = "?";
        if (this.authorizationEndpointUrl.indexOf("?") > 0) {
            queryMark = "&";
        }
        return this.authorizationEndpointUrl + queryMark + queryString;
    }

    String buildRequestQueryString() {
        String query = this.buildQueryWithRequiredParameters();
        query = this.appendConditionalParametersToQuery(query);
        return query;
    }

    String buildQueryWithRequiredParameters() {
        String query = "";
        query = this.appendParameterToQuery(query, SCOPE, this.scope);
        query = this.appendParameterToQuery(query, RESPONSE_TYPE, this.responseType);
        query = this.appendParameterToQuery(query, CLIEND_ID, this.clientId);
        query = this.appendParameterToQuery(query, REDIRECT_URI, this.redirectUri);
        query = this.appendParameterToQuery(query, STATE, this.state);
        return query;
    }

    String appendConditionalParametersToQuery(String query) {
        for (NameValuePair conditionalParameter : this.conditionalParameters) {
            query = this.appendParameterToQuery(query, conditionalParameter.getName(), conditionalParameter.getValue());
        }
        return query;
    }

    String appendParameterToQuery(String query, String parameterName, String parameterValue) {
        if (parameterName == null) {
            return query;
        }
        try {
            if (query == null) {
                query = "";
            }
            if (!query.isEmpty()) {
                query = query + "&";
            }
            query = query + URLEncoder.encode(parameterName, "UTF-8");
            if (parameterValue != null) {
                query = query + "=" + URLEncoder.encode(parameterValue, "UTF-8");
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            FFDCFilter.processException((Throwable)unsupportedEncodingException, (String)"io.openliberty.security.oidcclientcore.authentication.AuthorizationRequestParameters", (String)"116", (Object)this, (Object[])new Object[]{query, parameterName, parameterValue});
        }
        return query;
    }
}

