/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.tcpchannel.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCSelfIntrospectable;
import com.ibm.ws.kernel.security.thread.ThreadIdentityManager;
import com.ibm.ws.tcpchannel.internal.TCPBaseRequestContext;
import com.ibm.ws.tcpchannel.internal.TCPChannel;
import com.ibm.ws.tcpchannel.internal.TCPChannelConfiguration;
import com.ibm.ws.tcpchannel.internal.TCPConnLink;
import com.ibm.ws.tcpchannel.internal.TCPReadRequestContextImpl;
import com.ibm.wsspi.bytebuffer.WsByteBuffer;
import com.ibm.wsspi.channelfw.ChannelFrameworkFactory;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.LinkedList;
import java.util.List;

public abstract class SocketIOChannel
implements FFDCSelfIntrospectable {
    private static final TraceComponent tc = Tr.register(SocketIOChannel.class, (String)"TCPChannel", (String)"com.ibm.ws.tcpchannel.internal.resources.TCPChannelMessages");
    protected Socket socket;
    protected SocketChannel channel = null;
    protected boolean closed = false;
    protected boolean processClose = true;
    protected TCPChannel tcpChannel = null;
    protected TCPChannelConfiguration cc = null;
    protected boolean checkCancel = false;

    protected SocketIOChannel(Socket socket, TCPChannel _tcpChannel) {
        this.socket = socket;
        this.tcpChannel = _tcpChannel;
        this.cc = _tcpChannel.getConfig();
        this.tcpChannel.incrementConnectionCount();
        this.channel = socket.getChannel();
    }

    protected boolean connect(InetSocketAddress address) throws IOException {
        this.channel.configureBlocking(false);
        Object token = ThreadIdentityManager.runAsServer();
        PrivConnect attempt = new PrivConnect(this.channel, address);
        try {
            boolean bl = AccessController.doPrivileged(attempt);
            return bl;
        }
        catch (PrivilegedActionException pae) {
            Throwable t = pae.getCause();
            if (!(t instanceof IOException)) {
                throw new IOException("Failed to connect. remote= " + address + " ", t);
            }
            throw (IOException)t;
        }
        finally {
            ThreadIdentityManager.reset((Object)token);
        }
    }

    protected IOResult attemptReadFromSocket(TCPBaseRequestContext readReq, boolean fromSelector) throws IOException {
        IOResult rc = IOResult.NOT_COMPLETE;
        TCPReadRequestContextImpl req = (TCPReadRequestContextImpl)readReq;
        TCPConnLink conn = req.getTCPConnLink();
        long dataRead = 0L;
        if (req.getJITAllocateSize() > 0 && req.getBuffers() == null) {
            if (conn.getConfig().getAllocateBuffersDirect()) {
                req.setBuffer(ChannelFrameworkFactory.getBufferManager().allocateDirect(req.getJITAllocateSize()));
            } else {
                req.setBuffer(ChannelFrameworkFactory.getBufferManager().allocate(req.getJITAllocateSize()));
            }
            req.setJITAllocateAction(true);
        }
        WsByteBuffer[] wsBuffArray = req.getBuffers();
        dataRead = this.attemptReadFromSocketUsingNIO(req, wsBuffArray);
        req.setLastIOAmt(dataRead);
        req.setIODoneAmount(req.getIODoneAmount() + dataRead);
        if (req.getIODoneAmount() >= req.getIOAmount()) {
            rc = IOResult.COMPLETE;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((Object)this, (TraceComponent)tc, (String)("Read " + dataRead + "(" + req.getIODoneAmount() + ") bytes, " + req.getIOAmount() + " requested on local: " + this.getSocket().getLocalSocketAddress() + " remote: " + this.getSocket().getRemoteSocketAddress()), (Object[])new Object[0]);
        }
        if (req.getLastIOAmt() < 0L) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled() && !conn.getConfig().isInbound()) {
                Tr.event((Object)this, (TraceComponent)tc, (String)"Empty read on outbound.", (Object[])new Object[0]);
            }
            if (req.getJITAllocateAction()) {
                req.getBuffer().release();
                req.setBuffer(null);
                req.setJITAllocateAction(false);
            }
            return IOResult.FAILED;
        }
        if (rc == IOResult.COMPLETE) {
            req.setIOCompleteAmount(req.getIODoneAmount());
            req.setIODoneAmount(0L);
        } else if (rc == IOResult.NOT_COMPLETE && !fromSelector && req.getJITAllocateAction() && req.getLastIOAmt() == 0L) {
            req.getBuffer().release();
            req.setBuffers(null);
            req.setJITAllocateAction(true);
        }
        return rc;
    }

    protected long attemptReadFromSocketUsingNIO(TCPReadRequestContextImpl req, WsByteBuffer[] wsBuffArray) throws IOException {
        throw new IOException("attemptReadFromSocketUsingNIO not overridden");
    }

    protected IOResult attemptWriteToSocket(TCPBaseRequestContext req) throws IOException {
        IOResult rc = IOResult.NOT_COMPLETE;
        WsByteBuffer[] wsBuffArray = req.getBuffers();
        long bytesWritten = this.attemptWriteToSocketUsingNIO(req, wsBuffArray);
        req.setLastIOAmt(bytesWritten);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((Object)this, (TraceComponent)tc, (String)("Wrote " + bytesWritten + " bytes, " + req.getIOAmount() + " requested on local: " + this.getSocket().getLocalSocketAddress() + " remote: " + this.getSocket().getRemoteSocketAddress()), (Object[])new Object[0]);
        }
        if (bytesWritten < 0L) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled() && !req.getTCPConnLink().getConfig().isInbound()) {
                Tr.event((Object)this, (TraceComponent)tc, (String)"invalid value returned for bytes written", (Object[])new Object[0]);
            }
            return IOResult.FAILED;
        }
        if (req.getIOAmount() == -1L) {
            ByteBuffer[] buffers = req.getByteBufferArray();
            rc = IOResult.COMPLETE;
            for (int i = 0; i < buffers.length; ++i) {
                if (!buffers[i].hasRemaining()) continue;
                rc = IOResult.NOT_COMPLETE;
                break;
            }
            req.setIODoneAmount(req.getIODoneAmount() + bytesWritten);
        } else {
            req.setIODoneAmount(req.getIODoneAmount() + bytesWritten);
            if (req.getIODoneAmount() >= req.getIOAmount()) {
                rc = IOResult.COMPLETE;
            }
        }
        if (rc == IOResult.COMPLETE) {
            req.setIOCompleteAmount(req.getIODoneAmount());
            req.setIODoneAmount(0L);
        }
        return rc;
    }

    protected long attemptWriteToSocketUsingNIO(TCPBaseRequestContext req, WsByteBuffer[] wsBuffArray) throws IOException {
        throw new IOException("attemptWriteToSocketUsingNIO not overridden");
    }

    public void close() {
    }

    public Socket getSocket() {
        return this.socket;
    }

    protected SocketChannel getChannel() {
        return this.channel;
    }

    protected void connectActions() throws IOException {
    }

    public List<String> introspect() {
        LinkedList<String> rc = new LinkedList<String>();
        String prefix = this.getClass().getSimpleName() + "@" + this.hashCode() + ": ";
        rc.add(prefix + "closed=" + this.closed);
        rc.add(prefix + "processClose=" + this.processClose);
        rc.add(prefix + "checkCancel=" + this.checkCancel);
        rc.add(prefix + "tcpChannel=" + this.tcpChannel);
        rc.add(prefix + "socket=" + this.socket);
        if (null != this.socket) {
            rc.add(prefix + "remoteAddr=" + this.socket.getInetAddress());
            rc.add(prefix + "remotePort=" + this.socket.getPort());
            rc.add(prefix + "localAddr=" + this.socket.getLocalAddress());
            rc.add(prefix + "localPort=" + this.socket.getLocalPort());
        }
        rc.add(prefix + "channel=" + this.channel);
        return rc;
    }

    public String[] introspectSelf() {
        List<String> rc = this.introspect();
        return rc.toArray(new String[rc.size()]);
    }

    private static class PrivConnect
    implements PrivilegedExceptionAction<Boolean> {
        private final SocketChannel ioSocket;
        private final InetSocketAddress address;

        public PrivConnect(SocketChannel _ioSocket, InetSocketAddress _address) {
            this.ioSocket = _ioSocket;
            this.address = _address;
        }

        @Override
        public Boolean run() throws IOException {
            return this.ioSocket.connect(this.address);
        }
    }

    protected static enum IOResult {
        COMPLETE,
        NOT_COMPLETE,
        FAILED;

    }
}

