/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.msgstore.list;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.sib.msgstore.AbstractItem;
import com.ibm.ws.sib.msgstore.Filter;
import com.ibm.ws.sib.msgstore.MessageStoreException;
import com.ibm.ws.sib.msgstore.SevereMessageStoreException;
import com.ibm.ws.sib.msgstore.cache.links.AbstractItemLink;
import com.ibm.ws.sib.msgstore.list.Link;
import com.ibm.ws.sib.msgstore.list.LinkedList;
import com.ibm.ws.sib.msgstore.list.PrioritizedCursor;
import com.ibm.ws.sib.msgstore.list.ReadWriteLock;
import com.ibm.ws.sib.msgstore.transactions.impl.PersistentTransaction;
import com.ibm.ws.sib.utils.ras.FormattedWriter;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.io.IOException;

public final class PrioritizedList {
    private static TraceComponent tc = SibTr.register(PrioritizedList.class, (String)"SIBMessageStore", (String)"com.ibm.ws.sib.msgstore.CWSISMessages");
    private PrioritizedCursor _firstCursor = null;
    private ReadWriteLock _cursorLock = new ReadWriteLock();
    private final LinkedList[] _prioritySublists = new LinkedList[10];

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void _removeCursor(PrioritizedCursor removeCursor) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"_removeCursor", (Object)removeCursor);
        }
        boolean locked = false;
        try {
            this._cursorLock.lockExclusive();
            locked = true;
            PrioritizedCursor prev = removeCursor.getPreviousCursor();
            PrioritizedCursor next = removeCursor.getNextCursor();
            if (prev != null) {
                prev.setNextCursor(next);
                removeCursor.setPreviousCursor(null);
            }
            if (next != null) {
                next.setPreviousCursor(prev);
                removeCursor.setNextCursor(null);
            }
            if (this._firstCursor == removeCursor) {
                this._firstCursor = next;
            }
        }
        finally {
            if (locked) {
                this._cursorLock.unlockExclusive();
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"_removeCursor");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public final void append(AbstractItemLink link) {
        int priority = link.getPriority();
        LinkedList tl = this._prioritySublists[priority];
        if (null == tl) {
            LinkedList[] linkedListArray = this._prioritySublists;
            // MONITORENTER : this._prioritySublists
            tl = this._prioritySublists[priority];
            if (null == tl) {
                this._prioritySublists[priority] = tl = new LinkedList();
            }
            // MONITOREXIT : linkedListArray
        }
        tl.append(link);
    }

    public final AbstractItem findFirstMatching(Filter filter) throws MessageStoreException {
        AbstractItem item = null;
        for (int priority = 9; null == item && priority >= 0; --priority) {
            LinkedList tl = this._prioritySublists[priority];
            if (null == tl) continue;
            item = tl.findFirstMatching(filter);
        }
        return item;
    }

    public final AbstractItem findOldestItem() throws MessageStoreException {
        AbstractItem item = null;
        AbstractItemLink oldestLink = null;
        long oldestPositionSoFar = Long.MAX_VALUE;
        for (int priority = 0; priority <= 9; ++priority) {
            long pos;
            AbstractItemLink link;
            LinkedList list = this._prioritySublists[priority];
            if (null == list || null == (link = (AbstractItemLink)list.getHead()) || (pos = link.getPosition()) >= oldestPositionSoFar) continue;
            oldestPositionSoFar = pos;
            oldestLink = link;
        }
        if (null != oldestLink) {
            item = oldestLink.getItem();
        }
        return item;
    }

    public final LinkedList getPrioritySublist(int priority) {
        return this._prioritySublists[priority];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void linkAvailable(AbstractItemLink link) throws SevereMessageStoreException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"linkReavailable", (Object)link);
        }
        boolean locked = false;
        try {
            this._cursorLock.lock();
            locked = true;
            for (PrioritizedCursor cursor = this._firstCursor; null != cursor; cursor = cursor.getNextCursor()) {
                cursor.linkAvailable(link);
            }
        }
        finally {
            if (locked) {
                this._cursorLock.unlock();
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"linkReavailable");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final PrioritizedCursor newCursor(Filter itemFilter, long lockID, boolean jumpbackEnabled) {
        PrioritizedCursor cursor = new PrioritizedCursor(this, itemFilter, lockID, jumpbackEnabled);
        boolean locked = false;
        try {
            this._cursorLock.lockExclusive();
            locked = true;
            if (this._firstCursor != null) {
                this._firstCursor.setPreviousCursor(cursor);
                cursor.setNextCursor(this._firstCursor);
            }
            this._firstCursor = cursor;
        }
        finally {
            if (locked) {
                this._cursorLock.unlockExclusive();
            }
        }
        return cursor;
    }

    public final AbstractItem removeFirstMatching(Filter filter, PersistentTransaction transaction) throws MessageStoreException {
        AbstractItem found = null;
        for (int priority = 9; null == found && priority >= 0; --priority) {
            LinkedList tl = this._prioritySublists[priority];
            if (null == tl || null == (found = tl.removeFirstMatching(filter, transaction)) || !TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
            SibTr.debug((Object)this, (TraceComponent)tc, (String)("found item: " + found));
        }
        return found;
    }

    public final boolean xmlHasChildren() {
        for (int priority = 0; priority <= 9; ++priority) {
            if (null == this._prioritySublists[priority]) continue;
            return true;
        }
        return false;
    }

    public final void xmlWriteChildrenOn(FormattedWriter writer, String tagName) throws IOException {
        writer.newLine();
        writer.write("<");
        writer.write(tagName);
        writer.write(">");
        writer.indent();
        if (null != this._firstCursor) {
            writer.newLine();
            writer.write("<cursors>");
            writer.indent();
            for (PrioritizedCursor cursor = this._firstCursor; null != cursor; cursor = cursor.getNextCursor()) {
                writer.newLine();
                cursor.xmlWriteOn(writer);
            }
            writer.outdent();
            writer.newLine();
            writer.write("</cursors>");
        }
        writer.newLine();
        writer.write("<children>");
        writer.indent();
        for (int priority = 9; priority >= 0; --priority) {
            if (null == this._prioritySublists[priority]) continue;
            for (Link link = this._prioritySublists[priority].getDummyHead(); null != link; link = link.getNextPhysicalLink()) {
                writer.newLine();
                link.xmlWriteOn(writer);
            }
        }
        writer.outdent();
        writer.newLine();
        writer.write("</children>");
        writer.outdent();
        writer.newLine();
        writer.write("</");
        writer.write(tagName);
        writer.write(">");
    }
}

