/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.api.jms.impl;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.sib.api.jms.impl.MsgDestEncodingUtilsImpl;
import com.ibm.ws.sib.api.jms.impl.ShortStringPropertyCoder;
import com.ibm.ws.sib.utils.ras.SibTr;
import jakarta.jms.JMSException;
import java.io.ByteArrayOutputStream;

class OnOffPropertyCoder
extends ShortStringPropertyCoder {
    private static TraceComponent tc = SibTr.register(OnOffPropertyCoder.class, (String)"SIBJms_Internal", (String)"com.ibm.websphere.sib.api.jms.CWSIAJMSMessages");

    OnOffPropertyCoder(String longName, String shortName) {
        super(longName, shortName);
    }

    @Override
    void encodeProperty(ByteArrayOutputStream baos, Object value) throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"encodeProperty", (Object)new Object[]{baos, value});
        }
        if (value.equals("On")) {
            super.encodeProperty(baos, "N");
        } else {
            super.encodeProperty(baos, "F");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"encodeProperty");
        }
    }

    @Override
    Object decodeProperty(MsgDestEncodingUtilsImpl.PropertyInputStream stream) throws JMSException {
        Object value;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"decodeProperty", (Object)stream);
        }
        value = "N".equals(value = super.decodeProperty(stream)) ? "On" : "Off";
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"decodeProperty", (Object)value);
        }
        return value;
    }
}

