/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.servlet;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.container.BaseConfiguration;
import com.ibm.wsspi.webcontainer.facade.ServletContextFacade;
import com.ibm.wsspi.webcontainer.logging.LoggerFactory;
import com.ibm.wsspi.webcontainer.servlet.IServletContext;
import jakarta.servlet.Registration;
import jakarta.servlet.ServletContext;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class TargetConfig
extends BaseConfiguration
implements Registration.Dynamic {
    protected static Logger logger = LoggerFactory.getInstance().getLogger("com.ibm.ws.webcontainer.servlet");
    private static final String CLASS_NAME = "com.ibm.ws.webcontainer.servlet.TargetConfig";
    protected Map<String, String> initParams = null;
    protected String fileName;
    private String displayName;
    protected String name;
    protected String description;
    protected String smallIcon;
    protected String largeIcon;
    protected IServletContext context;
    private String className;
    private boolean asyncSupported;

    public boolean isAsyncSupported() {
        if (!this.asyncSupported && this.initParams != null && this.initParams.containsKey("com.ibm.ws.webcontainer.async-supported")) {
            this.asyncSupported = Boolean.valueOf(this.initParams.get("com.ibm.ws.webcontainer.async-supported"));
        }
        return this.asyncSupported;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public TargetConfig(String id) {
        super(id);
    }

    public void addInitParameter(String name, String value) {
        if (this.initParams == null) {
            this.initParams = new HashMap<String, String>();
        }
        this.initParams.put(name, value);
    }

    public String getInitParameter(String name) {
        if (this.initParams == null) {
            return null;
        }
        return this.initParams.get(name);
    }

    public String getFileName() {
        return this.fileName;
    }

    public Map<String, String> getInitParams() {
        return this.initParams;
    }

    public void setInitParams(Map params) {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "setInitParams", "params->" + params);
        }
        if (this.initParams == null) {
            this.initParams = new HashMap<String, String>();
        }
        this.initParams.putAll(params);
    }

    public Map<String, String> getInitParameters() {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.entering(CLASS_NAME, "getInitParameters");
        }
        if (this.initParams == null) {
            this.initParams = new HashMap<String, String>();
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.exiting(CLASS_NAME, "getInitParameters");
        }
        return Collections.unmodifiableMap(this.initParams);
    }

    public Set<String> setInitParameters(Map<String, String> params) {
        if (this.context.isInitialized()) {
            throw new IllegalStateException();
        }
        if (this.initParams == null) {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "setInitParameters", "no existing init params, so putAll");
            }
            this.initParams = new HashMap<String, String>();
            this.initParams.putAll(params);
            return Collections.EMPTY_SET;
        }
        Set<Map.Entry<String, String>> entrySet = params.entrySet();
        HashSet<String> conflictSet = null;
        boolean foundConflict = false;
        for (Map.Entry<String, String> entry : entrySet) {
            String key = entry.getKey();
            String value = entry.getValue();
            if (key == null || value == null) {
                throw new IllegalArgumentException();
            }
            if (this.initParams.containsKey(key)) {
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                    logger.logp(Level.FINE, CLASS_NAME, "setInitParameters", "found existing param for key->[" + key + "]");
                }
                if (conflictSet == null) {
                    conflictSet = new HashSet<String>();
                }
                conflictSet.add(key);
                foundConflict = true;
                continue;
            }
            if (!TraceComponent.isAnyTracingEnabled() || !logger.isLoggable(Level.FINE)) continue;
            logger.logp(Level.FINE, CLASS_NAME, "setInitParameters", "no existing param for key->[" + key + "]");
        }
        if (!foundConflict) {
            this.initParams.putAll(params);
            return Collections.EMPTY_SET;
        }
        return conflictSet;
    }

    public boolean setInitParameter(String key, String value) throws IllegalStateException, IllegalArgumentException {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "setInitParameter", "key->[" + key + "] value->[" + value + "]");
        }
        if (this.context.isInitialized()) {
            throw new IllegalStateException();
        }
        if (key == null || value == null) {
            throw new IllegalArgumentException();
        }
        if (this.initParams == null) {
            this.initParams = new HashMap<String, String>();
            this.initParams.put(key, value);
            return true;
        }
        if (this.initParams.containsKey(key)) {
            return false;
        }
        this.initParams.put(key, value);
        return true;
    }

    public Properties getParamsAsProperties() {
        Properties p = new Properties();
        if (this.initParams != null) {
            p.putAll(this.initParams);
        }
        return p;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getName() {
        return this.name;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getLargeIcon() {
        return this.largeIcon;
    }

    public String getSmallIcon() {
        return this.smallIcon;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setLargeIcon(String largeIcon) {
        this.largeIcon = largeIcon;
    }

    public void setSmallIcon(String smallIcon) {
        this.smallIcon = smallIcon;
    }

    public void setIServletContext(IServletContext iServletContext) {
        this.context = iServletContext;
    }

    public void setServletContext(ServletContext webApp) {
        if (webApp instanceof ServletContextFacade) {
            this.setIServletContext((ServletContextFacade)webApp);
        } else if (webApp instanceof IServletContext) {
            this.setIServletContext((ServletContextFacade)((IServletContext)webApp).getFacade());
        } else {
            throw new IllegalStateException("webApp is not a servletContextFacade or WebApp");
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "setServletContext", "set context to->[" + this.context + "] for->[" + this.hashCode() + "]");
        }
    }

    public ServletContext getServletContext() {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "getServletContext", "returning->[" + this.context + "] for->[" + this.hashCode() + "]");
        }
        return this.context;
    }

    public IServletContext getIServletContext() {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "getIServletContext", "returning->[" + this.context + "] for->[" + this.hashCode() + "]");
        }
        return this.context;
    }

    public void setAsyncSupported(boolean isAsyncSupported) throws IllegalStateException {
        this.asyncSupported = isAsyncSupported;
    }

    public String toString() {
        StringBuilder strBuilder = new StringBuilder();
        strBuilder.append("getInitParameters->");
        Map<String, String> initParameters = this.getInitParameters();
        if (initParameters == null || initParameters.isEmpty()) {
            strBuilder.append("null or empty init parameters");
        } else {
            for (Map.Entry<String, String> initParamEntry : initParameters.entrySet()) {
                strBuilder.append("(" + initParamEntry.getKey() + "," + initParamEntry.getValue() + ")");
            }
            strBuilder.append('\n');
            for (Map.Entry<String, String> initParamEntry : initParameters.entrySet()) {
                strBuilder.append("getInitParameter(" + initParamEntry.getKey() + "," + this.getInitParameter(initParamEntry.getKey()) + ")");
                strBuilder.append('\n');
            }
        }
        strBuilder.append("isAsyncSupported->" + this.isAsyncSupported() + "\n");
        strBuilder.append("getDescription->" + this.getDescription() + "\n");
        return strBuilder.toString();
    }
}

