/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.artifact.zip.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.kernel.security.thread.ThreadIdentityManager;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.UndeclaredThrowableException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.function.Function;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class FileUtils {
    private static final Function<File, Boolean> isFileAction;
    private static final Function<File, Boolean> isDirectoryAction;
    private static final Function<File, Boolean> existsAction;
    private static final Function<File, Long> lengthAction;
    private static final Function<File, File[]> listFilesAction;
    private static final Function<File, String[]> listAction;
    private static final Function<File, Long> lastModifiedAction;
    private static final Function<File, Boolean> canReadAction;
    private static final Function<File, Boolean> canWriteAction;
    private static final Function<File, Boolean> deleteAction;
    private static final Function<File, Boolean> ensureDirExistsAction;
    static final long serialVersionUID = -1257700739430724575L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <R> R fileAction(final File target, final Function<File, R> function) {
        Object token = ThreadIdentityManager.runAsServer();
        try {
            Object t = AccessController.doPrivileged(new PrivilegedAction<R>(){
                static final long serialVersionUID = -5261081116740073978L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public R run() {
                    return function.apply(target);
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"com.ibm.ws.artifact.zip.internal.FileUtils$1", 1.class, (String)"archive.artifact.zip", (String)"com.ibm.ws.artifact.zip.internal.resources.ZipArtifactMessages");
                }
            });
            return (R)t;
        }
        finally {
            ThreadIdentityManager.reset((Object)token);
        }
    }

    public static boolean fileIsFile(File target) {
        return FileUtils.fileAction(target, isFileAction);
    }

    public static boolean fileIsDirectory(File target) {
        return FileUtils.fileAction(target, isDirectoryAction);
    }

    public static boolean fileExists(File target) {
        return FileUtils.fileAction(target, existsAction);
    }

    public static long fileLength(File target) {
        return FileUtils.fileAction(target, lengthAction);
    }

    public static File[] listFiles(File target) {
        return FileUtils.fileAction(target, listFilesAction);
    }

    public static String[] list(File target) {
        return FileUtils.fileAction(target, listAction);
    }

    /*
     * WARNING - void declaration
     */
    public static InputStream getInputStream(final File target) throws FileNotFoundException {
        Object token = ThreadIdentityManager.runAsServer();
        try {
            InputStream inputStream = AccessController.doPrivileged(new PrivilegedExceptionAction<InputStream>(){
                static final long serialVersionUID = -2811197513033285035L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public InputStream run() throws FileNotFoundException {
                    return new FileInputStream(target);
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"com.ibm.ws.artifact.zip.internal.FileUtils$8", 8.class, (String)"archive.artifact.zip", (String)"com.ibm.ws.artifact.zip.internal.resources.ZipArtifactMessages");
                }
            });
            return inputStream;
        }
        catch (PrivilegedActionException privilegedActionException) {
            void e;
            FFDCFilter.processException((Throwable)privilegedActionException, (String)"com.ibm.ws.artifact.zip.internal.FileUtils", (String)"125", null, (Object[])new Object[]{target});
            Exception e2 = e.getException();
            if (e2 instanceof FileNotFoundException) {
                throw (FileNotFoundException)e2;
            }
            if (e2 instanceof RuntimeException) {
                throw (RuntimeException)e2;
            }
            throw new UndeclaredThrowableException((Throwable)e);
        }
        finally {
            ThreadIdentityManager.reset((Object)token);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static FileOutputStream getFileOutputStream(final File target) throws FileNotFoundException {
        Object token = ThreadIdentityManager.runAsServer();
        try {
            FileOutputStream fileOutputStream = AccessController.doPrivileged(new PrivilegedExceptionAction<FileOutputStream>(){
                static final long serialVersionUID = 8371181073219302275L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public FileOutputStream run() throws FileNotFoundException {
                    return new FileOutputStream(target);
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"com.ibm.ws.artifact.zip.internal.FileUtils$9", 9.class, (String)"archive.artifact.zip", (String)"com.ibm.ws.artifact.zip.internal.resources.ZipArtifactMessages");
                }
            });
            return fileOutputStream;
        }
        catch (PrivilegedActionException privilegedActionException) {
            void e;
            FFDCFilter.processException((Throwable)privilegedActionException, (String)"com.ibm.ws.artifact.zip.internal.FileUtils", (String)"146", null, (Object[])new Object[]{target});
            Exception e2 = e.getException();
            if (e2 instanceof FileNotFoundException) {
                throw (FileNotFoundException)e2;
            }
            if (e2 instanceof RuntimeException) {
                throw (RuntimeException)e2;
            }
            throw new UndeclaredThrowableException((Throwable)e);
        }
        finally {
            ThreadIdentityManager.reset((Object)token);
        }
    }

    public static long fileLastModified(File target) {
        return FileUtils.fileAction(target, lastModifiedAction);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean fileSetLastModified(final File target, final long lastModified) {
        Object token = ThreadIdentityManager.runAsServer();
        try {
            boolean bl = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){
                static final long serialVersionUID = 7125329411662872886L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public Boolean run() {
                    return target.setLastModified(lastModified);
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"com.ibm.ws.artifact.zip.internal.FileUtils$11", 11.class, (String)"archive.artifact.zip", (String)"com.ibm.ws.artifact.zip.internal.resources.ZipArtifactMessages");
                }
            });
            return bl;
        }
        finally {
            ThreadIdentityManager.reset((Object)token);
        }
    }

    public static boolean fileCanRead(File target) {
        return FileUtils.fileAction(target, canReadAction);
    }

    public static boolean fileCanWrite(File target) {
        return FileUtils.fileAction(target, canWriteAction);
    }

    public static boolean fileDelete(File file) {
        return FileUtils.fileAction(file, deleteAction);
    }

    public static boolean ensureDirExists(File dir) {
        return FileUtils.fileAction(dir, ensureDirExistsAction);
    }

    public static boolean tryToClose(Closeable closeable) {
        Object token = ThreadIdentityManager.runAsServer();
        try {
            if (closeable != null) {
                try {
                    closeable.close();
                    boolean bl = true;
                    return bl;
                }
                catch (IOException iOException) {
                    FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.artifact.zip.internal.FileUtils", (String)"234", null, (Object[])new Object[]{closeable});
                }
            }
        }
        finally {
            ThreadIdentityManager.reset((Object)token);
        }
        return false;
    }

    public static boolean setUserReadWriteOnly(File file) {
        return AccessController.doPrivileged(new SetFilePermsAction(file));
    }

    /*
     * WARNING - void declaration
     */
    public static Boolean fileCreate(final File target) throws IOException {
        Object token = ThreadIdentityManager.runAsServer();
        try {
            Boolean bl = AccessController.doPrivileged(new PrivilegedExceptionAction<Boolean>(){
                static final long serialVersionUID = -4482577707204527456L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public Boolean run() throws IOException {
                    return target.createNewFile();
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"com.ibm.ws.artifact.zip.internal.FileUtils$16", 16.class, (String)"archive.artifact.zip", (String)"com.ibm.ws.artifact.zip.internal.resources.ZipArtifactMessages");
                }
            });
            return bl;
        }
        catch (PrivilegedActionException privilegedActionException) {
            void e;
            FFDCFilter.processException((Throwable)privilegedActionException, (String)"com.ibm.ws.artifact.zip.internal.FileUtils", (String)"279", null, (Object[])new Object[]{target});
            Exception e2 = e.getException();
            if (e2 instanceof IOException) {
                throw (IOException)e2;
            }
            if (e2 instanceof RuntimeException) {
                throw (RuntimeException)e2;
            }
            throw new UndeclaredThrowableException((Throwable)e);
        }
        finally {
            ThreadIdentityManager.reset((Object)token);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.artifact.zip.internal.FileUtils", FileUtils.class, (String)"archive.artifact.zip", (String)"com.ibm.ws.artifact.zip.internal.resources.ZipArtifactMessages");
        isFileAction = new Function<File, Boolean>(){
            static final long serialVersionUID = -332345720130794755L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public Boolean apply(File target) {
                return target.isFile();
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"com.ibm.ws.artifact.zip.internal.FileUtils$2", 2.class, (String)"archive.artifact.zip", (String)"com.ibm.ws.artifact.zip.internal.resources.ZipArtifactMessages");
            }
        };
        isDirectoryAction = new Function<File, Boolean>(){
            static final long serialVersionUID = 1304531089630631412L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public Boolean apply(File target) {
                return target.isDirectory();
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"com.ibm.ws.artifact.zip.internal.FileUtils$3", 3.class, (String)"archive.artifact.zip", (String)"com.ibm.ws.artifact.zip.internal.resources.ZipArtifactMessages");
            }
        };
        existsAction = new Function<File, Boolean>(){
            static final long serialVersionUID = 7242390500755814602L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public Boolean apply(File target) {
                return target.exists();
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"com.ibm.ws.artifact.zip.internal.FileUtils$4", 4.class, (String)"archive.artifact.zip", (String)"com.ibm.ws.artifact.zip.internal.resources.ZipArtifactMessages");
            }
        };
        lengthAction = new Function<File, Long>(){
            static final long serialVersionUID = 6996633621357258130L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public Long apply(File target) {
                return target.length();
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"com.ibm.ws.artifact.zip.internal.FileUtils$5", 5.class, (String)"archive.artifact.zip", (String)"com.ibm.ws.artifact.zip.internal.resources.ZipArtifactMessages");
            }
        };
        listFilesAction = new Function<File, File[]>(){
            static final long serialVersionUID = 7651026850582817853L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public File[] apply(File target) {
                return target.listFiles();
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"com.ibm.ws.artifact.zip.internal.FileUtils$6", 6.class, (String)"archive.artifact.zip", (String)"com.ibm.ws.artifact.zip.internal.resources.ZipArtifactMessages");
            }
        };
        listAction = new Function<File, String[]>(){
            static final long serialVersionUID = 3183556710849353280L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public String[] apply(File target) {
                return target.list();
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"com.ibm.ws.artifact.zip.internal.FileUtils$7", 7.class, (String)"archive.artifact.zip", (String)"com.ibm.ws.artifact.zip.internal.resources.ZipArtifactMessages");
            }
        };
        lastModifiedAction = new Function<File, Long>(){
            static final long serialVersionUID = -3228391137124960733L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public Long apply(File target) {
                return target.lastModified();
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"com.ibm.ws.artifact.zip.internal.FileUtils$10", 10.class, (String)"archive.artifact.zip", (String)"com.ibm.ws.artifact.zip.internal.resources.ZipArtifactMessages");
            }
        };
        canReadAction = new Function<File, Boolean>(){
            static final long serialVersionUID = 4652004055991403682L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public Boolean apply(File target) {
                return target.canRead();
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"com.ibm.ws.artifact.zip.internal.FileUtils$12", 12.class, (String)"archive.artifact.zip", (String)"com.ibm.ws.artifact.zip.internal.resources.ZipArtifactMessages");
            }
        };
        canWriteAction = new Function<File, Boolean>(){
            static final long serialVersionUID = 6223886276276424721L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public Boolean apply(File target) {
                return target.canWrite();
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"com.ibm.ws.artifact.zip.internal.FileUtils$13", 13.class, (String)"archive.artifact.zip", (String)"com.ibm.ws.artifact.zip.internal.resources.ZipArtifactMessages");
            }
        };
        deleteAction = new Function<File, Boolean>(){
            static final long serialVersionUID = -195018395112541789L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public Boolean apply(File target) {
                return target.delete();
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"com.ibm.ws.artifact.zip.internal.FileUtils$14", 14.class, (String)"archive.artifact.zip", (String)"com.ibm.ws.artifact.zip.internal.resources.ZipArtifactMessages");
            }
        };
        ensureDirExistsAction = new Function<File, Boolean>(){
            static final long serialVersionUID = -5986467972891832320L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public Boolean apply(File target) {
                return target.mkdirs() || target.exists();
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"com.ibm.ws.artifact.zip.internal.FileUtils$15", 15.class, (String)"archive.artifact.zip", (String)"com.ibm.ws.artifact.zip.internal.resources.ZipArtifactMessages");
            }
        };
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static class SetFilePermsAction
    implements PrivilegedAction<Boolean> {
        private final File file;
        static final long serialVersionUID = 7836076312388377282L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        SetFilePermsAction(File file) {
            this.file = file;
        }

        @Override
        public Boolean run() {
            this.file.setReadable(false, false);
            this.file.setWritable(false, false);
            this.file.setExecutable(false, false);
            this.file.setReadable(true, true);
            this.file.setWritable(true, true);
            return true;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.artifact.zip.internal.FileUtils$SetFilePermsAction", SetFilePermsAction.class, (String)"archive.artifact.zip", (String)"com.ibm.ws.artifact.zip.internal.resources.ZipArtifactMessages");
        }
    }
}

