/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.metrics23.writer;

import com.ibm.json.java.JSONObject;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.microprofile.metrics.helper.Util;
import com.ibm.ws.microprofile.metrics.writer.JSONMetricWriter;
import com.ibm.ws.microprofile.metrics23.helper.Util23;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.Writer;
import java.util.Map;
import org.eclipse.microprofile.metrics.ConcurrentGauge;
import org.eclipse.microprofile.metrics.Counter;
import org.eclipse.microprofile.metrics.Gauge;
import org.eclipse.microprofile.metrics.Histogram;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.Meter;
import org.eclipse.microprofile.metrics.Metric;
import org.eclipse.microprofile.metrics.MetricID;
import org.eclipse.microprofile.metrics.SimpleTimer;
import org.eclipse.microprofile.metrics.Timer;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class JSONMetricWriter23
extends JSONMetricWriter {
    private static final TraceComponent tc = Tr.register(JSONMetricWriter23.class, (String)"METRICS", (String)"com.ibm.ws.microprofile.metrics.resources.Metrics");
    static final long serialVersionUID = 5576763618730908685L;

    public JSONMetricWriter23(Writer writer) {
        super(writer);
    }

    /*
     * Could not resolve type clashes
     */
    @Override
    @FFDCIgnore(value={IllegalStateException.class})
    protected JSONObject getJsonFromMetricMap(Map<MetricID, Metric> metricMap, Map<String, Metadata> metricMetadataMap) {
        JSONObject jsonObject = new JSONObject();
        for (Map.Entry<MetricID, Metric> entry : metricMap.entrySet()) {
            Metric metric;
            String metricName;
            MetricID metricID = entry.getKey();
            Map tagsMap = metricID.getTags();
            String metricNameWithTags = metricName = metricID.getName();
            String tags = "";
            Metadata metricMetaData = metricMetadataMap.get(metricName);
            String unit = (String)metricMetaData.getUnit().get();
            double conversionFactor = 1.0;
            switch (unit) {
                case "nanoseconds": {
                    conversionFactor = 1.0;
                    break;
                }
                case "microseconds": {
                    conversionFactor = 1000.0;
                    break;
                }
                case "milliseconds": {
                    conversionFactor = 1000000.0;
                    break;
                }
                case "seconds": {
                    conversionFactor = 1.0E9;
                    break;
                }
                case "minutes": {
                    conversionFactor = 6.0E10;
                    break;
                }
                case "hours": {
                    conversionFactor = 3.6E12;
                    break;
                }
                case "days": {
                    conversionFactor = 8.64E13;
                }
            }
            if (tagsMap.size() != 0) {
                for (Map.Entry tagsMapEntrySet : tagsMap.entrySet()) {
                    String tagValue = (String)tagsMapEntrySet.getValue();
                    if (tagValue.contains(";")) {
                        tagValue = tagValue.replaceAll(";", "_");
                    }
                    tags = tags + ";" + (String)tagsMapEntrySet.getKey() + "=" + tagValue;
                }
                metricNameWithTags = metricName + tags;
            }
            if (Counter.class.isInstance(metric = entry.getValue())) {
                jsonObject.put((Object)metricNameWithTags, (Object)((Counter)metric).getCount());
                continue;
            }
            if (ConcurrentGauge.class.isInstance(metric)) {
                jsonObject.put((Object)metricName, (Object)this.getJsonFromMap(Util.getConcurrentGaugeNumbers((ConcurrentGauge)metric, tags), metricName, jsonObject));
                continue;
            }
            if (Gauge.class.isInstance(metric)) {
                try {
                    jsonObject.put((Object)metricNameWithTags, ((Gauge)metric).getValue());
                }
                catch (IllegalStateException illegalStateException) {}
                continue;
            }
            if (Timer.class.isInstance(metric)) {
                jsonObject.put((Object)metricName, (Object)this.getJsonFromMap(Util.getTimerNumbers((Timer)metric, tags, conversionFactor), metricName, jsonObject));
                continue;
            }
            if (SimpleTimer.class.isInstance(metric)) {
                jsonObject.put((Object)metricName, (Object)this.getJsonFromMap(Util23.getSimpleTimerNumbers((SimpleTimer)metric, tags, conversionFactor), metricName, jsonObject));
                continue;
            }
            if (Histogram.class.isInstance(metric)) {
                jsonObject.put((Object)metricName, (Object)this.getJsonFromMap(Util.getHistogramNumbers((Histogram)metric, tags), metricName, jsonObject));
                continue;
            }
            if (Meter.class.isInstance(metric)) {
                jsonObject.put((Object)metricName, (Object)this.getJsonFromMap(Util.getMeterNumbers((Meter)metric, tags), metricName, jsonObject));
                continue;
            }
            Tr.event((TraceComponent)tc, (String)("Metric type '" + metric.getClass() + " for " + metricName + " is invalid."), (Object[])new Object[0]);
        }
        return jsonObject;
    }
}

