/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.kernel.boot.internal.commands;

import com.ibm.ws.kernel.boot.internal.commands.JavaDumpAction;
import com.ibm.ws.kernel.boot.internal.commands.JavaDumper;
import com.ibm.ws.kernel.boot.internal.commands.ServerDumpUtil;
import java.io.File;
import java.lang.reflect.Method;

class IBMJavaDumperImpl
extends JavaDumper {
    private final Method javaDumpToFileMethod;
    private final Method heapDumpToFileMethod;
    private final Method triggerDumpMethod;

    IBMJavaDumperImpl(Method javaDumpToFileMethod, Method heapDumpToFileMethod, Method triggerDumpMethod) {
        this.javaDumpToFileMethod = javaDumpToFileMethod;
        this.heapDumpToFileMethod = heapDumpToFileMethod;
        this.triggerDumpMethod = triggerDumpMethod;
    }

    @Override
    public File dump(JavaDumpAction action, File outputDir) {
        switch (action) {
            case HEAP: {
                return this.processReturnedPath(action, this.invokeToFileMethod(this.heapDumpToFileMethod));
            }
            case SYSTEM: {
                try {
                    String resultPath = (String)this.triggerDumpMethod.invoke(null, "system:request=exclusive+serial+prepwalk");
                    return this.processReturnedPath(action, resultPath);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            case THREAD: {
                return this.processReturnedPath(action, this.invokeToFileMethod(this.javaDumpToFileMethod));
            }
        }
        return null;
    }

    private String invokeToFileMethod(Method method) {
        String resultPath;
        try {
            Object fileNamePattern = null;
            resultPath = (String)method.invoke(null, fileNamePattern);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return resultPath;
    }

    private File processReturnedPath(JavaDumpAction action, String resultPath) {
        if (ServerDumpUtil.isZos() && JavaDumpAction.SYSTEM == action) {
            return null;
        }
        return new File(resultPath);
    }
}

