/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yoko.orb.OB;

import java.util.concurrent.atomic.AtomicInteger;
import org.apache.yoko.orb.CORBA.OutputStreamHolder;
import org.apache.yoko.orb.IOP.ServiceContexts;
import org.apache.yoko.orb.OB.CodeConverters;
import org.apache.yoko.orb.OB.Downcall;
import org.apache.yoko.orb.OB.DowncallEmitter;
import org.apache.yoko.orb.OB.RefCountPolicyList;
import org.apache.yoko.orb.OCI.ConnectorInfo;
import org.apache.yoko.orb.OCI.ProfileInfo;
import org.apache.yoko.orb.OCI.TransportInfo;
import org.apache.yoko.rmi.util.ObjectUtil;
import org.apache.yoko.util.Assert;
import org.omg.CORBA.Policy;
import org.omg.IOP.IOR;

public abstract class Client {
    public static final int Blocking = 0;
    public static final int Threaded = 2;
    private final String label = ObjectUtil.getNextObjectLabel(this.getClass());
    private final AtomicInteger users = new AtomicInteger(0);
    private final CodeConverters codeConverters;
    final int concurrencyModel;

    Client(int concModel, CodeConverters conv) {
        this.codeConverters = conv;
        this.concurrencyModel = concModel;
    }

    public abstract void destroy();

    public final void obtain() {
        int count = this.users.incrementAndGet();
        Assert.ensure((count > 0 ? 1 : 0) != 0);
    }

    public final boolean release() {
        int count = this.users.decrementAndGet();
        Assert.ensure((count >= 0 ? 1 : 0) != 0);
        return count == 0;
    }

    final CodeConverters codeConverters() {
        return this.codeConverters;
    }

    public abstract int getNewRequestID();

    public abstract ServiceContexts getAMIRouterContexts();

    public abstract ProfileInfo[] getUsableProfiles(IOR var1, Policy[] var2);

    public abstract ConnectorInfo connectorInfo();

    public abstract TransportInfo transportInfo();

    public abstract DowncallEmitter startDowncall(Downcall var1, OutputStreamHolder var2);

    public abstract boolean matches(Client var1);

    public abstract void bind(int var1);

    public abstract boolean twoway();

    public void prepareForDowncall(RefCountPolicyList policies) {
    }

    public String toString() {
        return this.label + "[users=" + this.users + "]";
    }
}

