/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.api.annotation.support;

import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.instrumentation.api.annotation.support.AttributeBindingFactory;
import io.opentelemetry.instrumentation.api.annotation.support.CombinedAttributeBindings;
import io.opentelemetry.instrumentation.api.annotation.support.EmptyAttributeBindings;
import io.opentelemetry.instrumentation.api.annotation.support.ParameterAttributeNamesExtractor;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;

interface AttributeBindings {
    public boolean isEmpty();

    public void apply(AttributesBuilder var1, Object[] var2);

    public static AttributeBindings bind(Method method, ParameterAttributeNamesExtractor parameterAttributeNamesExtractor) {
        AttributeBindings bindings = EmptyAttributeBindings.INSTANCE;
        Parameter[] parameters = method.getParameters();
        if (parameters.length == 0) {
            return bindings;
        }
        String[] attributeNames = parameterAttributeNamesExtractor.extract(method, parameters);
        if (attributeNames == null || attributeNames.length != parameters.length) {
            return bindings;
        }
        for (int i = 0; i < parameters.length; ++i) {
            Parameter parameter = parameters[i];
            String attributeName = attributeNames[i];
            if (attributeName == null || attributeName.isEmpty()) continue;
            bindings = new CombinedAttributeBindings(bindings, i, AttributeBindingFactory.createBinding(attributeName, parameter.getParameterizedType()));
        }
        return bindings;
    }
}

