/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.monitor;

import com.ibm.websphere.pmi.PmiConstants;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.webcontainer.monitor.ServletPmiModule;
import com.ibm.ws.webcontainer.monitor.WebAppPerf;
import com.ibm.wsspi.pmi.factory.StatisticActions;
import com.ibm.wsspi.pmi.factory.StatsFactory;
import com.ibm.wsspi.pmi.factory.StatsFactoryException;
import com.ibm.wsspi.pmi.factory.StatsGroup;
import com.ibm.wsspi.pmi.factory.StatsInstance;
import com.ibm.wsspi.pmi.factory.StatsTemplateLookup;
import com.ibm.wsspi.pmi.stat.SPICountStatistic;
import com.ibm.wsspi.pmi.stat.SPIStatistic;
import com.ibm.wsspi.webcontainer.logging.LoggerFactory;
import com.ibm.wsspi.webcontainer.logging.LoggerHelper;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class WebAppModule
extends StatisticActions
implements WebAppPerf,
PmiConstants {
    private static final String template = "/com/ibm/ws/webcontainer/pmi/webAppModuleStats.xml";
    private static final String servletTemplate = "/com/ibm/ws/webcontainer/pmi/servletStats.xml";
    private static StatsGroup webStatsGroup;
    StatsGroup servletStatsGroup = null;
    private StatsInstance webStatsInstance;
    private static final long serialVersionUID = -8923368384399206317L;
    protected static final Logger logger;
    private static final String CLASS_NAME = "com.ibm.ws.wswebcontainer.stats.WebAppModule";
    public static final String WEBAPP_MODULE = "webAppModule";
    public static final String SERVLET_MODULE = "webAppModule.servlets";
    private SPICountStatistic sgLoadedServlets = null;
    private SPICountStatistic sgNumReloads = null;
    private HashMap servletData = null;
    private String appPmiName = null;
    public static final int LOADED_SERVLETS = 1;
    public static final int NUM_RELOADS = 2;
    public static final int SERVLETS = 10;
    public static final int TOTAL_REQUESTS = 11;
    public static final int CONCURRENT_REQUESTS = 12;
    public static final int RESPONSE_TIME = 13;
    public static final int NUM_ERRORS = 14;
    public static final int ASYNC_CONTEXT_RESPONSE_TIME = 18;

    public WebAppModule(String appName) {
        this(appName, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public WebAppModule(String appName, boolean removeOldStatsInstance) {
        this.appPmiName = appName;
        this.servletData = new HashMap();
        try {
            String string = template;
            synchronized (template) {
                StatsInstance oldInstance;
                if (webStatsGroup == null) {
                    webStatsGroup = StatsFactory.createStatsGroup((String)WEBAPP_MODULE, (String)template, null, (StatisticActions)this);
                }
                // ** MonitorExit[var3_3] (shouldn't be in output)
                if (removeOldStatsInstance && (oldInstance = StatsFactory.getStatsInstance((String[])new String[]{WEBAPP_MODULE, appName})) != null) {
                    StatsFactory.removeStatsInstance((StatsInstance)oldInstance);
                }
                this.webStatsInstance = StatsFactory.createStatsInstance((String)appName, (StatsGroup)webStatsGroup, null, (StatisticActions)this);
                this.createServletStatsGroup();
                return;
            }
        }
        catch (StatsFactoryException sfe) {
            if (!TraceComponent.isAnyTracingEnabled() || !logger.isLoggable(Level.FINE)) return;
            logger.logp(Level.FINE, CLASS_NAME, "WebAppModule", "PMI StatsFactoryException." + sfe.getMessage());
        }
    }

    public void statisticCreated(SPIStatistic s) {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "statisticCreated", "Servlet statistic created with id=" + s.getId());
        }
        if (s.getId() == 1) {
            this.sgLoadedServlets = (SPICountStatistic)s;
        } else if (s.getId() == 2) {
            this.sgNumReloads = (SPICountStatistic)s;
        }
    }

    @Override
    public void onApplicationAvailableForService() {
    }

    @Override
    public void onApplicationUnavailableForService() {
    }

    @Override
    public void onApplicationStart() {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "onApplicationStart", "pmi WebAppModule received onApplicationStart");
        }
        if (this.sgNumReloads != null) {
            this.sgNumReloads.increment();
        }
    }

    @Override
    public void onApplicationEnd() {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "onApplicationEnd", "pmi WebAppModule received onApplicationEnd");
        }
        try {
            StatsFactory.removeStatsInstance((StatsInstance)this.webStatsInstance);
            StatsFactory.removeStatsGroup((StatsGroup)this.servletStatsGroup);
        }
        catch (StatsFactoryException e) {
            LoggerHelper.logParamsAndException((Logger)logger, (Level)Level.SEVERE, (String)CLASS_NAME, (String)"onApplicationEnd", (String)"failed.to.remove.pmi.stats", (Object[])new Object[]{this.appPmiName}, (Throwable)e);
        }
    }

    @Override
    public final void onServletStartService(String servletName, String url) {
        ServletPmiModule data;
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "onServletStartService", "pmi WebAppModule received onServletStartService for servlet:" + servletName + ", url:" + url);
        }
        if ((data = (ServletPmiModule)this.servletData.get(servletName)) == null) {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "onServletStartService", "could not find a servlet pmi module, returning");
            }
            return;
        }
        data.incRequests(url);
    }

    @Override
    public final void onServletFinishService(String servletName, long responseTime, String url) {
        ServletPmiModule data;
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "onServletFinishService", "pmi WebAppModule received onServletFinishService for servlet:" + servletName + ", url:" + url);
        }
        if ((data = (ServletPmiModule)this.servletData.get(servletName)) == null) {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "onServletFinishService", "could not find a servlet pmi module, returning");
            }
            return;
        }
        data.decRequests(responseTime, url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onServletStartInit(String j2eeName, String servletName) {
        ServletPmiModule data = new ServletPmiModule(this.appPmiName, servletName, this.webStatsInstance, this.servletStatsGroup);
        HashMap hashMap = this.servletData;
        synchronized (hashMap) {
            this.servletData.put(servletName, data);
        }
        if (this.sgLoadedServlets != null) {
            this.sgLoadedServlets.increment();
        }
    }

    private void createServletStatsGroup() {
        block3: {
            if (this.servletStatsGroup == null) {
                try {
                    this.servletStatsGroup = StatsFactory.createStatsGroup((String)SERVLET_MODULE, (String)servletTemplate, (StatsInstance)this.webStatsInstance, null, (StatisticActions)this);
                }
                catch (StatsFactoryException e) {
                    if (!TraceComponent.isAnyTracingEnabled() || !logger.isLoggable(Level.FINE)) break block3;
                    logger.logp(Level.FINE, CLASS_NAME, "onServletStartInit", "StatsFactoryException : " + e.getMessage());
                }
            }
        }
    }

    @Override
    public void onServletFinishInit(String servletName) {
    }

    @Override
    public void onServletStartDestroy(String servletName) {
    }

    @Override
    public void onServletFinishDestroy(String servletName) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onServletUnloaded(String servletName) {
        ServletPmiModule data;
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "onServletUnloaded", "pmi WebAppModule unloading servlet:" + servletName);
        }
        if ((data = (ServletPmiModule)this.servletData.get(servletName)) != null) {
            HashMap hashMap = this.servletData;
            synchronized (hashMap) {
                this.servletData.remove(servletName);
            }
        } else {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "onServletUnloaded", "could not find a servlet pmi module, returning");
            }
            return;
        }
        data.destroy();
        if (this.sgLoadedServlets != null) {
            this.sgLoadedServlets.increment(-1L);
        }
    }

    @Override
    public void onServletAvailableForService(String servletName) {
    }

    @Override
    public void onServletUnavailableForService(String servletName) {
    }

    @Override
    public void onServletInitError(String servletName) {
        this.onServletError(servletName);
    }

    @Override
    public void onServletServiceError(String servletName) {
        this.onServletError(servletName);
    }

    public void onServletError(String servletName) {
        ServletPmiModule data;
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "onServletError", "pmi WebAppModule received error for servlet:" + servletName);
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "onServletError", "onServletError(), servletName=" + servletName);
        }
        if ((data = (ServletPmiModule)this.servletData.get(servletName)) == null) {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "onServletError", "could not find a servlet pmi module, returning");
            }
            return;
        }
        data.incNumErrors();
    }

    @Override
    public void onServletServiceDenied(String servletName) {
    }

    @Override
    public void onServletDestroyError(String servletName) {
        this.onServletError(servletName);
    }

    public void updateStatisticOnRequest(int arg0) {
    }

    @Override
    public void onAsyncContextComplete(String servletName, long responseTime, String url) {
        ServletPmiModule data;
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "onAsyncContextComplete", "pmi WebAppModule received onAsyncContextComplete for servlet:" + servletName + ", url:" + url);
        }
        if ((data = (ServletPmiModule)this.servletData.get(servletName)) == null) {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "onAsyncContextComplete", "could not find a servlet pmi module, returning");
            }
            return;
        }
        data.onAsyncContextComplete(responseTime, url);
    }

    static {
        block2: {
            logger = LoggerFactory.getInstance().getLogger("com.ibm.ws.webcontainer.stats");
            try {
                Class<?> lookupClass = Class.forName("com.ibm.ws.pmi.preprocess.webcontainer_StatsTemplateLookup");
                StatsFactory.registerStatsTemplateLookup((StatsTemplateLookup)((StatsTemplateLookup)lookupClass.newInstance()));
            }
            catch (Exception e) {
                if (!TraceComponent.isAnyTracingEnabled() || !logger.isLoggable(Level.FINE)) break block2;
                logger.logp(Level.FINE, CLASS_NAME, "updateStatisticOnRequest", "PMI StatsTemplateLookup class not found.");
            }
        }
    }
}

