/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.tcpchannel.internal;

import com.ibm.io.async.AsyncSocketChannel;
import com.ibm.io.async.AsyncSocketChannelHelper;
import com.ibm.io.async.IAsyncFuture;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.tcpchannel.internal.AioReadCompletionListener;
import com.ibm.ws.tcpchannel.internal.AioTCPChannel;
import com.ibm.ws.tcpchannel.internal.AioTCPReadRequestContextImpl;
import com.ibm.ws.tcpchannel.internal.AioTCPWriteRequestContextImpl;
import com.ibm.ws.tcpchannel.internal.AioWriteCompletionListener;
import com.ibm.ws.tcpchannel.internal.SocketIOChannel;
import com.ibm.ws.tcpchannel.internal.TCPChannel;
import com.ibm.ws.tcpchannel.internal.TCPReadRequestContextImpl;
import com.ibm.ws.tcpchannel.internal.TCPWriteRequestContextImpl;
import com.ibm.wsspi.channelfw.VirtualConnection;
import java.io.IOException;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import java.util.List;

public class AioSocketIOChannel
extends SocketIOChannel {
    private static final TraceComponent tc = Tr.register(AioSocketIOChannel.class, (String)"TCPChannel", (String)"com.ibm.ws.tcpchannel.internal.resources.TCPChannelMessages");
    private AsyncSocketChannel asyncChannel = null;
    private AsyncSocketChannelHelper asyncHelper = null;
    private IAsyncFuture readFuture = null;
    private IAsyncFuture writeFuture = null;
    private final ByteBuffer[] singleReadBuffer = new ByteBuffer[1];
    private final ByteBuffer[] singleWriteBuffer = new ByteBuffer[1];

    protected AioSocketIOChannel(Socket socket, AsyncSocketChannel achannel, TCPChannel _tcpChannel) {
        super(socket, _tcpChannel);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"AioSocketIOChannel", (Object[])new Object[0]);
        }
        this.asyncChannel = achannel;
        this.asyncHelper = new AsyncSocketChannelHelper(this.asyncChannel);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"AioSocketIOChannel");
        }
    }

    protected static SocketIOChannel createIOChannel(Socket _socket, AsyncSocketChannel achannel, TCPChannel _tcpChannel) {
        AioSocketIOChannel ioSocket = new AioSocketIOChannel(_socket, achannel, _tcpChannel);
        return ioSocket;
    }

    @Override
    public void connectActions() throws IOException {
        this.asyncChannel.prepareSocket();
    }

    protected boolean readAIO(AioTCPReadRequestContextImpl req, boolean force, long timeout) throws IOException {
        AioReadCompletionListener readAIOListener = AioTCPChannel.getAioReadCompletionListener();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"readAIO", (Object[])new Object[0]);
        }
        boolean forceQueue = force;
        boolean complete = false;
        long byteCount = 0L;
        boolean useJITinNative = false;
        ByteBuffer[] bufArray = null;
        VirtualConnection vci = req.getTCPConnLink().getVirtualConnection();
        if (req.getBuffers().length == 1) {
            this.singleReadBuffer[0] = req.preProcessOneReadBuffer();
            bufArray = this.singleReadBuffer;
        } else {
            bufArray = req.preProcessReadBuffers();
        }
        if (AioTCPChannel.getJitSupportedByNative() && req.getJITAllocatedDirect() && req.getIODoneAmount() == 0L && req.getJITAllocateSize() == 8192) {
            useJITinNative = true;
        }
        this.readFuture = this.asyncHelper.read(bufArray, timeout, forceQueue, req.getIOAmount() - req.getIODoneAmount(), useJITinNative, vci, true);
        if (this.readFuture == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"readAIO: false");
            }
            return false;
        }
        if (this.readFuture.isCompleted() && !forceQueue) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"data already available and forceQueue is false", (Object[])new Object[0]);
            }
            try {
                byteCount = this.readFuture.getByteCount();
            }
            catch (InterruptedException ie) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("InterruptedException received on immediate async read " + ie.getMessage()), (Object[])new Object[0]);
                }
                FFDCFilter.processException((Throwable)ie, (String)(this.getClass().getName() + ".readAIO"), (String)"138");
                IOException newIOE = new IOException(ie.getMessage());
                newIOE.initCause(ie);
                throw newIOE;
            }
            req.postProcessReadBuffers(byteCount);
            complete = req.updateIOCounts(byteCount, 0);
            if (!complete) {
                this.readFuture = this.asyncHelper.read(bufArray, timeout, forceQueue, req.getIOAmount(), false, vci, true);
                if (this.tcpChannel.getConfig().getDumpStatsInterval() > 0) {
                    this.tcpChannel.totalAsyncReadRetries.incrementAndGet();
                }
            }
        }
        if (!complete) {
            if (useJITinNative && byteCount == 0L && !this.readFuture.isCompleted()) {
                req.getBuffer().release();
                req.setBuffer(null);
            }
            this.readFuture.addCompletionListener(readAIOListener, req);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"added completion listener to read future", (Object[])new Object[0]);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("readAIO: " + complete));
        }
        return complete;
    }

    protected long readAIOSync(long numBytes, TCPReadRequestContextImpl req) throws IOException {
        VirtualConnection vci = req.getTCPConnLink().getVirtualConnection();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"readAIOSync", (Object[])new Object[0]);
        }
        boolean complete = false;
        long byteCount = 0L;
        long remainingTimeout = req.getTimeoutInterval();
        while (!complete) {
            ByteBuffer[] bufArray = null;
            if (req.getBuffers().length == 1) {
                this.singleReadBuffer[0] = req.preProcessOneReadBuffer();
                bufArray = this.singleReadBuffer;
            } else {
                bufArray = req.preProcessReadBuffers();
            }
            this.readFuture = this.asyncHelper.read(bufArray, false, numBytes, false, vci, false);
            try {
                if (numBytes == 0L) {
                    if (this.readFuture.isCompleted()) {
                        byteCount = this.readFuture.getByteCount();
                        req.postProcessReadBuffers(byteCount);
                        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                            Tr.exit((TraceComponent)tc, (String)("readAIOSync: " + byteCount));
                        }
                        return byteCount;
                    }
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"readAIOSync: 0");
                    }
                    return 0L;
                }
                byteCount = this.readFuture.getByteCount(remainingTimeout);
                req.postProcessReadBuffers(byteCount);
            }
            catch (InterruptedException ie) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"InterruptedException caught while doing getByteCount", (Object[])new Object[0]);
                }
                FFDCFilter.processException((Throwable)ie, (String)(this.getClass().getName() + ".readAIOSync"), (String)"234");
                IOException newIOE = new IOException(ie.getMessage());
                newIOE.initCause(ie);
                throw newIOE;
            }
            complete = req.updateIOCounts(byteCount, 0);
            if (complete) continue;
            if (this.tcpChannel.getConfig().getDumpStatsInterval() > 0) {
                this.tcpChannel.totalPartialSyncReads.incrementAndGet();
            }
            if (req.getTimeoutInterval() == 0 || (remainingTimeout = req.getTimeoutTime() - System.currentTimeMillis()) > 0L) continue;
            SocketTimeoutException ioe = new SocketTimeoutException("Sync read timed out after reading partial data");
            throw ioe;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("readAIOSync: " + req.getIODoneAmount()));
        }
        return req.getIODoneAmount();
    }

    protected boolean writeAIO(TCPWriteRequestContextImpl req, boolean force, long timeout) throws IOException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"writeAIO", (Object[])new Object[0]);
        }
        AioWriteCompletionListener writeAIOListener = AioTCPChannel.getAioWriteCompletionListener();
        boolean forceQueue = force;
        boolean complete = false;
        ByteBuffer[] bufArray = null;
        VirtualConnection vci = req.getTCPConnLink().getVirtualConnection();
        if (req.getBuffers().length == 1) {
            this.singleWriteBuffer[0] = req.preProcessOneWriteBuffer();
            bufArray = this.singleWriteBuffer;
        } else {
            bufArray = req.preProcessWriteBuffers();
        }
        this.writeFuture = this.asyncHelper.write(bufArray, req.getTimeoutInterval(), forceQueue, req.getIOAmount(), vci, true);
        if (this.writeFuture == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"writeAIO");
            }
            return false;
        }
        if (this.writeFuture.isCompleted() && !forceQueue) {
            long byteCount;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"data already written and forceQueue is false", (Object[])new Object[0]);
            }
            try {
                byteCount = this.writeFuture.getByteCount();
            }
            catch (InterruptedException ie) {
                FFDCFilter.processException((Throwable)ie, (String)(this.getClass().getName() + ".writeAIO"), (String)"290");
                IOException newIOE = new IOException(ie.getMessage());
                newIOE.initCause(ie);
                throw newIOE;
            }
            req.postProcessWriteBuffers(byteCount);
            complete = req.getIOAmount() == -1L ? ((AioTCPWriteRequestContextImpl)req).updateForAllData(byteCount) : req.updateIOCounts(byteCount, 1);
            if (!complete) {
                this.writeFuture = this.asyncHelper.write(bufArray, req.getTimeoutInterval(), forceQueue, req.getIOAmount(), vci, true);
                if (this.tcpChannel.getConfig().getDumpStatsInterval() > 0) {
                    this.tcpChannel.totalAsyncWriteRetries.incrementAndGet();
                }
            }
        }
        if (!complete) {
            this.writeFuture.addCompletionListener(writeAIOListener, req);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"added completion listener to write future", (Object[])new Object[0]);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"writeAIO");
        }
        return complete;
    }

    protected long writeAIOSync(TCPWriteRequestContextImpl req) throws IOException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"writeAIOSync", (Object[])new Object[0]);
        }
        VirtualConnection vci = req.getTCPConnLink().getVirtualConnection();
        boolean complete = false;
        long byteCount = 0L;
        long remainingTimeout = req.getTimeoutInterval();
        while (!complete) {
            ByteBuffer[] bufArray = null;
            if (req.getBuffers().length == 1) {
                this.singleWriteBuffer[0] = req.preProcessOneWriteBuffer();
                bufArray = this.singleWriteBuffer;
            } else {
                bufArray = req.preProcessWriteBuffers();
            }
            this.writeFuture = this.asyncHelper.write(bufArray, false, req.getIOAmount(), vci, false);
            try {
                byteCount = this.writeFuture.getByteCount(remainingTimeout);
                req.postProcessWriteBuffers(byteCount);
            }
            catch (InterruptedException ie) {
                FFDCFilter.processException((Throwable)ie, (String)(this.getClass().getName() + ".writeAIOSync"), (String)"358");
                IOException newIOE = new IOException(ie.getMessage());
                newIOE.initCause(ie);
                throw newIOE;
            }
            complete = req.getIOAmount() == -1L ? ((AioTCPWriteRequestContextImpl)req).updateForAllData(byteCount) : req.updateIOCounts(byteCount, 1);
            if (complete) continue;
            if (this.tcpChannel.getConfig().getDumpStatsInterval() > 0) {
                this.tcpChannel.totalPartialSyncWrites.incrementAndGet();
            }
            if (req.getTimeoutInterval() == 0 || (remainingTimeout = req.getTimeoutTime() - System.currentTimeMillis()) > 0L) continue;
            SocketTimeoutException ioe = new SocketTimeoutException("Sync write timed out after writing partial data");
            throw ioe;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"writeAIOSync");
        }
        return req.getIODoneAmount();
    }

    protected void timeoutReadFuture() {
        if (this.readFuture != null && !this.readFuture.isCompleted()) {
            this.readFuture.cancel(new SocketTimeoutException("Socket read operation timed out by application request"));
        }
    }

    protected void timeoutWriteFuture() {
        if (this.writeFuture != null && !this.writeFuture.isCompleted()) {
            this.writeFuture.cancel(new SocketTimeoutException("Socket write operation timed out by application request"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public void close() {
        if (TraceComponent.isAnyTracingEnabled() && AioSocketIOChannel.tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)AioSocketIOChannel.tc, (String)"close", (Object[])new Object[0]);
        }
        if (TraceComponent.isAnyTracingEnabled() && AioSocketIOChannel.tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)AioSocketIOChannel.tc, (String)("SocketChannel close starting, local: " + this.socket.getLocalSocketAddress() + " remote: " + this.socket.getRemoteSocketAddress()), (Object[])new Object[0]);
        }
        var1_1 = this;
        synchronized (var1_1) {
            if (this.closed) {
                this.processClose = false;
            }
            this.closed = true;
        }
        if (this.processClose) {
            try {
                if (TraceComponent.isAnyTracingEnabled() && AioSocketIOChannel.tc.isEventEnabled()) {
                    Tr.event((TraceComponent)AioSocketIOChannel.tc, (String)("AsyncSocketChannel close, local: " + this.socket.getLocalSocketAddress() + " remote: " + this.socket.getRemoteSocketAddress()), (Object[])new Object[0]);
                }
                if (this.asyncChannel == null) ** GOTO lbl30
                this.asyncChannel.close();
            }
            catch (IOException ioe) {
                if (!TraceComponent.isAnyTracingEnabled() || !AioSocketIOChannel.tc.isDebugEnabled()) ** GOTO lbl30
                Tr.debug((TraceComponent)AioSocketIOChannel.tc, (String)("IOException while closing channel " + ioe.getMessage()), (Object[])new Object[0]);
            }
            finally {
                super.close();
            }
        } else if (TraceComponent.isAnyTracingEnabled() && AioSocketIOChannel.tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)AioSocketIOChannel.tc, (String)("close called on channel already closed, local: " + this.socket.getLocalSocketAddress() + " remote: " + this.socket.getRemoteSocketAddress()), (Object[])new Object[0]);
        }
lbl30:
        // 7 sources

        if (TraceComponent.isAnyTracingEnabled() && AioSocketIOChannel.tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)AioSocketIOChannel.tc, (String)"close");
        }
    }

    protected AsyncSocketChannel getAsyncChannel() {
        return this.asyncChannel;
    }

    @Override
    public List<String> introspect() {
        List<String> rc = super.introspect();
        String prefix = this.getClass().getSimpleName() + "@" + this.hashCode() + ": ";
        rc.add(prefix + "asyncChannel=" + this.asyncChannel);
        rc.add(prefix + "asyncHelper=" + this.asyncHelper);
        rc.add(prefix + "readFuture=" + this.readFuture);
        rc.add(prefix + "writeFuture=" + this.writeFuture);
        return rc;
    }

    @Override
    public String[] introspectSelf() {
        List<String> rc = this.introspect();
        return rc.toArray(new String[rc.size()]);
    }
}

