/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.core.providerfactory;

import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.container.ResourceInfo;
import jakarta.ws.rs.core.Request;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import jakarta.ws.rs.ext.ExceptionMapper;
import java.lang.invoke.MethodHandles;
import org.jboss.logging.Logger;
import org.jboss.resteasy.resteasy_jaxrs.i18n.LogMessages;
import org.jboss.resteasy.spi.ApplicationException;
import org.jboss.resteasy.spi.ResteasyProviderFactory;

class DefaultExceptionMapper
implements ExceptionMapper<Throwable> {
    private static final LogMessages LOGGER = (LogMessages)Logger.getMessageLogger((MethodHandles.Lookup)MethodHandles.lookup(), LogMessages.class, (String)DefaultExceptionMapper.class.getName());
    static final DefaultExceptionMapper INSTANCE = new DefaultExceptionMapper();

    DefaultExceptionMapper() {
    }

    public Response toResponse(Throwable exception) {
        Throwable cause;
        if (exception instanceof ApplicationException && (cause = exception.getCause()) != null) {
            return this.process(cause);
        }
        return this.process(exception);
    }

    private Response process(Throwable exception) {
        if (LOGGER.isEnabled(Logger.Level.ERROR)) {
            ResteasyProviderFactory providerFactory = ResteasyProviderFactory.getInstance();
            Request request = providerFactory.getContextData(Request.class);
            ResourceInfo resourceInfo = providerFactory.getContextData(ResourceInfo.class);
            UriInfo uriInfo = providerFactory.getContextData(UriInfo.class);
            StringBuilder info = new StringBuilder();
            if (request != null) {
                info.append(request.getMethod());
                if (uriInfo != null || resourceInfo != null) {
                    info.append(' ');
                }
            }
            if (uriInfo != null) {
                info.append(uriInfo.getRequestUri().getPath());
                if (resourceInfo != null) {
                    info.append(" - ");
                }
            }
            if (resourceInfo != null) {
                info.append(resourceInfo.getResourceClass().getName()).append('.').append(resourceInfo.getResourceMethod().getName());
            }
            if (info.length() == 0) {
                LOGGER.defaultExceptionMapper(exception);
            } else {
                LOGGER.defaultExceptionMapper(exception, info);
            }
        }
        if (exception instanceof WebApplicationException) {
            return ((WebApplicationException)exception).getResponse();
        }
        return Response.serverError().entity((Object)exception.getLocalizedMessage()).build();
    }
}

