/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.jcache.utils;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLConnection;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.regex.Pattern;
import javax.cache.spi.CachingProvider;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class CacheConfigUtil {
    private static final TraceComponent tc = Tr.register(CacheConfigUtil.class, (String)"jcache", (String)"io.openliberty.jcache.internal.resources.JCacheMessages");
    private static final String HAZELCAST_PROVIDER = "com.hazelcast.cache.HazelcastCachingProvider";
    private static final String HAZELCAST_MEMBER_PROVIDER = "com.hazelcast.cache.HazelcastMemberCachingProvider";
    private static final String HAZELCAST_SERVER_IMPL_PROVIDER = "com.hazelcast.cache.impl.HazelcastServerCachingProvider";
    private static final String HAZELCAST_CLIENT_PROVIDER = "com.hazelcast.client.cache.HazelcastClientCachingProvider";
    private static final String HAZELCAST_CLIENT_IMPL_PROVIDER = "com.hazelcast.client.cache.impl.HazelcastClientCachingProvider";
    private static final String INFINISPAN_EMBEDDED_PROVIDER = "org.infinispan.jcache.embedded.JCachingProvider";
    private static final String INFINISPAN_REMOTE_PROVIDER = "org.infinispan.jcache.remote.JCachingProvider";
    private File tempConfigFile;
    static final long serialVersionUID = 8276380344686042896L;

    public void cleanup() {
        if (this.tempConfigFile != null) {
            this.tempConfigFile.delete();
        }
    }

    /*
     * WARNING - void declaration
     */
    public URI preConfigureCacheManager(String uriValue, CachingProvider cachingProvider, Properties properties) throws IOException {
        URI configuredUri;
        URI uriToReturn = null;
        if (uriValue != null) {
            try {
                configuredUri = new URI(uriValue);
            }
            catch (URISyntaxException uRISyntaxException) {
                void e;
                FFDCFilter.processException((Throwable)uRISyntaxException, (String)"io.openliberty.jcache.utils.CacheConfigUtil", (String)"105", (Object)this, (Object[])new Object[]{uriValue, cachingProvider, properties});
                throw new IllegalArgumentException(Tr.formatMessage((TraceComponent)tc, (String)"INCORRECT_URI_SYNTAX", (Object[])new Object[]{e}), (Throwable)e);
            }
        } else {
            configuredUri = null;
        }
        switch (cachingProvider.getClass().getName()) {
            case "com.hazelcast.cache.HazelcastCachingProvider": 
            case "com.hazelcast.cache.HazelcastMemberCachingProvider": 
            case "com.hazelcast.cache.impl.HazelcastServerCachingProvider": 
            case "com.hazelcast.client.cache.HazelcastClientCachingProvider": 
            case "com.hazelcast.client.cache.impl.HazelcastClientCachingProvider": {
                if (uriValue == null) break;
                properties.setProperty("hazelcast.config.location", uriValue);
                break;
            }
            case "org.infinispan.jcache.embedded.JCachingProvider": {
                uriToReturn = this.generateOrUpdateInfinispanConfig(configuredUri);
                break;
            }
            case "org.infinispan.jcache.remote.JCachingProvider": {
                boolean isRemoteCachingConfigured = false;
                for (String key : properties.stringPropertyNames()) {
                    if (key == null || !key.contains("com.ibm.ws.session.") || !key.endsWith(".template_name") && !key.endsWith(".configuration_uri")) continue;
                    isRemoteCachingConfigured = true;
                    break;
                }
                if (!isRemoteCachingConfigured) {
                    properties.put("infinispan.client.hotrod.cache.[com.ibm.ws.session.*].template_name", "org.infinispan.REPL_SYNC");
                }
                uriToReturn = configuredUri;
                break;
            }
            default: {
                uriToReturn = configuredUri;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("The following properties will be configured for Infinispan: " + properties), (Object[])new Object[0]);
        }
        return uriToReturn;
    }

    /*
     * WARNING - void declaration
     */
    private URI generateOrUpdateInfinispanConfig(URI configuredURI) throws IOException {
        boolean trace = TraceComponent.isAnyTracingEnabled();
        if (configuredURI == null) {
            this.tempConfigFile = File.createTempFile("infinispan", ".xml");
            this.tempConfigFile.setReadable(true);
            this.tempConfigFile.setWritable(true);
            StringWriter sw = new StringWriter();
            PrintStream out = new PrintStream(new BufferedOutputStream(new FileOutputStream(this.tempConfigFile)));
            try {
                PrintWriter pw = new PrintWriter(sw);
                try {
                    List<String> lines = Arrays.asList("<infinispan>", " <jgroups>", "  <stack-file name=\"jgroups-udp\" path=\"/default-configs/default-jgroups-udp.xml\"/>", " </jgroups>", " <cache-container>", "  <transport stack=\"jgroups-udp\"/>", "  <replicated-cache-configuration name=\"com.ibm.ws.session.*\"/>", " </cache-container>", "</infinispan>");
                    pw.println();
                    for (String line : lines) {
                        out.println(line);
                        pw.println(line);
                    }
                    pw.close();
                }
                catch (Throwable lines) {
                    FFDCFilter.processException((Throwable)lines, (String)"io.openliberty.jcache.utils.CacheConfigUtil", (String)"188", (Object)this, (Object[])new Object[]{configuredURI});
                    try {
                        pw.close();
                    }
                    catch (Throwable throwable) {
                        FFDCFilter.processException((Throwable)throwable, (String)"io.openliberty.jcache.utils.CacheConfigUtil", (String)"188", (Object)this, (Object[])new Object[]{configuredURI});
                        lines.addSuppressed(throwable);
                    }
                    throw lines;
                }
                out.close();
            }
            catch (Throwable pw) {
                FFDCFilter.processException((Throwable)pw, (String)"io.openliberty.jcache.utils.CacheConfigUtil", (String)"188", (Object)this, (Object[])new Object[]{configuredURI});
                try {
                    out.close();
                }
                catch (Throwable lines) {
                    FFDCFilter.processException((Throwable)lines, (String)"io.openliberty.jcache.utils.CacheConfigUtil", (String)"188", (Object)this, (Object[])new Object[]{configuredURI});
                    pw.addSuppressed(lines);
                }
                throw pw;
            }
            Tr.info((TraceComponent)tc, (String)"SESN0310_GEN_INFINISPAN_CONFIG", (Object[])new Object[]{sw.toString()});
            return this.tempConfigFile.toURI();
        }
        try {
            int i;
            Object element;
            URLConnection con = configuredURI.toURL().openConnection();
            DocumentBuilder docbuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document doc = docbuilder.parse(con.getInputStream());
            LinkedList<Object> cacheContainers = new LinkedList<Object>();
            LinkedList<Node> elements = new LinkedList<Node>();
            elements.add(doc);
            while ((element = (Node)elements.poll()) != null) {
                NamedNodeMap attributes;
                NodeList nodeList = element.getChildNodes();
                for (int i2 = nodeList.getLength() - 1; i2 >= 0; --i2) {
                    Node child = nodeList.item(i2);
                    if (child.getNodeType() != 1) continue;
                    elements.add(child);
                }
                String elementName = element.getNodeName().toLowerCase();
                if ("cache-container".equalsIgnoreCase(elementName)) {
                    cacheContainers.add(element);
                }
                if ((attributes = element.getAttributes()) == null) continue;
                for (i = attributes.getLength() - 1; i >= 0; --i) {
                    String regex;
                    Pattern pattern;
                    String nameValue;
                    Node nameAttribute = attributes.getNamedItem("name");
                    if (nameAttribute == null || (nameValue = nameAttribute.getNodeValue()) == null || !elementName.endsWith("-cache") && !elementName.endsWith("-cache-configuration") || !(pattern = Pattern.compile(regex = this.infinispanCacheNameToRegEx(nameValue))).matcher("com.ibm.ws.session.attr.").matches() && !pattern.matcher("com.ibm.ws.session.meta.").matches()) continue;
                    if (trace && tc.isDebugEnabled()) {
                        Tr.debug((Object)this, (TraceComponent)tc, (String)("No changes due to " + elementName + " name=" + nameValue), (Object[])new Object[0]);
                    }
                    return configuredURI;
                }
            }
            for (Node node : cacheContainers) {
                Element replicatedCacheConfig = doc.createElement("replicated-cache-configuration");
                Attr nameAttribute = doc.createAttribute("name");
                nameAttribute.setNodeValue("com.ibm.ws.session.*");
                replicatedCacheConfig.setAttributeNode(nameAttribute);
                node.appendChild(replicatedCacheConfig);
            }
            if (cacheContainers.isEmpty()) {
                if (trace && tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)"No cache-container was found", (Object[])new Object[0]);
                }
                return configuredURI;
            }
            this.tempConfigFile = File.createTempFile("infinispan", ".xml");
            this.tempConfigFile.setReadable(true);
            this.tempConfigFile.setWritable(true);
            this.tempConfigFile.deleteOnExit();
            StreamResult uriResult = new StreamResult(new FileOutputStream(this.tempConfigFile));
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            DOMSource source = new DOMSource(doc);
            transformer.transform(source, uriResult);
            if (trace && tc.isDebugEnabled()) {
                NodeList allElements = doc.getElementsByTagName("*");
                for (i = allElements.getLength() - 1; i >= 0; --i) {
                    NamedNodeMap attrs;
                    Node element2 = allElements.item(i);
                    String elementName = element2.getNodeName();
                    if ("jgroups".equals(elementName) || "stack".equals(elementName) || "stack-file".equals(elementName) || "transport".equals(elementName) || elementName.endsWith("-cache") || elementName.endsWith("-cache-configuration") || (attrs = element2.getAttributes()) == null) continue;
                    for (int j = attrs.getLength() - 1; j >= 0; --j) {
                        Node attr = attrs.item(j);
                        attr.setNodeValue("***");
                    }
                }
                StringWriter sw = new StringWriter();
                StreamResult loggableResult = new StreamResult(sw);
                transformer.transform(source, loggableResult);
                Tr.debug((Object)this, (TraceComponent)tc, (String)"generateOrUpdateInfinispanConfig", (Object[])new Object[]{this.tempConfigFile, sw.toString()});
            }
            return this.tempConfigFile.toURI();
        }
        catch (ParserConfigurationException | TransformerException | SAXException con) {
            FFDCFilter.processException((Throwable)con, (String)"io.openliberty.jcache.utils.CacheConfigUtil", (String)"317", (Object)this, (Object[])new Object[]{configuredURI});
            if (trace && tc.isDebugEnabled()) {
                void x;
                Tr.debug((Object)this, (TraceComponent)tc, (String)"unable to enhance Infinispan config", (Object[])new Object[]{x});
            }
            return configuredURI;
        }
    }

    private String infinispanCacheNameToRegEx(String s) {
        int len = s.length();
        StringBuilder regex = new StringBuilder(len + 5);
        int start = 0;
        int i = 0;
        while ((i = s.indexOf(42, i)) >= 0) {
            String part = s.substring(start, i);
            if (part.length() > 0) {
                regex.append("\\Q").append(part).append("\\E");
            }
            regex.append(".*");
            start = i + 1;
            ++i;
        }
        if (start < len) {
            regex.append("\\Q").append(s.substring(start)).append("\\E");
        }
        return regex.toString();
    }
}

