/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.matching;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.sib.processor.matching.MPGroup;
import com.ibm.ws.sib.processor.matching.TopicAcl;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class TopicAclTraversalResults {
    private static final TraceComponent tc = SibTr.register(TopicAclTraversalResults.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    MPGroup everyone = new MPGroup("everyone");
    MPGroup allAuthenticated = new MPGroup("allauthenticated");
    public List levelUsersAllowedToSubscribe = new ArrayList();
    public List levelUsersAllowedToPublish = new ArrayList();
    public List accumUsersAllowedToSubscribe = new ArrayList();
    public List accumUsersAllowedToPublish = new ArrayList();
    public List levelGroupAllowedToSubscribe = new ArrayList();
    public List levelGroupAllowedToPublish = new ArrayList();
    public List accumGroupAllowedToSubscribe = new ArrayList();
    public List accumGroupAllowedToPublish = new ArrayList();

    public void reset() {
        this.accumUsersAllowedToSubscribe.clear();
        this.accumUsersAllowedToPublish.clear();
        this.accumGroupAllowedToSubscribe.clear();
        this.accumGroupAllowedToPublish.clear();
    }

    public void consolidate(List targets) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"consolidate", (Object)targets);
        }
        Iterator itr = targets.iterator();
        this.levelUsersAllowedToSubscribe.clear();
        this.levelUsersAllowedToPublish.clear();
        this.levelGroupAllowedToSubscribe.clear();
        this.levelGroupAllowedToPublish.clear();
        while (itr.hasNext()) {
            Object target = itr.next();
            if (!(target instanceof TopicAcl)) continue;
            Principal principal = ((TopicAcl)((Object)target)).getPrincipal();
            if (((TopicAcl)((Object)target)).getOperationType() == 1) {
                if (principal == null) {
                    this.accumUsersAllowedToPublish.clear();
                    this.accumGroupAllowedToPublish.clear();
                    continue;
                }
                if (principal instanceof MPGroup) {
                    this.levelGroupAllowedToPublish.add(principal);
                    continue;
                }
                this.levelUsersAllowedToPublish.add(principal);
                continue;
            }
            if (principal == null) {
                this.accumUsersAllowedToSubscribe.clear();
                this.accumGroupAllowedToSubscribe.clear();
                continue;
            }
            if (principal instanceof MPGroup) {
                this.levelGroupAllowedToSubscribe.add(principal);
                continue;
            }
            this.levelUsersAllowedToSubscribe.add(principal);
        }
        if (!this.levelUsersAllowedToSubscribe.isEmpty()) {
            this.accumUsersAllowedToSubscribe.addAll(this.levelUsersAllowedToSubscribe);
        }
        if (!this.levelUsersAllowedToPublish.isEmpty()) {
            this.accumUsersAllowedToPublish.addAll(this.levelUsersAllowedToPublish);
        }
        if (!this.levelGroupAllowedToSubscribe.isEmpty()) {
            this.accumGroupAllowedToSubscribe.addAll(this.levelGroupAllowedToSubscribe);
        }
        if (!this.levelGroupAllowedToPublish.isEmpty()) {
            this.accumGroupAllowedToPublish.addAll(this.levelGroupAllowedToPublish);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"consolidate");
        }
    }

    public boolean checkPermission(Principal user, int operation) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"checkPermission", (Object)new Object[]{user, new Integer(operation)});
        }
        boolean allowed = false;
        if (operation == 1) {
            if (this.accumGroupAllowedToPublish.size() > 0 && this.accumGroupAllowedToPublish.contains(this.everyone)) {
                allowed = true;
            } else if (user.getName() != null && user.getName().length() > 0) {
                if (this.accumUsersAllowedToPublish.size() > 0 && this.accumUsersAllowedToPublish.contains(user)) {
                    allowed = true;
                } else if (this.accumGroupAllowedToPublish.size() > 0) {
                    if (this.accumGroupAllowedToPublish.contains(this.allAuthenticated)) {
                        allowed = true;
                    } else {
                        for (MPGroup group : this.accumGroupAllowedToPublish) {
                            if (!group.isMember(user)) continue;
                            allowed = true;
                            break;
                        }
                    }
                }
            }
        } else if (this.accumGroupAllowedToSubscribe.size() > 0 && this.accumGroupAllowedToSubscribe.contains(this.everyone)) {
            allowed = true;
        } else if (user.getName() != null && user.getName().length() > 0) {
            if (this.accumUsersAllowedToSubscribe.size() > 0 && this.accumUsersAllowedToSubscribe.contains(user)) {
                allowed = true;
            } else if (this.accumGroupAllowedToSubscribe.size() > 0) {
                if (this.accumGroupAllowedToSubscribe.contains(this.allAuthenticated)) {
                    allowed = true;
                } else {
                    for (MPGroup group : this.accumGroupAllowedToSubscribe) {
                        if (!group.isMember(user)) continue;
                        allowed = true;
                        break;
                    }
                }
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"checkPermission", (Object)new Boolean(allowed));
        }
        return allowed;
    }
}

