/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cache.servlet;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.cache.servlet.ESICacheEntryStats;
import com.ibm.ws.cache.servlet.ESIProcessor;
import com.ibm.ws.cache.servlet.ESIProcessorRequest;
import java.io.IOException;
import java.util.LinkedList;

public class ESIProcessorStats
extends ESIProcessorRequest {
    private static final TraceComponent _tc = Tr.register(ESIProcessorStats.class, (String)"WebSphere Dynamic Cache", (String)"com.ibm.ws.cache.resources.dynacache");
    private int _gatherWhat;
    private String _hostName = null;
    private int _pid = -1;
    private int _cacheHits = -1;
    private int _cacheMissesByUrl = -1;
    private int _cacheMissesById = -1;
    private int _cacheExpires = -1;
    private int _cachePurges = -1;
    private LinkedList _cacheEntryStats = new LinkedList();

    public ESIProcessorStats(ESIProcessor processor, int gatherWhat) {
        super(processor);
        this._gatherWhat = gatherWhat;
        this._hostName = processor.getHostName();
        this._pid = processor.getPID();
        if (_tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)_tc, (String)("constructor " + processor), (Object[])new Object[0]);
        }
    }

    public String getHostName() {
        return this._hostName;
    }

    public int getPID() {
        return this._pid;
    }

    public int getCacheHits() {
        return this._cacheHits;
    }

    public void setCacheHits(int hits) {
        this._cacheHits = hits;
        if (_tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)_tc, (String)("setCacheHits " + hits), (Object[])new Object[0]);
        }
    }

    public int getCacheMissesByUrl() {
        return this._cacheMissesByUrl;
    }

    public void setCacheMissesByUrl(int misses) {
        this._cacheMissesByUrl = misses;
        if (_tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)_tc, (String)("setCacheMissesByUrl " + misses), (Object[])new Object[0]);
        }
    }

    public int getCacheMissesById() {
        return this._cacheMissesById;
    }

    public void setCacheMissesById(int misses) {
        this._cacheMissesById = misses;
        if (_tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)_tc, (String)("setCacheMissesById " + misses), (Object[])new Object[0]);
        }
    }

    public int getCacheExpires() {
        return this._cacheExpires;
    }

    public void setCacheExpires(int expires) {
        this._cacheExpires = expires;
        if (_tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)_tc, (String)("setCacheExpires " + expires), (Object[])new Object[0]);
        }
    }

    public int getCachePurges() {
        return this._cachePurges;
    }

    public void setCachePurges(int purges) {
        this._cachePurges = purges;
        if (_tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)_tc, (String)("setCachePurges " + purges), (Object[])new Object[0]);
        }
    }

    public void addCacheEntryStats(ESICacheEntryStats cacheEntry) {
        this._cacheEntryStats.add(cacheEntry);
    }

    public ESICacheEntryStats[] getCacheEntryStats() {
        return this._cacheEntryStats.toArray(new ESICacheEntryStats[0]);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void handle() throws IOException {
        if (_tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)_tc, (String)("submitting gather request for " + this._gatherWhat), (Object[])new Object[0]);
        }
        this.writeInt(2);
        this.writeInt(this._gatherWhat);
        this.flush();
        int repType = this.readInt();
        if (repType != 2) {
            throw new IOException("expecting gather reply from " + this + "; read " + repType);
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)_tc, (String)("waiting for gather response from " + this), (Object[])new Object[0]);
        }
        block9: while (true) {
            repType = this.readInt();
            switch (repType) {
                case 7: {
                    this.setCacheHits(this.readInt());
                    continue block9;
                }
                case 8: {
                    this.setCacheMissesByUrl(this.readInt());
                    continue block9;
                }
                case 9: {
                    this.setCacheMissesById(this.readInt());
                    continue block9;
                }
                case 10: {
                    this.setCacheExpires(this.readInt());
                    continue block9;
                }
                case 11: {
                    this.setCachePurges(this.readInt());
                    continue block9;
                }
                case 12: {
                    ESICacheEntryStats ces = new ESICacheEntryStats();
                    ces.setCacheId(this.readString());
                    this.addCacheEntryStats(ces);
                    int endType = this.readInt();
                    if (endType != 6) throw new IOException("expecting end of cache entry; read " + endType);
                    continue block9;
                }
                case 6: {
                    if (!_tc.isDebugEnabled()) return;
                    Tr.debug((TraceComponent)_tc, (String)("successful gather response from " + this), (Object[])new Object[0]);
                    return;
                }
            }
            break;
        }
        throw new IOException("invalid gather response from " + this + ": " + repType);
    }
}

