/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.runtime;

import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.wsspi.webcontainer.WCCustomProperties;
import jakarta.el.ArrayELResolver;
import jakarta.el.BeanELResolver;
import jakarta.el.CompositeELResolver;
import jakarta.el.ELContext;
import jakarta.el.ELContextEvent;
import jakarta.el.ELContextListener;
import jakarta.el.ELResolver;
import jakarta.el.ExpressionFactory;
import jakarta.el.ListELResolver;
import jakarta.el.MapELResolver;
import jakarta.el.ResourceBundleELResolver;
import jakarta.servlet.ServletContext;
import jakarta.servlet.jsp.JspApplicationContext;
import jakarta.servlet.jsp.JspContext;
import jakarta.servlet.jsp.el.ImplicitObjectELResolver;
import jakarta.servlet.jsp.el.ScopedAttributeELResolver;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.jasper.el.ELContextImpl;

@TraceObjectField(fieldName="logger", fieldDesc="Ljava/util/logging/Logger;")
public class JspApplicationContextImpl
implements JspApplicationContext {
    private static final String KEY = JspApplicationContextImpl.class.getName();
    protected static final Logger logger = Logger.getLogger("com.ibm.ws.jsp");
    protected final ExpressionFactory expressionFactory;
    private static final ExpressionFactory staticExpressionFactory = ExpressionFactory.newInstance();
    private final List<ELContextListener> contextListeners;
    private final List<ELResolver> resolvers;
    private boolean instantiated;
    protected boolean listenersContextInitialized;
    private ELResolver resolver;
    static final long serialVersionUID = 7142386168693508766L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public JspApplicationContextImpl() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("org.apache.jasper.runtime.JspApplicationContextImpl", "<init>", new Object[0]);
        }
        this.contextListeners = new ArrayList<ELContextListener>();
        this.resolvers = new ArrayList<ELResolver>();
        this.instantiated = false;
        this.listenersContextInitialized = false;
        if (!WCCustomProperties.ALLOW_EXPRESSION_FACTORY_PER_APP) {
            logger.logp(Level.FINE, KEY, "JspApplicationContextImpl", "Setting expressionFactory to the expression factory of the first loaded application.");
            this.expressionFactory = staticExpressionFactory;
        } else {
            logger.logp(Level.FINE, KEY, "JspApplicationContextImpl", "Setting expressionFactory to a new instance of ExpressionFactory.");
            this.expressionFactory = ExpressionFactory.newInstance();
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("org.apache.jasper.runtime.JspApplicationContextImpl", "<init>", this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void addELContextListener(ELContextListener listener) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("org.apache.jasper.runtime.JspApplicationContextImpl", "addELContextListener", new Object[]{listener});
        }
        if (listener == null) {
            throw new IllegalArgumentException("ELConextListener was null");
        }
        this.contextListeners.add(listener);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("org.apache.jasper.runtime.JspApplicationContextImpl", "addELContextListener");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static JspApplicationContextImpl getInstance(ServletContext context) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("org.apache.jasper.runtime.JspApplicationContextImpl", "getInstance", new Object[]{context});
        }
        if (context == null) {
            throw new IllegalArgumentException("ServletContext was null");
        }
        JspApplicationContextImpl impl = (JspApplicationContextImpl)context.getAttribute(KEY);
        if (impl == null) {
            impl = new JspApplicationContextImpl();
            context.setAttribute(KEY, (Object)impl);
        }
        if (WCCustomProperties.THROW_EXCEPTION_FOR_ADDELRESOLVER && context.getAttribute("com.ibm.ws.jsp.servletContextListeners.contextInitialized") != null) {
            impl.listenersContextInitialized = true;
        }
        JspApplicationContextImpl jspApplicationContextImpl = impl;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            jspApplicationContextImpl = jspApplicationContextImpl;
            logger.exiting("org.apache.jasper.runtime.JspApplicationContextImpl", "getInstance", jspApplicationContextImpl);
        }
        return jspApplicationContextImpl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public ELContextImpl createELContext(JspContext context) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("org.apache.jasper.runtime.JspApplicationContextImpl", "createELContext", new Object[]{context});
        }
        if (context == null) {
            throw new IllegalArgumentException("JspContext was null");
        }
        ELResolver r = this.createELResolver();
        ELContextImpl ctx = new ELContextImpl(r);
        ctx.putContext(JspContext.class, (Object)context);
        ELContextEvent event = new ELContextEvent((ELContext)ctx);
        for (int i = 0; i < this.contextListeners.size(); ++i) {
            this.contextListeners.get(i).contextCreated(event);
        }
        ELContextImpl eLContextImpl = ctx;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            eLContextImpl = eLContextImpl;
            logger.exiting("org.apache.jasper.runtime.JspApplicationContextImpl", "createELContext", eLContextImpl);
        }
        return eLContextImpl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private ELResolver createELResolver() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("org.apache.jasper.runtime.JspApplicationContextImpl", "createELResolver", new Object[0]);
        }
        this.instantiated = true;
        if (this.resolver == null) {
            CompositeELResolver r = new CompositeELResolver();
            r.add((ELResolver)new ImplicitObjectELResolver());
            Iterator<ELResolver> itr = this.resolvers.iterator();
            while (itr.hasNext()) {
                r.add(itr.next());
            }
            r.add((ELResolver)new MapELResolver());
            r.add((ELResolver)new ResourceBundleELResolver());
            r.add((ELResolver)new ListELResolver());
            r.add((ELResolver)new ArrayELResolver());
            r.add((ELResolver)new BeanELResolver());
            r.add((ELResolver)new ScopedAttributeELResolver());
            this.resolver = r;
        }
        ELResolver eLResolver = this.resolver;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            eLResolver = eLResolver;
            logger.exiting("org.apache.jasper.runtime.JspApplicationContextImpl", "createELResolver", eLResolver);
        }
        return eLResolver;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void addELResolver(ELResolver resolver) throws IllegalStateException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("org.apache.jasper.runtime.JspApplicationContextImpl", "addELResolver", new Object[]{resolver});
        }
        if (resolver == null) {
            throw new IllegalArgumentException("ELResolver was null");
        }
        if (this.instantiated || this.listenersContextInitialized) {
            throw new IllegalStateException("cannot call addELResolver after the first request has been made");
        }
        this.resolvers.add(resolver);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("org.apache.jasper.runtime.JspApplicationContextImpl", "addELResolver");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public ExpressionFactory getExpressionFactory() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("org.apache.jasper.runtime.JspApplicationContextImpl", "getExpressionFactory", new Object[0]);
        }
        ExpressionFactory expressionFactory = this.expressionFactory;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            expressionFactory = expressionFactory;
            logger.exiting("org.apache.jasper.runtime.JspApplicationContextImpl", "getExpressionFactory", expressionFactory);
        }
        return expressionFactory;
    }
}

