/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.impl.store.items;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.Reliability;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.mfp.JsMessage;
import com.ibm.ws.sib.msgstore.Item;
import com.ibm.ws.sib.msgstore.ItemReference;
import com.ibm.ws.sib.msgstore.ItemStream;
import com.ibm.ws.sib.msgstore.MessageStoreException;
import com.ibm.ws.sib.msgstore.ReferenceStream;
import com.ibm.ws.sib.msgstore.SevereMessageStoreException;
import com.ibm.ws.sib.msgstore.transactions.Transaction;
import com.ibm.ws.sib.processor.impl.BaseDestinationHandler;
import com.ibm.ws.sib.processor.impl.interfaces.DestinationHandler;
import com.ibm.ws.sib.processor.impl.interfaces.MessageEventListener;
import com.ibm.ws.sib.processor.impl.interfaces.SIMPMessage;
import com.ibm.ws.sib.processor.impl.store.items.MessageEventListeners;
import com.ibm.ws.sib.processor.impl.store.items.MessageItem;
import com.ibm.ws.sib.processor.impl.store.itemstreams.DurableSubscriptionItemStream;
import com.ibm.ws.sib.processor.impl.store.itemstreams.MessageReferenceStream;
import com.ibm.ws.sib.processor.impl.store.itemstreams.ProxyReferenceStream;
import com.ibm.ws.sib.processor.impl.store.itemstreams.PubSubMessageItemStream;
import com.ibm.ws.sib.processor.impl.store.itemstreams.SIMPItemStream;
import com.ibm.ws.sib.processor.matching.MessageProcessorSearchResults;
import com.ibm.ws.sib.processor.runtime.impl.ControlAdapter;
import com.ibm.ws.sib.processor.runtime.impl.QueuedMessage;
import com.ibm.ws.sib.transactions.TransactionCallback;
import com.ibm.ws.sib.transactions.TransactionCommon;
import com.ibm.ws.sib.utils.DataSlice;
import com.ibm.ws.sib.utils.SIBUuid12;
import com.ibm.ws.sib.utils.SIBUuid8;
import com.ibm.ws.sib.utils.ras.FormattedWriter;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.io.IOException;
import java.util.List;

public final class MessageItemReference
extends ItemReference
implements SIMPMessage,
TransactionCallback {
    private boolean requiresNewId = false;
    private static TraceComponent tc = SibTr.register(MessageItemReference.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private MessageProcessorSearchResults searchResults;
    private ControlAdapter controlAdapter = null;
    private MessageEventListener PRE_COMMIT_ADD;
    private MessageEventListener PRE_COMMIT_REMOVE;
    private MessageEventListener REFERENCES_DROPPED_TO_ZERO;
    private final MessageEventListeners postCommitAddListeners = new MessageEventListeners(2, 2);
    private final MessageEventListeners postCommitRemoveListeners = new MessageEventListeners(3, 5);
    private final MessageEventListeners postRollbackAddListeners = new MessageEventListeners(4, 2);
    private final MessageEventListeners postRollbackRemoveListeners = new MessageEventListeners(5, 5);
    private final MessageEventListeners preUnlockedListeners = new MessageEventListeners(12, 2);
    private final MessageEventListeners unlockedListeners = new MessageEventListeners(6, 4);
    private boolean downgradePersistence = false;
    private boolean streamIsGuess = false;
    private boolean reavailable = false;
    private boolean redeliveryCountReached = false;
    private SIBUuid8 localisingMEUuid;
    private long rmeUnlockCount = 0L;
    private JsMessage jsMsg;
    private boolean failedInitInRestore = false;
    private MessageReferenceStream stream;

    public MessageItemReference() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"MessageItemReference");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"MessageItemReference");
        }
    }

    public MessageItemReference(MessageItem msg) {
        this(msg, false);
    }

    public MessageItemReference(MessageItem msg, boolean downgradePersistence) {
        super((Item)msg);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"MessageItemReference", (Object)new Object[]{msg, downgradePersistence});
        }
        this.getMessage();
        this.downgradePersistence = downgradePersistence;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"MessageItemReference", (Object)this);
        }
    }

    @Override
    public boolean getRequiresNewId() {
        return this.requiresNewId;
    }

    @Override
    public void setRequiresNewId(boolean value) {
        this.requiresNewId = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JsMessage getMessage() {
        JsMessage localMsg;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getMessage");
        }
        if ((localMsg = this.jsMsg) == null) {
            MessageItemReference messageItemReference = this;
            synchronized (messageItemReference) {
                localMsg = this.jsMsg = this.getMessageItem().getMessage();
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getMessage", (Object)localMsg);
        }
        return localMsg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JsMessage getMessageIfAvailable() {
        JsMessage localMsg;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getMessageIfAvailable");
        }
        if ((localMsg = this.jsMsg) == null) {
            MessageItemReference messageItemReference = this;
            synchronized (messageItemReference) {
                localMsg = this.jsMsg = this.getMessageItem().getMessageIfAvailable();
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getMessageIfAvailable", (Object)localMsg);
        }
        return localMsg;
    }

    public int getStorageStrategy() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getStorageStrategy");
        }
        int storageStrat = this.getMessageItem().getStorageStrategy();
        if (this.downgradePersistence && storageStrat > 2) {
            storageStrat = 2;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getStorageStrategy", (Object)storageStrat);
        }
        return storageStrat;
    }

    @Override
    public Reliability getReliability() {
        return this.getMessageItem().getReliability();
    }

    public long getMaximumTimeInStore() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getMaximumTimeInStore");
        }
        long maxTime = this.getMessageItem().getMaximumTimeInStore();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getMaximumTimeInStore", (Object)new Long(maxTime));
        }
        return maxTime;
    }

    public void eventPostCommitAdd(Transaction transaction) throws SevereMessageStoreException {
        super.eventPostCommitAdd(transaction);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"eventPostCommitAdd", (Object)new Object[]{transaction});
        }
        if (this.getMessageItem().getRegisterForPostEvents() || this.failedInitInRestore) {
            this.stream = (MessageReferenceStream)this.getReferenceStream();
            if (this.stream instanceof DurableSubscriptionItemStream || this.stream instanceof ProxyReferenceStream) {
                this.stream.registerListeners(this);
            }
            this.failedInitInRestore = false;
            this.getMessageItem().setRegisterForPostEvents(this.failedInitInRestore);
        }
        if (!transaction.isAutoCommit()) {
            try {
                this.postCommitAddListeners.messageEventOccurred(this, transaction);
            }
            catch (SIException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.store.items.MessageItemReference.eventPostCommitAdd", (String)"1:422:1.147", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"eventPostCommitAdd", (Object)((Object)e));
                }
                throw new SIErrorException((Throwable)e);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"eventPostCommitAdd");
        }
    }

    public void eventPostCommitRemove(Transaction transaction) throws SevereMessageStoreException {
        super.eventPostCommitRemove(transaction);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"eventPostCommitRemove");
        }
        if (this.failedInitInRestore) {
            if (this.stream instanceof DurableSubscriptionItemStream) {
                this.stream.registerListeners(this);
            }
            this.failedInitInRestore = false;
        }
        this.dereferenceControlAdapter();
        try {
            this.postCommitRemoveListeners.messageEventOccurred(this, transaction);
        }
        catch (SIException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.store.items.MessageItemReference.eventPostCommitRemove", (String)"1:482:1.147", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"eventPostCommitRemove", (Object)((Object)e));
            }
            throw new SIErrorException((Throwable)e);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"eventPostCommitRemove");
        }
    }

    public void eventPostRollbackRemove(Transaction transaction) throws SevereMessageStoreException {
        super.eventPostRollbackRemove(transaction);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"eventPostRollbackRemove", (Object)new Object[]{transaction});
        }
        if (this.failedInitInRestore) {
            if (this.stream instanceof DurableSubscriptionItemStream) {
                this.stream.registerListeners(this);
            }
            this.failedInitInRestore = false;
        }
        try {
            this.postRollbackRemoveListeners.messageEventOccurred(this, transaction);
        }
        catch (SIException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.store.items.MessageItemReference.eventPostRollbackRemove", (String)"1:553:1.147", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"eventPostRollbackRemove", (Object)((Object)e));
            }
            throw new SIErrorException((Throwable)e);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"eventPostRollbackRemove");
        }
    }

    private void resetEvents() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"resetEvents");
        }
        this.PRE_COMMIT_ADD = null;
        this.PRE_COMMIT_REMOVE = null;
        this.postCommitAddListeners.reset();
        this.postCommitRemoveListeners.reset();
        this.postRollbackAddListeners.reset();
        this.postRollbackRemoveListeners.reset();
        this.unlockedListeners.reset();
        this.preUnlockedListeners.reset();
        this.REFERENCES_DROPPED_TO_ZERO = null;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"resetEvents");
        }
    }

    public void eventPostRollbackAdd(Transaction transaction) throws SevereMessageStoreException {
        super.eventPostRollbackAdd(transaction);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"eventPostRollbackAdd", (Object)transaction);
        }
        if (this.getMessageItem().getRegisterForPostEvents() || this.failedInitInRestore) {
            this.stream = (MessageReferenceStream)this.getReferenceStream();
            if (this.stream instanceof DurableSubscriptionItemStream || this.stream instanceof ProxyReferenceStream) {
                this.stream.registerListeners(this);
            }
            this.failedInitInRestore = false;
            this.getMessageItem().setRegisterForPostEvents(this.failedInitInRestore);
        }
        try {
            this.postRollbackAddListeners.messageEventOccurred(this, transaction);
        }
        catch (SIException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.store.items.MessageItemReference.eventPostRollbackAdd", (String)"1:641:1.147", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"eventPostRollbackAdd", (Object)((Object)e));
            }
            throw new SIErrorException((Throwable)e);
        }
        this.resetEvents();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"eventPostRollbackAdd");
        }
    }

    @Override
    public void eventUnlocked() throws SevereMessageStoreException {
        super.eventUnlocked();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"eventUnlocked");
        }
        if (this.failedInitInRestore) {
            if (this.stream instanceof DurableSubscriptionItemStream) {
                this.stream.registerListeners(this);
            }
            this.failedInitInRestore = false;
        }
        this.reavailable = true;
        try {
            this.unlockedListeners.messageEventOccurred(this, null);
        }
        catch (SIException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.store.items.MessageItemReference.eventUnlocked", (String)"1:574:1.106", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"eventUnlocked", (Object)((Object)e));
            }
            throw new SIErrorException((Throwable)e);
        }
        this.reavailable = false;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"eventUnlocked");
        }
    }

    @Override
    public void eventLocked() {
    }

    @Override
    public SIBUuid12 getProducerConnectionUuid() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getProducerConnectionUuid");
            SibTr.exit((TraceComponent)tc, (String)"getProducerConnectionUuid");
        }
        return this.getMessageItem().getProducerConnectionUuid();
    }

    @Override
    public String toString() {
        MessageItem msg;
        block2: {
            msg = null;
            try {
                msg = (MessageItem)this.getReferredItem();
            }
            catch (SevereMessageStoreException e) {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block2;
                SibTr.debug((TraceComponent)tc, (String)"toString error when obtaining referred item", (Object)((Object)e));
            }
        }
        String text = "MessageItemReference@" + Integer.toHexString(this.hashCode()) + "[";
        text = msg != null ? text + msg.toString() + "]" : text + "NULL]";
        return text;
    }

    public void xmlWriteOn(FormattedWriter writer) throws IOException {
        try {
            MessageItem msgItem;
            JsMessage msg;
            ReferenceStream rs = this.getReferenceStream();
            if (rs instanceof ProxyReferenceStream && (msg = (msgItem = (MessageItem)this.getReferredItem()).getMessage()) != null) {
                writer.newLine();
                writer.startTag("xmitData");
                writer.indent();
                writer.newLine();
                writer.taggedValue("startTick", msg.getGuaranteedValueStartTick());
                writer.newLine();
                writer.taggedValue("endTick", msg.getGuaranteedValueEndTick());
                writer.newLine();
                writer.taggedValue("priority", (Object)msg.getPriority());
                writer.newLine();
                writer.taggedValue("reliability", (Object)msg.getReliability());
                writer.newLine();
                writer.taggedValue("streamId", (Object)msg.getGuaranteedStreamUUID());
                writer.outdent();
                writer.newLine();
                writer.endTag("xmitData");
            }
        }
        catch (SevereMessageStoreException severeMessageStoreException) {
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    private MessageItem getMessageItem() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getMessageItem");
        }
        MessageItem msg = null;
        try {
            msg = (MessageItem)this.getReferredItem();
        }
        catch (MessageStoreException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.store.items.MessageItemReference.getMessageItem", (String)"1:857:1.147", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"getMessageItem", (Object)((Object)e));
            }
            throw new SIErrorException((Throwable)e);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getMessageItem", (Object)msg);
        }
        return msg;
    }

    @Override
    public boolean isTransacted() {
        return this.getMessageItem().isTransacted();
    }

    @Override
    public int getProducerSeed() {
        return this.getMessageItem().getProducerSeed();
    }

    public void restore(List<DataSlice> dataSlices) throws SevereMessageStoreException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"restore", dataSlices);
        }
        this.stream = (MessageReferenceStream)this.getReferenceStream();
        if (this.stream instanceof DurableSubscriptionItemStream) {
            if (!this.stream.hasInDoubtItems()) {
                this.stream.registerListeners(this);
                this.failedInitInRestore = false;
            } else {
                this.failedInitInRestore = true;
            }
        }
        if (this.isRemoving()) {
            this.stream.setCurrentTransaction(this, false);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"restore");
        }
    }

    @Override
    public void registerMessageEventListener(int event, MessageEventListener listener) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"registerMessageEventListener", (Object)new Object[]{event, listener});
        }
        boolean error = false;
        switch (event) {
            case 2: {
                this.postCommitAddListeners.add(listener);
                break;
            }
            case 3: {
                this.postCommitRemoveListeners.add(listener);
                break;
            }
            case 4: {
                this.postRollbackAddListeners.add(listener);
                break;
            }
            case 5: {
                this.postRollbackRemoveListeners.add(listener);
                break;
            }
            case 0: {
                if (this.PRE_COMMIT_ADD == null) {
                    this.PRE_COMMIT_ADD = listener;
                    break;
                }
                error = true;
                break;
            }
            case 1: {
                if (this.PRE_COMMIT_REMOVE == null) {
                    this.PRE_COMMIT_REMOVE = listener;
                    break;
                }
                error = true;
                break;
            }
            case 7: {
                if (this.REFERENCES_DROPPED_TO_ZERO == null) {
                    this.REFERENCES_DROPPED_TO_ZERO = listener;
                    break;
                }
                error = true;
                break;
            }
            case 6: {
                this.unlockedListeners.add(listener);
                break;
            }
            case 12: {
                this.preUnlockedListeners.add(listener);
            }
        }
        if (error) {
            SIErrorException e = new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.impl.store.items.MessageItemReference.registerMessageEventListener", "1:1013:1.147", event}, null));
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.store.items.MessageItemReference.registerMessageEventListener", (String)"1:1019:1.147", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.store.items.MessageItemReference.registerMessageEventListener", "1:1026:1.147", event});
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"registerMessageEventListener", (Object)((Object)e));
            }
            throw e;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"registerMessageEventListener");
        }
    }

    @Override
    public void deregisterMessageEventListener(int event, MessageEventListener listener) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"deregisterMessageEventListener", (Object)new Object[]{event, listener});
        }
        switch (event) {
            case 2: {
                this.postCommitAddListeners.remove(listener);
                break;
            }
            case 3: {
                this.postCommitRemoveListeners.remove(listener);
                break;
            }
            case 4: {
                this.postRollbackAddListeners.remove(listener);
                break;
            }
            case 5: {
                this.postRollbackRemoveListeners.remove(listener);
                break;
            }
            case 0: {
                if (this.PRE_COMMIT_ADD != listener) break;
                this.PRE_COMMIT_ADD = null;
                break;
            }
            case 1: {
                if (this.PRE_COMMIT_REMOVE != listener) break;
                this.PRE_COMMIT_REMOVE = null;
                break;
            }
            case 7: {
                if (this.REFERENCES_DROPPED_TO_ZERO != listener) break;
                this.REFERENCES_DROPPED_TO_ZERO = null;
                break;
            }
            case 6: {
                this.unlockedListeners.remove(listener);
                break;
            }
            case 12: {
                this.preUnlockedListeners.remove(listener);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"deregisterMessageEventListener");
        }
    }

    public MessageProcessorSearchResults getSearchResults() {
        return this.searchResults;
    }

    public void setSearchResults(MessageProcessorSearchResults list) {
        this.searchResults = list;
    }

    @Override
    public long calculateWaitTimeUpdate(long timeNow) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"calculateWaitTimeUpdate");
        }
        long calculatedWaitTime = this.getMessageItem().calculateWaitTimeUpdate(timeNow);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"calculateWaitTimeUpdate", (Object)calculatedWaitTime);
        }
        return calculatedWaitTime;
    }

    @Override
    public long getAggregateWaitTime() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getAggregateWaitTime");
        }
        long aggregateMessageWaitTime = this.getLatestWaitTimeUpdate() + this.getMessageItem().getAggregateWaitTime();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getAggregateWaitTime", (Object)aggregateMessageWaitTime);
        }
        return aggregateMessageWaitTime;
    }

    @Override
    public long getLatestWaitTimeUpdate() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getLatestWaitTimeUpdate");
        }
        long timeNow = System.currentTimeMillis();
        long localWaitTime = timeNow - this.getMessageItem().getCurrentMEArrivalTimestamp();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getLatestWaitTimeUpdate", (Object)localWaitTime);
        }
        return localWaitTime;
    }

    @Override
    public boolean isToBeStoredAtSendTime() {
        return false;
    }

    @Override
    public void setStoreAtSendTime(boolean store) {
    }

    @Override
    public void setStreamIsGuess(boolean streamIsGuess) {
        this.streamIsGuess = streamIsGuess;
    }

    @Override
    public boolean getStreamIsGuess() {
        return this.streamIsGuess;
    }

    @Override
    public ControlAdapter getControlAdapter() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getControlAdapter");
        }
        if (this.controlAdapter == null) {
            this.createControlAdapter();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getControlAdapter", (Object)this.controlAdapter);
        }
        return this.controlAdapter;
    }

    @Override
    public void createControlAdapter() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createControlAdapter");
        }
        BaseDestinationHandler dh = null;
        try {
            ItemStream is;
            ReferenceStream rs = this.getReferenceStream();
            if (rs instanceof MessageReferenceStream && (is = rs.getItemStream()) instanceof PubSubMessageItemStream) {
                dh = ((PubSubMessageItemStream)is).getDestinationHandler();
                this.controlAdapter = new QueuedMessage((SIMPMessage)this, (DestinationHandler)dh, rs);
            }
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.store.items.MessageItemReference.createControlAdapter", (String)"1:1266:1.147", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)e);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createControlAdapter");
        }
    }

    @Override
    public void registerControlAdapterAsMBean() {
    }

    @Override
    public void deregisterControlAdapterMBean() {
    }

    @Override
    public void dereferenceControlAdapter() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"dereferenceControlAdapter");
        }
        if (this.controlAdapter != null) {
            this.controlAdapter.dereferenceControllable();
            this.controlAdapter = null;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"dereferenceControlAdapter");
        }
    }

    @Override
    public SIBUuid12 getGuaranteedStreamUuid() {
        return this.getMessageItem().getGuaranteedStreamUuid();
    }

    @Override
    public void setGuaranteedStreamUuid(SIBUuid12 uuid) {
        this.getMessageItem().setGuaranteedStreamUuid(uuid);
    }

    @Override
    public Byte getReportCOD() {
        return this.getMessageItem().getReportCOD();
    }

    @Override
    public boolean isFromRemoteME() {
        return this.getMessageItem().isFromRemoteME();
    }

    @Override
    public long updateStatisticsMessageWaitTime() {
        return 0L;
    }

    public void beforeCompletion(TransactionCommon arg0) {
    }

    public void afterCompletion(TransactionCommon arg0, boolean arg1) {
        this.releaseJsMessage();
    }

    @Override
    public boolean isReavailable() {
        return this.reavailable;
    }

    @Override
    public int guessRedeliveredCount() {
        int count = 0;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"guessRedeliveredCount");
        }
        count = super.guessUnlockCount() + (int)this.rmeUnlockCount;
        try {
            count += super.getPersistedRedeliveredCount();
        }
        catch (MessageStoreException messageStoreException) {
            // empty catch block
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"guessRedeliveredCount", (Object)count);
        }
        return count;
    }

    public void eventRestored() throws SevereMessageStoreException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"eventRestored");
        }
        super.eventRestored();
        this.getMessageItem();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"eventRestored");
        }
    }

    @Override
    public void unlockMsg(long lockID, Transaction transaction, boolean incrementUnlock) throws MessageStoreException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"unlockMsg");
        }
        if (this.failedInitInRestore) {
            if (this.stream instanceof DurableSubscriptionItemStream) {
                this.stream.registerListeners(this);
            }
            this.failedInitInRestore = false;
        }
        if (incrementUnlock) {
            this.redeliveryCountReached = false;
            try {
                this.preUnlockedListeners.messageEventOccurred(this, transaction);
            }
            catch (SIException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.store.items.MessageItemReference.unlockMsg", (String)"1:1450:1.147", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                this.redeliveryCountReached = false;
            }
        }
        if (!this.redeliveryCountReached) {
            this.unlock(lockID, transaction, incrementUnlock);
            MessageItem item = this.getMessageItem();
            SIMPItemStream itemStream = (SIMPItemStream)item.getItemStream();
            BaseDestinationHandler bdh = item.getDestinationHandler(false, itemStream);
            if (bdh.isRedeliveryCountPersisted() && bdh.getMessageProcessor().getMessageStore().isRedeliveryCountColumnAvailable()) {
                this.persistRedeliveredCount(this.guessRedeliveredCount());
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"unlockMsg");
        }
    }

    public void persistRedeliveredCount(int redeliveredCount) throws SevereMessageStoreException {
        super.persistRedeliveredCount(redeliveredCount);
    }

    @Override
    public void setRedeliveryCountReached() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setRedeliveryCountReached");
            SibTr.exit((TraceComponent)tc, (String)"setRedeliveryCountReached");
        }
        this.redeliveryCountReached = true;
    }

    @Override
    public boolean isReference() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void releaseJsMessage() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"releaseJsMessage");
        }
        if (this.getReliability().compareTo((Object)Reliability.BEST_EFFORT_NONPERSISTENT) > 0 && this.isPersistentRepresentationStable()) {
            MessageItemReference messageItemReference = this;
            synchronized (messageItemReference) {
                this.jsMsg = null;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"releaseJsMessage");
        }
    }

    @Override
    public void markHiddenMessage(boolean hiddenMessage) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"markHiddenMessage", (Object)hiddenMessage);
        }
        this.getMessageItem().markHiddenMessage(hiddenMessage);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"markHiddenMessage");
        }
    }

    @Override
    public boolean isHidden() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isHidden");
        }
        boolean isHidden = this.getMessageItem().isHidden();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"isHidden", (Object)isHidden);
        }
        return isHidden;
    }

    @Override
    public void setHiddenExpiryTime(long expiryTime) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setHiddenExpiryTime", (Object)expiryTime);
        }
        this.getMessageItem().setHiddenExpiryTime(expiryTime);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setHiddenExpiryTime");
        }
    }

    @Override
    public long getHiddenExpiryTime() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getHiddenExpiryTime");
        }
        long hiddenExpiryTime = this.getMessageItem().getHiddenExpiryTime();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getHiddenExpiryTime", (Object)hiddenExpiryTime);
        }
        return hiddenExpiryTime;
    }

    @Override
    public SIBUuid8 getLocalisingMEUuid() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getLocalisingMEUuid");
            SibTr.exit((TraceComponent)tc, (String)"getLocalisingMEUuid", (Object)this.localisingMEUuid);
        }
        return this.localisingMEUuid;
    }

    @Override
    public void setLocalisingME(SIBUuid8 messagingEngineUuid) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setLocalisingME", (Object)messagingEngineUuid);
        }
        this.localisingMEUuid = messagingEngineUuid;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setLocalisingME");
        }
    }

    @Override
    public long getMessageWaitTime() {
        return 0L;
    }

    @Override
    public boolean isRemoteGet() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isRemoteGet");
            SibTr.exit((TraceComponent)tc, (String)"isRemoteGet", (Object)Boolean.FALSE);
        }
        return false;
    }

    @Override
    public void setMessageControlClassification(String classification) {
    }

    @Override
    public String getMessageControlClassification(boolean throwExceptionIfMessageNotAvailable) {
        return null;
    }

    @Override
    public void setRMEUnlockCount(long rmeUnlockCount) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setRMEUnlockCount", (Object)rmeUnlockCount);
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setRMEUnlockCount");
        }
        this.rmeUnlockCount += rmeUnlockCount;
    }

    public long getDeliveryDelay() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getDeliveryDelay");
        }
        long deliveryDelay = this.getMessageItem().getDeliveryDelay();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getDeliveryDelay", (Object)new Long(deliveryDelay));
        }
        return deliveryDelay;
    }
}

