/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.session;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.session.utils.LoggingUtil;
import com.ibm.wsspi.session.ISession;
import com.ibm.wsspi.session.IStore;
import com.ibm.wsspi.session.IStorer;
import com.ibm.wsspi.session.ITimer;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;

public class TBWSessionStorer
implements IStorer,
ITimer {
    private final Timer timer;

    public TBWSessionStorer(IStore store, int interval) {
        long attemptToWriteInterval = interval * 1000;
        TimeBasedWriteTask invalTask = new TimeBasedWriteTask(store);
        this.timer = new Timer(true);
        this.timer.schedule((TimerTask)invalTask, 0L, attemptToWriteInterval);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void storeSession(ISession session) {
        ISession iSession = session;
        synchronized (iSession) {
            session.flush(true);
        }
    }

    @Override
    public void storeSession(ISession session, boolean usesCookies) {
        this.storeSession(session);
    }

    @Override
    public void setStorageInterval(int interval) {
    }

    @Override
    public void start(IStore store, int interval) {
    }

    @Override
    public void stop() {
        this.timer.cancel();
    }

    protected static class TimeBasedWriteTask
    extends TimerTask {
        private final IStore store;

        public TimeBasedWriteTask(IStore store) {
            this.store = store;
        }

        @Override
        public void run() {
            if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
                LoggingUtil.SESSION_LOGGER_CORE.logp(Level.FINE, "TimeBasedWriteTask", "run", "running TBW for " + this.store.getId());
            }
            this.store.runTimeBasedWrites();
        }
    }
}

