/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.cache;

import com.ibm.websphere.cache.DistributedObjectCache;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.cache.CacheConfig;
import com.ibm.ws.cache.CacheService;
import com.ibm.ws.cache.CacheServiceImpl;
import com.ibm.ws.cache.DistributedMapImpl;
import com.ibm.ws.cache.DistributedNioMapImpl;
import com.ibm.ws.cache.ServerCache;
import com.ibm.ws.cache.intf.DCache;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;

public class DistributedObjectCacheFactory {
    private static TraceComponent tc = Tr.register(DistributedObjectCacheFactory.class, (String)"WebSphere Dynamic Cache", (String)"com.ibm.ws.cache.resources.dynacache");
    public static final String KEY_CACHE_SIZE = "com.ibm.ws.cache.CacheConfig.cacheSize";
    public static final String KEY_DISABLE_DEPENDENCY_ID = "com.ibm.ws.cache.CacheConfig.disableDependencyId";
    public static final String KEY_DISABLE_TEMPLATES_SUPPORT = "com.ibm.ws.cache.CacheConfig.disableTemplatesSupport";
    public static final String KEY_ENABLE_DISK_OFFLOAD = "com.ibm.ws.cache.CacheConfig.enableDiskOffload";
    public static final String KEY_ENABLE_NIO_SUPPORT = "com.ibm.ws.cache.CacheConfig.enableNioSupport";
    public static final String KEY_DISK_OFFLOAD_LOCATION = "com.ibm.ws.cache.CacheConfig.diskOffloadLocation";
    public static final String KEY_USE_LISTENER_CONTEXT = "com.ibm.ws.cache.CacheConfig.useListenerContext";
    public static final String KEY_FLUSH_TO_DISK_ON_STOP = "com.ibm.ws.cache.CacheConfig.flushToDiskOnStop";
    public static final String KEY_ENABLE_CACHE_REPLICATION = "com.ibm.ws.cache.CacheConfig.enableCacheReplication";
    public static final String KEY_REPLICATION_DOMAIN = "com.ibm.ws.cache.CacheConfig.replicationDomain";
    public static final String KEY_DISKCACHE_PERFORMANCE_LEVEL = "com.ibm.ws.cache.CacheConfig.diskCachePerformanceLevel";
    public static final String KEY_DISK_CLEANUP_FREQUENCY = "com.ibm.ws.cache.CacheConfig.htodCleanupFrequency";
    public static final String KEY_DISK_DELAY_OFFLOAD_ENTRIES_LIMIT = "com.ibm.ws.cache.CacheConfig.htodDelayOffloadEntriesLimit";
    public static final String KEY_DISK_DELAY_OFFLOAD_DEPID_BUCKETS = "com.ibm.ws.cache.CacheConfig.htodDelayOffloadDepIdBuckets";
    public static final String KEY_DISK_DELAY_OFFLOAD_TEMPLATE_BUCKETS = "com.ibm.ws.cache.CacheConfig.htodDelayOffloadTemplateBuckets";
    public static final String KEY_DISKCACHE_EVICTION_POLICY = "com.ibm.ws.cache.CacheConfig.diskCacheEvictionPolicy";
    public static final String KEY_DISKCACHE_HIGH_THRESHOLD = "com.ibm.ws.cache.CacheConfig.diskCacheHighThreshold";
    public static final String KEY_DISKCACHE_LOW_THRESHOLD = "com.ibm.ws.cache.CacheConfig.diskCacheLowThreshold";
    public static final String KEY_DISKCACHE_SIZE = "com.ibm.ws.cache.CacheConfig.diskCacheSize";
    public static final String KEY_DISKCACHE_SIZE_GB = "com.ibm.ws.cache.CacheConfig.diskCacheSizeInGB";
    public static final String KEY_DISKCACHE_ENTRY_SIZE_MB = "com.ibm.ws.cache.CacheConfig.diskCacheEntrySizeInMB";
    public static final String KEY_LRU_TO_DISK_TRIGGER_PERCENT = "com.ibm.ws.cache.CacheConfig.lruToDiskTriggerPercent";
    public static final String KEY_MEMORY_CACHE_SIZE_IN_MB = "com.ibm.ws.cache.CacheConfig.memoryCacheSizeInMB";
    public static final String KEY_MEMORY_CACHE_SIZE_HIGH_THRESHOLD = "com.ibm.ws.cache.CacheConfig.memoryCacheHighThreshold";
    public static final String KEY_MEMORY_CACHE_SIZE_LOW_THRESHOLD = "com.ibm.ws.cache.CacheConfig.memoryCacheLowThreshold";
    public static final String VALUE_TRUE = "true";
    public static final String VALUE_FALSE = "false";
    private static final Object distributedMapsSynchronizeObject = new Object();
    public static Map<String, DistributedObjectCache> distributedMaps = new ConcurrentHashMap<String, DistributedObjectCache>();
    private static CacheService cacheService = null;

    private DistributedObjectCacheFactory() {
    }

    public static DistributedObjectCache getMap(String name) {
        return DistributedObjectCacheFactory.getMap(name, new Properties());
    }

    public static DistributedObjectCache removeMap(String name) {
        if (tc.isDebugEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"removeMap", (Object[])new Object[]{name});
        }
        DistributedObjectCache cache = distributedMaps.remove(name);
        if (tc.isDebugEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"removeMap", (Object)cache);
        }
        return cache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DistributedObjectCache getMap(String name, Properties properties) {
        String methodName = "getMap()";
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getMap() name: (" + name + ") properties:" + properties), (Object[])new Object[0]);
        }
        if (name == null || name.trim().length() == 0) {
            throw new IllegalStateException("Map name can not be null or empty");
        }
        if (!ServerCache.objectCacheEnabled) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("getMap() WebSphere Dynamic Cache instance named " + name + " cannot be used because of Dynamic Object cache service has not be started."), (Object[])new Object[0]);
            }
            return null;
        }
        DistributedObjectCache distributedObjectCache = null;
        Object object = distributedMapsSynchronizeObject;
        synchronized (object) {
            distributedObjectCache = distributedMaps.get(name);
            if (distributedObjectCache == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("getMap() Existing DistributedObjectCache not found for " + name), (Object[])new Object[0]);
                }
                distributedObjectCache = DistributedObjectCacheFactory.createDistributedObjectCache(name, properties);
                distributedMaps.put(name, distributedObjectCache);
            } else if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("getMap() Existing DistributedObjectCache found for " + name + " " + distributedObjectCache), (Object[])new Object[0]);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getMap() map:" + distributedObjectCache));
        }
        return distributedObjectCache;
    }

    public static DistributedObjectCache createDistributedObjectCache(String name, Properties properties) {
        Object distributedObjectCache;
        block13: {
            String methodName = "createDistributedObjectCache()";
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)("createDistributedObjectCache() name: " + name + " properties:" + properties), (Object[])new Object[0]);
            }
            if (!ServerCache.objectCacheEnabled) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("createDistributedObjectCache() WebSphere Dynamic Cache instance named " + name + " cannot be used because of Dynamic Object cache service has not be started."), (Object[])new Object[0]);
                }
                return null;
            }
            distributedObjectCache = null;
            DCache cache = ServerCache.getCache((String)name);
            if (cache == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("createDistributedObjectCache() Existing Cache not found for " + name), (Object[])new Object[0]);
                }
                CacheConfig cacheConfig = (CacheConfig)cacheService.getCacheInstanceConfig("baseCache").clone();
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("createDistributedObjectCache() cacheConfig:" + cacheConfig), (Object[])new Object[0]);
                }
                properties.put("com.ibm.ws.cache.CacheConfig.cacheName", name);
                cacheConfig.overrideCacheConfig(properties);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("createDistributedObjectCache() cacheConfig:" + cacheConfig), (Object[])new Object[0]);
                }
                try {
                    cacheService.addCacheInstanceConfig(cacheConfig, true);
                    distributedObjectCache = (DistributedObjectCache)ServerCache.cacheUnit.createObjectCache(name);
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("createDistributedObjectCache() DistributedMap " + name + " created from cache instance " + cache), (Object[])new Object[0]);
                    }
                    break block13;
                }
                catch (Exception e) {
                    if (tc.isDebugEnabled()) {
                        Tr.warning((TraceComponent)tc, (String)("createDistributedObjectCache() Exception:" + e.getMessage()), (Object[])new Object[0]);
                    }
                    break block13;
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("createDistributedObjectCache() Existing Cache found for " + name + " " + cache), (Object[])new Object[0]);
            }
            distributedObjectCache = cache.getCacheConfig().isEnableNioSupport() ? new DistributedNioMapImpl(cache) : new DistributedMapImpl(cache);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("createDistributedObjectCache() map:" + distributedObjectCache));
        }
        return distributedObjectCache;
    }

    public static void setCacheService(CacheService cacheService) {
        DistributedObjectCacheFactory.cacheService = cacheService;
    }

    public static void unsetCacheService(CacheServiceImpl cacheServiceImpl) {
        cacheService = null;
    }
}

