/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.security.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.common.encoder.Base64Coder;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.webcontainer.security.LoggedOutCookieCache;
import com.ibm.ws.webcontainer.security.LoggedOutCookieCacheHelper;
import com.ibm.ws.webcontainer.security.internal.LocalLoggedOutJwtSsoCookieCache;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(configurationPolicy=ConfigurationPolicy.IGNORE, property={"service.vendor=IBM"})
public class LoggedOutJwtSsoCookieCache {
    private static final TraceComponent tc = Tr.register(LoggedOutJwtSsoCookieCache.class, (String)"WebAppSecurity", (String)"com.ibm.ws.webcontainer.security.resources.WebAppSecurityMessages");
    private static MessageDigest CLONEABLE_MESSAGE_DIGEST = null;
    private static final String SHA_512 = "SHA-512";
    private static final Object SYNC_OBJECT = new Object();
    static final LocalLoggedOutJwtSsoCookieCache localCookieCache = new LocalLoggedOutJwtSsoCookieCache();
    static final long serialVersionUID = -1017368770812274953L;

    public static String toDigest(String input) {
        MessageDigest md = LoggedOutJwtSsoCookieCache.getMessageDigest();
        md.update(input.getBytes(StandardCharsets.UTF_8));
        String result = Base64Coder.base64EncodeToString((byte[])md.digest());
        return result;
    }

    public static boolean contains(String tokenString) {
        LoggedOutCookieCache service = LoggedOutCookieCacheHelper.getLoggedOutCookieCacheService();
        String digest = LoggedOutJwtSsoCookieCache.toDigest(tokenString);
        if (service == null) {
            return localCookieCache.contains(digest);
        }
        return service.contains(digest);
    }

    public static void put(String tokenString) {
        LoggedOutCookieCache service = LoggedOutCookieCacheHelper.getLoggedOutCookieCacheService();
        String digest = LoggedOutJwtSsoCookieCache.toDigest(tokenString);
        if (service == null) {
            localCookieCache.put(digest);
        } else {
            service.put(digest, Boolean.TRUE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Trivial
    @FFDCIgnore(value={CloneNotSupportedException.class, NoSuchAlgorithmException.class})
    private static MessageDigest getMessageDigest() {
        if (CLONEABLE_MESSAGE_DIGEST == null) {
            Object object = SYNC_OBJECT;
            synchronized (object) {
                if (CLONEABLE_MESSAGE_DIGEST == null) {
                    try {
                        CLONEABLE_MESSAGE_DIGEST = MessageDigest.getInstance(SHA_512);
                    }
                    catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                        // empty catch block
                    }
                }
            }
        }
        try {
            return (MessageDigest)CLONEABLE_MESSAGE_DIGEST.clone();
        }
        catch (CloneNotSupportedException cnse) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"CloneNotSupportedException caught while trying to clone MessageDigest with algorithm SHA-512. This is pretty unlikely, and we need to get details about the JDK which is in use.", (Object[])new Object[]{cnse});
            }
            try {
                return MessageDigest.getInstance(SHA_512);
            }
            catch (NoSuchAlgorithmException nsae) {
                return null;
            }
        }
    }
}

