/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.kernel.filemonitor.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.kernel.filemonitor.internal.UpdateMonitor;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.File;
import java.util.Collection;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class FileUpdateMonitor
extends UpdateMonitor {
    static final TraceComponent tc = Tr.register(FileUpdateMonitor.class, (String)"fileMonitor", (String)"com.ibm.ws.kernel.filemonitor.internal.resources.Messages");
    private boolean exists = false;
    private long monitoredTime = 0L;
    private long monitoredSize = 0L;
    static final long serialVersionUID = 3214520013827285460L;

    protected FileUpdateMonitor(File monitoredFile) {
        super(monitoredFile, UpdateMonitor.MonitorType.FILE);
    }

    @Override
    public void init(Collection<File> baseline) {
        this.exists = this.monitoredFile.isFile();
        this.performScan(this.monitoredFile);
        if (this.exists) {
            this.addToList(baseline, this.monitoredFile);
        }
    }

    @Override
    protected void destroy() {
    }

    @Override
    public void scanForUpdates(Collection<File> created, Collection<File> modified, Collection<File> deleted) {
        if (this.monitoredFile.isFile()) {
            if (this.performScan(this.monitoredFile)) {
                if (this.exists) {
                    this.addToList(modified, this.monitoredFile);
                } else {
                    this.exists = true;
                    this.addToList(created, this.monitoredFile);
                }
            }
        } else if (this.exists) {
            this.addToList(deleted, this.monitoredFile);
            this.exists = false;
            this.monitoredTime = 0L;
            this.monitoredSize = 0L;
        }
    }

    private boolean performScan(File monitoredFile) {
        long newTime = monitoredFile.lastModified();
        long newSize = monitoredFile.length();
        if (newTime != this.monitoredTime || newSize != this.monitoredSize) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"performScan", (Object[])new Object[]{"File with name = '" + monitoredFile.getName() + "' has been modified. monitoredTime = " + this.monitoredTime + " newTime = " + newTime + " monitoredSize = " + this.monitoredSize + " newSize = " + newSize});
            }
            this.monitoredTime = newTime;
            this.monitoredSize = newSize;
            return true;
        }
        return false;
    }
}

