/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.logging.data;

import com.ibm.ws.logging.data.GenericData;
import com.ibm.ws.logging.data.KeyValuePairList;
import com.ibm.ws.logging.data.NameAliases;
import com.ibm.ws.logging.utils.SequenceNumber;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LogTraceData
extends GenericData {
    static Pattern messagePattern = Pattern.compile("^([A-Z][\\dA-Z]{3,4})(\\d{4})([A-Z])(:)");
    private long rawSequenceNumber = -1L;
    private boolean isTr;
    public static final String[] NAMES_JSON = new String[]{"ibm_datetime", "ibm_messageId", "ibm_threadId", "module", "severity", "loglevel", "ibm_methodName", "ibm_className", "levelValue", "threadName", "correlationId", "org", "product", "component", "ibm_sequence", "ibm_stackTrace", "ibm_stackTrace_localized", "message", "formattedMsg", "extensions", "objectId", "host", "ibm_userDir", "ibm_serverName", "type", "ibm_exceptionName"};
    private static final String[] NAMES_LC = new String[]{"datetime", "messageId", "threadId", "loggerName", "severity", "loglevel", "methodName", "className", "levelValue", "threadName", "correlationId", "org", "product", "component", "sequence", "stackTrace", "stackTrace_localized", "message", "formattedMsg", "extensions", "objectId", "hostName", "wlpUserDir", "serverName", "type", "exceptionName"};
    public static String[] MESSAGE_NAMES_JSON = new String[]{"ibm_datetime", "ibm_messageId", "ibm_threadId", "module", "severity", "loglevel", "ibm_methodName", "ibm_className", "levelValue", "threadName", "correlationId", "org", "product", "component", "ibm_sequence", "ibm_stackTrace", "ibm_stackTrace_localized", "message", "formattedMsg", "extensions", "objectId", "host", "ibm_userDir", "ibm_serverName", "type", "ibm_exceptionName"};
    public static String[] TRACE_NAMES_JSON = new String[]{"ibm_datetime", "ibm_messageId", "ibm_threadId", "module", "severity", "loglevel", "ibm_methodName", "ibm_className", "levelValue", "threadName", "correlationId", "org", "product", "component", "ibm_sequence", "ibm_stackTrace", "ibm_stackTrace_localized", "message", "formattedMsg", "extensions", "objectId", "host", "ibm_userDir", "ibm_serverName", "type", "ibm_exceptionName"};
    private static NameAliases jsonLoggingNameAliasesMessages = new NameAliases(MESSAGE_NAMES_JSON);
    private static NameAliases jsonLoggingNameAliasesTrace = new NameAliases(TRACE_NAMES_JSON);
    private static NameAliases logstashNameAliasesMessages = new NameAliases(NAMES_LC);
    private static NameAliases logstashNameAliasesTrace = new NameAliases(NAMES_LC);
    private static NameAliases[] nameAliasesMessages = new NameAliases[]{jsonLoggingNameAliasesMessages, logstashNameAliasesMessages};
    private static NameAliases[] nameAliasesTrace = new NameAliases[]{jsonLoggingNameAliasesTrace, logstashNameAliasesTrace};

    public static void newJsonLoggingNameAliasesMessage(Map<String, String> newAliases) {
        jsonLoggingNameAliasesMessages.newAliases(newAliases);
    }

    public static void newJsonLoggingNameAliasesTrace(Map<String, String> newAliases) {
        jsonLoggingNameAliasesTrace.newAliases(newAliases);
    }

    public static void resetJsonLoggingNameAliasesMessage() {
        jsonLoggingNameAliasesMessages.resetAliases();
    }

    public static void resetJsonLoggingNameAliasesTrace() {
        jsonLoggingNameAliasesTrace.resetAliases();
    }

    public LogTraceData() {
        super(26);
    }

    private void setPair(int index, String s) {
        this.setPair(index, NAMES_JSON[index], s);
    }

    private void setPair(int index, int i) {
        this.setPair(index, NAMES_JSON[index], i);
    }

    private void setPair(int index, long l) {
        this.setPair(index, NAMES_JSON[index], l);
    }

    private KeyValuePairList getValues(int index) {
        return (KeyValuePairList)this.getPairs()[index];
    }

    public void setDatetime(long l) {
        this.setPair(0, l);
    }

    public void setMessageId(String s) {
        this.setPair(1, s);
    }

    public void setThreadId(int i) {
        this.setPair(2, i);
    }

    public void setModule(String s) {
        this.setPair(3, s);
    }

    public void setSeverity(String s) {
        this.setPair(4, s);
    }

    public void setLoglevel(String s) {
        this.setPair(5, s);
    }

    public void setMethodName(String s) {
        this.setPair(6, s);
    }

    public void setClassName(String s) {
        this.setPair(7, s);
    }

    public void setLevelValue(int i) {
        this.setPair(8, i);
    }

    public void setThreadName(String s) {
        this.setPair(9, s);
    }

    public void setCorrelationId(String s) {
        this.setPair(10, s);
    }

    public void setOrg(String s) {
        this.setPair(11, s);
    }

    public void setProduct(String s) {
        this.setPair(12, s);
    }

    public void setComponent(String s) {
        this.setPair(13, s);
    }

    public void setSequence(String s) {
        this.setPair(14, s);
    }

    public void setStackTrace(String s) {
        this.setPair(15, s);
    }

    public void setStackTraceLocalized(String s) {
        this.setPair(16, s);
    }

    public void setMessage(String s) {
        this.setPair(17, s);
    }

    public void setFormattedMsg(String s) {
        this.setPair(18, s);
    }

    public void setExtensions(KeyValuePairList kvps) {
        this.setPair(19, kvps);
    }

    public void setObjectId(int i) {
        this.setPair(20, i);
    }

    public void setExceptionName(String s) {
        this.setPair(25, s);
    }

    public static String getDatetimeKey(int format, boolean isMessageEvent) {
        return isMessageEvent ? LogTraceData.nameAliasesMessages[format].aliases[0] : LogTraceData.nameAliasesTrace[format].aliases[0];
    }

    public static String getMessageIdKey(int format, boolean isMessageEvent) {
        return isMessageEvent ? LogTraceData.nameAliasesMessages[format].aliases[1] : LogTraceData.nameAliasesTrace[format].aliases[1];
    }

    public static String getThreadIdKey(int format, boolean isMessageEvent) {
        return isMessageEvent ? LogTraceData.nameAliasesMessages[format].aliases[2] : LogTraceData.nameAliasesTrace[format].aliases[2];
    }

    public static String getModuleKey(int format, boolean isMessageEvent) {
        return isMessageEvent ? LogTraceData.nameAliasesMessages[format].aliases[3] : LogTraceData.nameAliasesTrace[format].aliases[3];
    }

    public static String getSeverityKey(int format, boolean isMessageEvent) {
        return isMessageEvent ? LogTraceData.nameAliasesMessages[format].aliases[4] : LogTraceData.nameAliasesTrace[format].aliases[4];
    }

    public static String getLoglevelKey(int format, boolean isMessageEvent) {
        return isMessageEvent ? LogTraceData.nameAliasesMessages[format].aliases[5] : LogTraceData.nameAliasesTrace[format].aliases[5];
    }

    public static String getMethodNameKey(int format, boolean isMessageEvent) {
        return isMessageEvent ? LogTraceData.nameAliasesMessages[format].aliases[6] : LogTraceData.nameAliasesTrace[format].aliases[6];
    }

    public static String getClassNameKey(int format, boolean isMessageEvent) {
        return isMessageEvent ? LogTraceData.nameAliasesMessages[format].aliases[7] : LogTraceData.nameAliasesTrace[format].aliases[7];
    }

    public static String getLevelValueKey(int format, boolean isMessageEvent) {
        return isMessageEvent ? LogTraceData.nameAliasesMessages[format].aliases[8] : LogTraceData.nameAliasesTrace[format].aliases[8];
    }

    public static String getThreadNameKey(int format, boolean isMessageEvent) {
        return isMessageEvent ? LogTraceData.nameAliasesMessages[format].aliases[9] : LogTraceData.nameAliasesTrace[format].aliases[9];
    }

    public static String getCorrelationIdKey(int format, boolean isMessageEvent) {
        return isMessageEvent ? LogTraceData.nameAliasesMessages[format].aliases[10] : LogTraceData.nameAliasesTrace[format].aliases[10];
    }

    public static String getOrgKey(int format, boolean isMessageEvent) {
        return isMessageEvent ? LogTraceData.nameAliasesMessages[format].aliases[11] : LogTraceData.nameAliasesTrace[format].aliases[11];
    }

    public static String getProductKey(int format, boolean isMessageEvent) {
        return isMessageEvent ? LogTraceData.nameAliasesMessages[format].aliases[12] : LogTraceData.nameAliasesTrace[format].aliases[12];
    }

    public static String getComponentKey(int format, boolean isMessageEvent) {
        return isMessageEvent ? LogTraceData.nameAliasesMessages[format].aliases[13] : LogTraceData.nameAliasesTrace[format].aliases[13];
    }

    public static String getSequenceKey(int format, boolean isMessageEvent) {
        return isMessageEvent ? LogTraceData.nameAliasesMessages[format].aliases[14] : LogTraceData.nameAliasesTrace[format].aliases[14];
    }

    public static String getStackTraceKey(int format, boolean isMessageEvent) {
        return isMessageEvent ? LogTraceData.nameAliasesMessages[format].aliases[15] : LogTraceData.nameAliasesTrace[format].aliases[15];
    }

    public static String getStackTraceLocalizedKey(int format, boolean isMessageEvent) {
        return isMessageEvent ? LogTraceData.nameAliasesMessages[format].aliases[16] : LogTraceData.nameAliasesTrace[format].aliases[16];
    }

    public static String getMessageKey(int format, boolean isMessageEvent) {
        return isMessageEvent ? LogTraceData.nameAliasesMessages[format].aliases[17] : LogTraceData.nameAliasesTrace[format].aliases[17];
    }

    public static String getFormattedMsgKey(int format, boolean isMessageEvent) {
        return isMessageEvent ? LogTraceData.nameAliasesMessages[format].aliases[18] : LogTraceData.nameAliasesTrace[format].aliases[18];
    }

    public static String getExtensionsKey(int format, boolean isMessageEvent) {
        return isMessageEvent ? LogTraceData.nameAliasesMessages[format].aliases[19] : LogTraceData.nameAliasesTrace[format].aliases[19];
    }

    public static String getObjectIdKey(int format, boolean isMessageEvent) {
        return isMessageEvent ? LogTraceData.nameAliasesMessages[format].aliases[20] : LogTraceData.nameAliasesTrace[format].aliases[20];
    }

    public static String getHostKey(int format, boolean isMessageEvent) {
        return isMessageEvent ? LogTraceData.nameAliasesMessages[format].aliases[21] : LogTraceData.nameAliasesTrace[format].aliases[21];
    }

    public static String getUserDirKey(int format, boolean isMessageEvent) {
        return isMessageEvent ? LogTraceData.nameAliasesMessages[format].aliases[22] : LogTraceData.nameAliasesTrace[format].aliases[22];
    }

    public static String getServerNameKey(int format, boolean isMessageEvent) {
        return isMessageEvent ? LogTraceData.nameAliasesMessages[format].aliases[23] : LogTraceData.nameAliasesTrace[format].aliases[23];
    }

    public static String getTypeKey(int format, boolean isMessageEvent) {
        return isMessageEvent ? LogTraceData.nameAliasesMessages[format].aliases[24] : LogTraceData.nameAliasesTrace[format].aliases[24];
    }

    public static String getExtensionNameKeyJSON(boolean isMessageEvent, String extKey) {
        NameAliases.ExtensionAliases tempExt = null;
        tempExt = isMessageEvent ? LogTraceData.jsonLoggingNameAliasesMessages.extensionAliases : LogTraceData.jsonLoggingNameAliasesTrace.extensionAliases;
        return tempExt.getAlias(extKey);
    }

    public static String getExceptionNameKey(int format, boolean isMessageEvent) {
        return isMessageEvent ? LogTraceData.nameAliasesMessages[format].aliases[25] : LogTraceData.nameAliasesTrace[format].aliases[25];
    }

    public long getDatetime() {
        return this.getLongValue(0);
    }

    public String getMessageId() {
        String message;
        String messageId = this.getStringValue(1);
        if ((messageId == null || messageId.isEmpty()) && (message = this.getMessage()) != null) {
            messageId = this.parseMessageId(message);
            this.setPair(1, NAMES_JSON[1], messageId);
        }
        return messageId;
    }

    public int getThreadId() {
        return this.getIntValue(2);
    }

    public String getModule() {
        return this.getStringValue(3);
    }

    public String getSeverity() {
        return this.getStringValue(4);
    }

    public String getLoglevel() {
        return this.getStringValue(5);
    }

    public String getMethodName() {
        return this.getStringValue(6);
    }

    public String getClassName() {
        return this.getStringValue(7);
    }

    public int getLevelValue() {
        return this.getIntValue(8);
    }

    public String getThreadName() {
        return this.getStringValue(9);
    }

    public String getCorrelationId() {
        return this.getStringValue(10);
    }

    public String getOrg() {
        return this.getStringValue(11);
    }

    public String getProduct() {
        return this.getStringValue(12);
    }

    public String getComponent() {
        return this.getStringValue(13);
    }

    public String getSequence() {
        String sequenceId = this.getStringValue(14);
        if (sequenceId == null || sequenceId.isEmpty()) {
            sequenceId = SequenceNumber.formatSequenceNumber(this.getDatetime(), this.rawSequenceNumber);
            this.setPair(14, NAMES_JSON[14], sequenceId);
        }
        return sequenceId;
    }

    public String getThrowable() {
        return this.getStringValue(15);
    }

    public String getThrowableLocalized() {
        return this.getStringValue(16);
    }

    public String getMessage() {
        return this.getStringValue(17);
    }

    public String getFormattedMsg() {
        return this.getStringValue(18);
    }

    public KeyValuePairList getExtensions() {
        return this.getValues(19);
    }

    public int getObjectId() {
        return this.getIntValue(20);
    }

    public String getExceptionName() {
        return this.getStringValue(25);
    }

    public void setRawSequenceNumber(long l) {
        this.rawSequenceNumber = l;
    }

    public long getRawSequenceNumber(long l) {
        return this.rawSequenceNumber;
    }

    protected String parseMessageId(String msg) {
        String messageId = null;
        Matcher matcher = messagePattern.matcher(msg);
        if (matcher.find()) {
            messageId = msg.substring(matcher.start(), matcher.end() - 1);
        }
        return messageId;
    }

    public boolean isTr() {
        return this.isTr;
    }

    public void setTr(boolean isTr) {
        this.isTr = isTr;
    }
}

